/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.impl.RMIChannelOwner;
import com.devexperts.rmi.impl.RMITaskImpl;
import com.devexperts.rmi.task.RMIChannelType;
import com.devexperts.util.IndexedSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class RunningTask {
    private final IndexedSet<Long, RMITaskImpl<?>> serverChannelTasks = IndexedSet.createLong(RMITaskImpl.TASK_INDEXER_BY_ID);
    private final EnumMap<RMIChannelType, Map<Long, IndexedSet<Long, RMITaskImpl<?>>>> mapNestedTask = new EnumMap(RMIChannelType.class);

    RunningTask() {
    }

    synchronized void add(RMITaskImpl<?> task) {
        if (!task.isNestedTask()) {
            this.serverChannelTasks.add(task);
            return;
        }
        IndexedSet<Long, RMITaskImpl<?>> set = this.getMap(task.getChannel().getType()).get(task.getChannelId());
        if (set == null) {
            set = IndexedSet.createLong(RMITaskImpl.TASK_INDEXER_BY_ID);
            this.getMap(task.getChannel().getType()).put(task.getChannelId(), set);
        }
        set.add(task);
    }

    synchronized void remove(RMITaskImpl<?> task) {
        assert (task.isNestedTask());
        IndexedSet<Long, RMITaskImpl<?>> set = this.getMap(task.getChannel().getType()).get(task.getChannelId());
        if (set == null) {
            return;
        }
        set.remove(task);
        if (set.isEmpty()) {
            this.getMap(task.getChannel().getType()).remove(task.getChannelId());
        }
    }

    synchronized void remove(RMIChannelOwner owner, long channelId) {
        IndexedSet<Long, RMITaskImpl<?>> set = this.getMap(owner.getChannelType()).get(channelId);
        if (set != null && !set.isEmpty()) {
            for (RMITaskImpl<?> runTask : set) {
                runTask.completeExceptionally(RMIExceptionType.CHANNEL_CLOSED, null);
            }
        }
        if (owner.getChannelType() == RMIChannelType.SERVER_CHANNEL) {
            this.serverChannelTasks.remove(owner);
        }
    }

    synchronized RMITaskImpl<?> removeById(long requestId, long channelId, RMIChannelType type) {
        if (channelId == 0L) {
            return this.serverChannelTasks.removeKey(requestId);
        }
        IndexedSet<Long, RMITaskImpl<?>> set = this.getMap(type).get(channelId);
        if (set == null || set.isEmpty()) {
            return null;
        }
        return set.removeKey(requestId);
    }

    synchronized Set<RMITaskImpl<?>> removeAllById(long channelId, RMIChannelType type) {
        IndexedSet<Long, RMITaskImpl<?>> set = this.getMap(type).get(channelId);
        if (set == null || set.isEmpty()) {
            return null;
        }
        HashSet result = new HashSet((Collection)this.getMap(type).get(channelId));
        set.clear();
        return result;
    }

    synchronized void close() {
        RMITaskImpl[] channelTasksArray;
        for (RMIChannelType type : RMIChannelType.values()) {
            IndexedSet[] mapNestedTasksArray;
            for (IndexedSet nestedTasks : mapNestedTasksArray = this.getMap(type).values().toArray(new IndexedSet[this.getMap(type).size()])) {
                RMITaskImpl[] nestedTasksArray;
                for (RMITaskImpl task : nestedTasksArray = nestedTasks.toArray(new RMITaskImpl[nestedTasks.size()])) {
                    task.cancel(RMIExceptionType.DISCONNECTION);
                }
            }
        }
        for (RMITaskImpl task : channelTasksArray = this.serverChannelTasks.toArray(new RMITaskImpl[this.serverChannelTasks.size()])) {
            task.cancel(RMIExceptionType.DISCONNECTION);
        }
    }

    boolean hasServerChannelTask() {
        return !this.serverChannelTasks.isEmpty();
    }

    private Map<Long, IndexedSet<Long, RMITaskImpl<?>>> getMap(RMIChannelType type) {
        return this.mapNestedTask.computeIfAbsent(type, k -> new HashMap());
    }
}

