/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.logging.Logging;
import com.devexperts.rmi.impl.OutgoingRequests;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIMessageKind;
import com.devexperts.rmi.impl.RMIQueueType;
import com.devexperts.rmi.impl.RMIRequestImpl;
import com.devexperts.rmi.impl.SentRequests;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import java.util.List;
import javax.annotation.Nullable;

class RequestsManager {
    private static final Logging log = Logging.getLogging(RequestsManager.class);
    private final OutgoingRequests outgoingRequests;
    private final SentRequests sentRequests = new SentRequests();
    private final RMIConnection connection;
    private volatile boolean anonymous = true;

    RequestsManager(RMIConnection connection) {
        this.connection = connection;
        this.outgoingRequests = new OutgoingRequests(connection.configuredServices);
    }

    void setAnonymousOnDescribeProtocol(boolean anonymous) {
        this.anonymous = anonymous;
        if (anonymous && this.connection.side.hasClient()) {
            this.connection.endpoint.getClient().updateServiceDescriptors(null, this.connection);
        }
    }

    boolean isAnonymous() {
        return this.anonymous;
    }

    void addSentRequest(RMIRequestImpl<?> request) {
        this.sentRequests.addSentRequest(request);
    }

    RMIRequestImpl<?> removeSentRequest(long channelId, long curId, RMIMessageKind kind) {
        return this.sentRequests.removeSentRequest(channelId, curId, kind);
    }

    RMIRequestImpl<?>[] getSentRequests(RMIRequestImpl<?>[] requests) {
        return this.sentRequests.getSentRequests(requests);
    }

    void addOutgoingRequest(RMIRequestImpl<?> request) {
        if (this.connection.closed) {
            return;
        }
        if (this.anonymous) {
            request.setTentativeTarget(null);
        }
        if (RMIEndpointImpl.RMI_TRACE_LOG) {
            log.trace("Add outgoing request " + request + " to " + this.connection);
        }
        request.assignConnection(this.connection);
        this.outgoingRequests.add(request);
        this.connection.messageAdapter.rmiMessageAvailable(RMIQueueType.REQUEST);
    }

    @Nullable
    List<RMIRequestImpl<?>> getByDescriptorsAndRemove(@Nullable List<RMIServiceDescriptor> descriptors) {
        if (descriptors == null && !this.anonymous) {
            return null;
        }
        return this.outgoingRequests.getByDescriptorsAndRemove(descriptors);
    }

    RMIRequestImpl<?> pollOutgoingRequest() {
        return this.outgoingRequests.poll();
    }

    int outgoingRequestSize() {
        return this.outgoingRequests.size();
    }

    boolean removeOutgoingRequest(RMIRequestImpl<?> request) {
        return this.outgoingRequests.remove(request);
    }

    RMIRequestImpl<?>[] getOutgoingRequests(RMIRequestImpl<?>[] requests) {
        return this.outgoingRequests.getRequests(requests);
    }

    void close() {
        this.sentRequests.close();
    }
}

