/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.logging.Logging;
import com.devexperts.rmi.RMIRequestState;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIRequestImpl;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

class RMITimeoutRequestMonitoringThread
implements Runnable {
    private static final Thread.UncaughtExceptionHandler UNCAUGHT_EXCEPTION_HANDLER = (t, e) -> Logging.getLogging(RMITimeoutRequestMonitoringThread.class).error("Uncaught exception", e);
    private final WeakReference<RMIEndpointImpl> endpointReference;
    private volatile Thread thread;

    RMITimeoutRequestMonitoringThread(RMIEndpointImpl endpoint) {
        this.endpointReference = new WeakReference<RMIEndpointImpl>(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startIfNotAlive() {
        Thread t = this.thread;
        if (t != null && t.isAlive()) {
            return;
        }
        RMITimeoutRequestMonitoringThread rMITimeoutRequestMonitoringThread = this;
        synchronized (rMITimeoutRequestMonitoringThread) {
            t = this.thread;
            if (t != null && t.isAlive()) {
                return;
            }
            RMIEndpointImpl endpoint = (RMIEndpointImpl)this.endpointReference.get();
            if (endpoint == null) {
                return;
            }
            this.thread = new Thread((Runnable)this, endpoint.getName() + "-" + RMITimeoutRequestMonitoringThread.class.getSimpleName());
            this.thread.setDaemon(true);
            this.thread.setUncaughtExceptionHandler(UNCAUGHT_EXCEPTION_HANDLER);
            this.thread.start();
        }
    }

    synchronized void stop() {
        Thread t = this.thread;
        this.thread = null;
        LockSupport.unpark(t);
    }

    void wakeUp() {
        LockSupport.unpark(this.thread);
    }

    @Override
    public void run() {
        RMIEndpointImpl endpoint;
        RMIRequestImpl[] requests = new RMIRequestImpl[]{};
        while (!((endpoint = (RMIEndpointImpl)this.endpointReference.get()) == null || endpoint.isClosed() || this.thread != null && this.thread != Thread.currentThread())) {
            long requestSendingTimeout = endpoint.getClient().getRequestSendingTimeout();
            long requestRunningTimeout = endpoint.getClient().getRequestRunningTimeout();
            AtomicBoolean hasActiveRequests = new AtomicBoolean();
            long currentTime = System.currentTimeMillis();
            Iterator<RMIConnection> it = endpoint.concurrentConnectionsIterator();
            while (it.hasNext()) {
                RMIRequestImpl request2;
                int j;
                RMIConnection connection = it.next();
                requests = connection.requestsManager.getSentRequests(requests);
                for (j = 0; j < requests.length && (request2 = requests[j]) != null && !request2.isNestedRequest(); ++j) {
                    requests[j] = null;
                    if (currentTime - request2.getRunningStartTime() > requestRunningTimeout) {
                        request2.abortOnTimeout(RMIRequestState.SENT);
                        continue;
                    }
                    hasActiveRequests.set(true);
                }
                requests = connection.requestsManager.getOutgoingRequests(requests);
                for (j = 0; j < requests.length && (request2 = requests[j]) != null && !request2.isNestedRequest(); ++j) {
                    requests[j] = null;
                    if (currentTime - request2.getSendTime() > requestSendingTimeout) {
                        request2.abortOnTimeout(RMIRequestState.WAITING_TO_SEND);
                        connection.requestsManager.removeOutgoingRequest(request2);
                        continue;
                    }
                    hasActiveRequests.set(true);
                }
            }
            endpoint.getClient().forEachPendingRequest(request -> {
                if (currentTime - request.getSendTime() > requestSendingTimeout) {
                    if (request.removeFromSendingQueues()) {
                        request.abortOnTimeout(RMIRequestState.WAITING_TO_SEND);
                    }
                } else {
                    hasActiveRequests.set(true);
                }
            });
            if (this.thread == null && !hasActiveRequests.get()) break;
            long sleepTime = Math.max(1000L, Math.min(requestSendingTimeout, requestRunningTimeout) / 2L);
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(sleepTime));
        }
    }
}

