/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.impl.RMIChannelImpl;
import com.devexperts.rmi.impl.RMIMessageKind;
import com.devexperts.rmi.impl.RMITaskImpl;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIResponseMessage;
import com.devexperts.rmi.message.RMIResponseType;
import com.devexperts.rmi.task.RMIChannelType;
import com.devexperts.rmi.task.RMITaskState;

class RMITaskResponse {
    final RMIResponseMessage responseMessage;
    final RMIRequestMessage<?> requestMessage;
    final long channelId;
    final long requestId;
    final RMITaskState state;
    final RMIMessageKind kind;

    RMITaskResponse(RMITaskImpl<?> task) {
        this.responseMessage = task.getResponseMessage();
        this.requestMessage = task.getRequestMessage();
        this.channelId = ((RMIChannelImpl)task.getChannel()).getChannelId();
        this.requestId = task.getRequestId();
        this.state = task.getState();
        boolean nested = task.isNestedTask();
        this.kind = RMIMessageKind.getKind(this.responseMessage, nested ? task.getChannel().getType() : null);
    }

    RMITaskResponse(RMIResponseMessage responseMessage, long channelId, long requestId, RMIChannelType type) {
        this.responseMessage = responseMessage;
        this.requestMessage = null;
        this.channelId = channelId;
        this.requestId = requestId;
        this.state = responseMessage.getType() == RMIResponseType.ERROR ? RMITaskState.FAILED : RMITaskState.SUCCEEDED;
        this.kind = RMIMessageKind.getKind(responseMessage, type);
    }

    public String toString() {
        return "RMITaskResponse{responseMessage=" + this.responseMessage + ", requestMessage=" + this.requestMessage + ", channelId=" + this.channelId + ", requestId=" + this.requestId + ", state=" + (Object)((Object)this.state) + ", kind=" + (Object)((Object)this.kind) + '}';
    }
}

