/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.io.Marshalled;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIExecutionTask;
import com.devexperts.rmi.impl.RMIChannelImpl;
import com.devexperts.rmi.impl.RMIChannelOwner;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIExecutionTaskImpl;
import com.devexperts.rmi.impl.RMILog;
import com.devexperts.rmi.impl.TasksManager;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.message.RMIResponseMessage;
import com.devexperts.rmi.security.SecurityController;
import com.devexperts.rmi.task.RMIChannel;
import com.devexperts.rmi.task.RMIChannelType;
import com.devexperts.rmi.task.RMILocalService;
import com.devexperts.rmi.task.RMITask;
import com.devexperts.util.IndexerFunction;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.function.Function;

public class RMITaskImpl<T>
extends RMITask<T>
implements RMIChannelOwner {
    static final IndexerFunction.LongKey<RMITaskImpl<?>> TASK_INDEXER_BY_ID = value -> value.requestId;
    private final long requestId;
    private final TasksManager tasksManager;
    private final SecurityController securityController;
    final RMIChannelImpl channel;
    private Executor executor;
    private RMIExecutionTaskImpl<T> executionTask;

    static <T> RMITaskImpl<T> createTopLevelTask(Marshalled<?> subject, RMIRequestMessage<T> requestMessage, RMIConnection connection, long requestId) {
        RMITaskImpl<T> task = new RMITaskImpl<T>(requestMessage, connection, requestId, owner -> new RMIChannelImpl(connection.endpoint, subject, requestId, (RMIChannelOwner)owner));
        if (requestMessage.getRequestType() != RMIRequestType.ONE_WAY) {
            task.channel.registerChannel(connection);
        }
        return task;
    }

    static <T> RMITaskImpl<T> createNestedTask(RMIRequestMessage<T> requestMessage, RMIConnection connection, RMIChannelImpl channel, long requestId) {
        return new RMITaskImpl<T>(requestMessage, connection, requestId, owner -> channel);
    }

    private RMITaskImpl(RMIRequestMessage<T> requestMessage, RMIConnection connection, long requestId, Function<RMITaskImpl<?>, RMIChannelImpl> channelSource) {
        super(requestMessage, connection.variables());
        this.requestId = requestId;
        this.tasksManager = connection.tasksManager;
        this.securityController = connection.endpoint.getSecurityController();
        this.channel = channelSource.apply(this);
    }

    @Override
    protected RMIExceptionType getCancelTypeSyncImpl() {
        assert (Thread.holdsLock(this));
        if (this.executionTask == null) {
            return RMIExceptionType.CANCELLED_BEFORE_EXECUTION;
        }
        switch (this.executionTask.getState()) {
            case NEW: 
            case SUBMITTED: {
                return RMIExceptionType.CANCELLED_BEFORE_EXECUTION;
            }
        }
        return RMIExceptionType.CANCELLED_DURING_EXECUTION;
    }

    protected void suspendImpl() {
        this.suspendImpl(null);
    }

    @Override
    protected void scheduleCallableOnResume(final Callable<T> callable) {
        this.executionTask.resume(new RMILocalService<T>("ContinuationService", null){

            @Override
            public T invoke(RMITask<T> task) throws Exception {
                return callable.call();
            }
        });
    }

    @Override
    protected void completeResponseImpl(RMIResponseMessage responseMessage, boolean submitNextInQueue) {
        super.completeResponseImpl(responseMessage, submitNextInQueue);
    }

    @Override
    protected void taskCompleted(RMITask<T> task, RMIResponseMessage response, boolean submitNextInQueue) {
        response.getMarshalledResult().getBytes();
        if (!this.isNestedTask()) {
            this.channel.close();
        } else {
            this.tasksManager.notifyTaskCompleted(this);
        }
        if (this.executionTask != null) {
            this.executionTask.updateState(submitNextInQueue);
        }
    }

    @Override
    protected void logError(RMIExceptionType type, Throwable exception) {
        if (type == RMIExceptionType.APPLICATION_ERROR && !(exception instanceof RuntimeException) && !(exception instanceof Error)) {
            return;
        }
        RMILog.logExecutionError(this.executionTask, type, exception);
    }

    @Override
    public RMIChannel getChannel() {
        return this.channel;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public RMIChannelType getChannelType() {
        return RMIChannelType.SERVER_CHANNEL;
    }

    public SecurityController getSecurityController() {
        return this.securityController;
    }

    public RMIExecutionTask<T> getExecutionTask() {
        return this.executionTask;
    }

    void setExecutionTask(RMIExecutionTaskImpl<T> executionTask) {
        this.executionTask = executionTask;
    }

    long getRequestId() {
        return this.requestId;
    }

    long getChannelId() {
        return this.channel.getChannelId();
    }

    void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

