/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.RMIServer;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.ServerSideServices;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.task.BalanceResult;
import com.devexperts.rmi.task.RMIService;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.rmi.task.RMIServiceImplementation;
import com.devexperts.util.ExecutorProvider;
import com.dxfeed.promise.Promise;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;

public class RMIServerImpl
extends RMIServer {
    final RMIEndpointImpl endpoint;
    private final ExecutorProvider.Reference defaultExecutorReference;
    private final ServerSideServices services;

    RMIServerImpl(RMIEndpointImpl endpoint) {
        this.endpoint = endpoint;
        this.services = new ServerSideServices(this, endpoint.getRMILoadBalancerFactories());
        this.defaultExecutorReference = endpoint.getDefaultExecutorProvider().newReference();
    }

    @Override
    public <T> void export(T implementation, Class<T> serviceInterface) {
        this.export(new RMIServiceImplementation<T>(implementation, serviceInterface));
    }

    @Override
    public <T> void export(T implementation, Class<T> serviceInterface, String serviceName) {
        this.export(new RMIServiceImplementation<T>(implementation, serviceInterface, serviceName));
    }

    @Override
    public void export(RMIService<?> service) {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        this.services.put(service);
    }

    @Override
    public void unexport(RMIService<?> service) {
        if (service == null) {
            throw new NullPointerException("service is null");
        }
        this.services.remove(service);
    }

    @Override
    public Executor getDefaultExecutor() {
        return this.defaultExecutorReference.getOrCreateExecutor();
    }

    @Override
    public void setDefaultExecutor(Executor executor) {
        this.defaultExecutorReference.setExecutor(executor);
    }

    void close() {
        this.services.close();
        this.defaultExecutorReference.close();
    }

    RMIService<?> getProvidedService(RMIServiceId target) {
        return this.services.getService(target);
    }

    void sendAllDescriptorsToConnection(RMIConnection connection) {
        this.services.sendAllDescriptorsToConnection(connection);
    }

    void sendDescriptorsToAllConnections(List<RMIServiceDescriptor> descriptors) {
        if (descriptors == null || descriptors.isEmpty()) {
            return;
        }
        Iterator<RMIConnection> it = this.endpoint.concurrentConnectionsIterator();
        while (it.hasNext()) {
            RMIConnection connection = it.next();
            connection.serverDescriptorsManager.addServiceDescriptors(descriptors);
        }
    }

    Promise<BalanceResult> balance(RMIRequestMessage<?> message) {
        return this.services.balance(message);
    }
}

