/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.logging.Logging;
import com.devexperts.rmi.RMIException;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequest;
import com.devexperts.rmi.RMIServiceMethod;
import com.devexperts.rmi.RuntimeRMIException;
import com.devexperts.rmi.impl.ObjectMethods;
import com.devexperts.rmi.impl.RMIClientPortImpl;
import com.devexperts.rmi.message.RMIRequestType;
import com.dxfeed.promise.Promise;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

class RMIRequestInvocationHandler
implements InvocationHandler {
    private static final Logging log = Logging.getLogging(RMIRequestInvocationHandler.class);
    private static final StackTraceElement RMI_LAYER_SEPARATOR_FRAME = new StackTraceElement("com.devexperts.rmi", "<REMOTE-METHOD-INVOCATION>", null, -1);
    private final RMIClientPortImpl clientPort;
    private final String serviceName;
    private final EnumSet<ObjectMethods> objectOverrideMethods;
    private final Map<Method, RMIOperation<?>> operationCache = Collections.synchronizedMap(new HashMap());

    static void trimStackTrace(Throwable cause) {
        StackTraceElement[] remoteStackTrace = cause.getStackTrace();
        cause.fillInStackTrace();
        StackTraceElement[] localStackTrace = cause.getStackTrace();
        StackTraceElement[] combinedStackTrace = new StackTraceElement[remoteStackTrace.length + localStackTrace.length - 2];
        System.arraycopy(remoteStackTrace, 0, combinedStackTrace, 0, remoteStackTrace.length);
        combinedStackTrace[remoteStackTrace.length] = RMI_LAYER_SEPARATOR_FRAME;
        System.arraycopy(localStackTrace, 3, combinedStackTrace, remoteStackTrace.length + 1, localStackTrace.length - 3);
        cause.setStackTrace(combinedStackTrace);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] parameters) throws Throwable {
        if (method.getDeclaringClass().equals(Object.class) && !this.objectOverrideMethods.contains((Object)ObjectMethods.getMethod(method))) {
            return this.invokeObjMethod(ObjectMethods.getMethod(method), proxy, parameters);
        }
        RMIServiceMethod methodAnnotation = method.getAnnotation(RMIServiceMethod.class);
        RMIRequestType type = methodAnnotation != null ? methodAnnotation.type() : RMIRequestType.DEFAULT;
        RMIOperation operation = this.getOperation(method);
        Object[] params = parameters == null ? new Object[]{} : parameters;
        RMIRequest request = this.clientPort.createRequest(type, operation, params);
        request.send();
        try {
            if (method.getReturnType() == Promise.class) {
                return request.getPromise();
            }
            return request.getBlocking();
        }
        catch (RMIException e) {
            try {
                if (e.getType() == RMIExceptionType.APPLICATION_ERROR) {
                    Throwable cause = e.getCause();
                    RMIRequestInvocationHandler.trimStackTrace(cause);
                    throw cause;
                }
                throw e;
            }
            catch (RMIException e2) {
                for (Class<?> exceptionType : method.getExceptionTypes()) {
                    if (!exceptionType.isAssignableFrom(e2.getClass())) continue;
                    throw e2;
                }
                log.error("Exception in request:" + request, e2);
                throw new RuntimeRMIException(e2);
            }
        }
    }

    RMIRequestInvocationHandler(RMIClientPortImpl clientPort, String serviceName, EnumSet<ObjectMethods> objectOverrideMethods) {
        this.clientPort = clientPort;
        this.serviceName = serviceName;
        this.objectOverrideMethods = objectOverrideMethods;
    }

    private <T> RMIOperation<T> getOperation(Method method) {
        return this.operationCache.computeIfAbsent(method, m -> RMIOperation.valueOf(this.serviceName, m));
    }

    private Object invokeObjMethod(ObjectMethods method, Object proxy, Object[] parameters) {
        switch (method) {
            case TO_STRING: {
                return "RMIProxy@" + Integer.toHexString(System.identityHashCode(proxy)) + "{service=" + this.serviceName + ", endpoint=" + this.clientPort.getEndpoint().getName() + '}';
            }
            case EQUALS: {
                return proxy == parameters[0];
            }
            case HASH_CODE: {
                return System.identityHashCode(proxy);
            }
        }
        throw new AssertionError();
    }
}

