/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.io.Marshalled;
import com.devexperts.rmi.RMIException;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequest;
import com.devexperts.rmi.RMIRequestListener;
import com.devexperts.rmi.RMIRequestState;
import com.devexperts.rmi.impl.RMIChannelImpl;
import com.devexperts.rmi.impl.RMIChannelOwner;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIMessageKind;
import com.devexperts.rmi.impl.RMIPromiseImpl;
import com.devexperts.rmi.impl.RMIRequestInvocationHandler;
import com.devexperts.rmi.impl.RequestSender;
import com.devexperts.rmi.message.RMICancelType;
import com.devexperts.rmi.message.RMIErrorMessage;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.message.RMIResponseMessage;
import com.devexperts.rmi.message.RMIResultMessage;
import com.devexperts.rmi.message.RMIRoute;
import com.devexperts.rmi.task.RMIChannel;
import com.devexperts.rmi.task.RMIChannelState;
import com.devexperts.rmi.task.RMIChannelType;
import com.devexperts.rmi.task.RMIServiceId;
import com.dxfeed.promise.Promise;
import java.util.Comparator;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

public final class RMIRequestImpl<T>
extends RMIRequest<T>
implements RMIChannelOwner {
    static final Comparator<RMIRequestImpl<?>> REQUEST_COMPARATOR_BY_SENDING_TIME = (o1, o2) -> {
        int compare = Long.compare(o1.sendTime, o2.sendTime);
        if (compare != 0) {
            return compare;
        }
        return Long.compare(o1.id, o2.id);
    };
    static final RMIOperation<Void> ABORT_CANCEL = RMIOperation.valueOf("", Void.class, "ABORT_RUNNING", Long.TYPE);
    static final RMIOperation<Void> CANCEL_WITH_CONFIRMATION = RMIOperation.valueOf("", Void.class, "DEFAULT", Long.TYPE);
    private final long id;
    private volatile RMIRequestState state = RMIRequestState.NEW;
    private RequestSender requestSender;
    private final Marshalled<?> subject;
    private final RMIChannelImpl channel;
    private RMIRequestMessage<T> requestMessage;
    private RMIResponseMessage responseMessage;
    private Promise<T> promise;
    private volatile RMIServiceId tentativeTarget;
    private RMIRequestListener listener;
    private volatile long sendTime;
    private volatile long runningStartTime;
    private volatile long completionTime;
    private boolean wasUnmarshall;
    private final boolean nestedRequest;
    private final RequestLock requestLock = new RequestLock();
    @GuardedBy(value="requestLock")
    private volatile RMIConnection assignedConnection;
    private Executor executor;
    private final RMIMessageKind kind;

    static boolean isCancelOperation(RMIOperation<?> operation) {
        return operation.equals(ABORT_CANCEL) || operation.equals(CANCEL_WITH_CONFIRMATION);
    }

    public RMIRequestImpl(RequestSender requestSender, Marshalled<?> subject, RMIRequestMessage<T> requestMessage) {
        this.subject = subject;
        if (requestSender == null || requestMessage.getOperation() == null) {
            throw new NullPointerException();
        }
        this.requestSender = requestSender;
        this.requestMessage = requestMessage;
        this.id = requestSender.createRequestId();
        this.tentativeTarget = requestMessage.getTarget();
        this.channel = new RMIChannelImpl(requestSender.getEndpoint(), this.subject, this.id, this);
        this.nestedRequest = false;
        this.kind = RMIMessageKind.REQUEST;
    }

    public RMIRequestImpl(RequestSender requestSender, RMIChannelImpl channel, RMIRequestMessage<T> requestMessage) {
        this.subject = channel.getSubject();
        if (requestSender == null || requestMessage.getOperation() == null) {
            throw new NullPointerException();
        }
        this.requestSender = requestSender;
        this.requestMessage = requestMessage;
        this.id = requestSender.createRequestId();
        this.tentativeTarget = null;
        this.channel = channel;
        this.nestedRequest = true;
        this.kind = channel.getType() == RMIChannelType.SERVER_CHANNEL ? RMIMessageKind.SERVER_CHANNEL_REQUEST : RMIMessageKind.CLIENT_CHANNEL_REQUEST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setListener(RMIRequestListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener can not be null");
        }
        Notifier notifier = null;
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            if (this.listener != null) {
                throw new IllegalStateException("The listener has already been installed");
            }
            this.listener = listener;
            if (this.isCompleted()) {
                notifier = new Notifier();
            }
        }
        if (notifier != null) {
            notifier.notifyRequestListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExecutor(Executor executor) {
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            if (this.state != RMIRequestState.NEW) {
                throw new IllegalStateException("Executor can only be set before sending a request");
            }
            this.executor = executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send() {
        long sendingStartTime = System.currentTimeMillis();
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            if (this.state != RMIRequestState.NEW) {
                return;
            }
        }
        try {
            this.requestMessage.getParameters().getBytes();
        }
        catch (Throwable t) {
            this.setFailedState(RMIExceptionType.PARAMETERS_MARSHALLING_ERROR, t);
            return;
        }
        requestLock = this.requestLock;
        synchronized (requestLock) {
            if (this.state != RMIRequestState.NEW) {
                return;
            }
            this.sendTime = sendingStartTime;
            this.state = RMIRequestState.WAITING_TO_SEND;
        }
        this.requestSender.addOutgoingRequest(this);
    }

    @Override
    public boolean isCompleted() {
        return this.state.isCompleted();
    }

    @Override
    public boolean isOneWay() {
        return this.requestMessage.getRequestType() == RMIRequestType.ONE_WAY;
    }

    @Override
    public void cancelWithConfirmation() {
        this.cancel(RMICancelType.DEFAULT);
    }

    @Override
    public void cancelOrAbort() {
        this.cancel(RMICancelType.ABORT_RUNNING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMIRequestState getState() {
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            this.getResultImpl();
            return this.state;
        }
    }

    boolean isWaitingToSend() {
        return this.state == RMIRequestState.WAITING_TO_SEND;
    }

    @Override
    public T getBlocking() throws RMIException {
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            while (!this.isCompleted()) {
                try {
                    this.requestLock.wait();
                }
                catch (InterruptedException e) {
                    this.cancel(RMICancelType.ABORT_RUNNING);
                    Thread.currentThread().interrupt();
                }
            }
            switch (this.getState()) {
                case SUCCEEDED: {
                    return this.getResultImpl();
                }
                case FAILED: {
                    throw this.getException();
                }
            }
            throw new AssertionError((Object)"Final state was expected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getNonBlocking() {
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            return this.getResultImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMIException getException() {
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            this.getResultImpl();
            if (this.state == RMIRequestState.FAILED) {
                RMIException exception = (RMIException)this.responseMessage.getMarshalledResult().getObject();
                if (!exception.hasRequestInfo()) {
                    exception = new RMIException(exception, this);
                    this.responseMessage = new RMIErrorMessage(Marshalled.forObject(exception, RMIErrorMessage.getExceptionMarshaller()), this.responseMessage.getRoute());
                }
                return exception;
            }
            return null;
        }
    }

    @Override
    public long getSendTime() {
        return this.sendTime;
    }

    @Override
    public long getRunningStartTime() {
        return this.runningStartTime;
    }

    @Override
    public long getCompletionTime() {
        return this.completionTime;
    }

    @Override
    public Object getSubject() {
        return this.subject.getObject();
    }

    @Override
    public RMIOperation<T> getOperation() {
        return this.requestMessage.getOperation();
    }

    @Override
    public Object[] getParameters() {
        return this.requestMessage.getParameters().getObject();
    }

    @Override
    public RMIRequestMessage<T> getRequestMessage() {
        return this.requestMessage;
    }

    @Override
    public RMIChannelType getChannelType() {
        return RMIChannelType.CLIENT_CHANNEL;
    }

    @Override
    public RMIResponseMessage getResponseMessage() {
        return this.responseMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<T> getPromise() {
        Notifier notifier = null;
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            if (this.promise != null) {
                return this.promise;
            }
            this.promise = new RMIPromiseImpl(this);
            if (this.isCompleted()) {
                notifier = new Notifier();
            }
        }
        if (notifier != null) {
            notifier.notifyPromise();
        }
        return this.promise;
    }

    @Override
    public RMIChannel getChannel() {
        return this.channel;
    }

    Marshalled<?> getMarshalledSubject() {
        return this.subject;
    }

    long getId() {
        return this.id;
    }

    long getChannelId() {
        return this.channel.getChannelId();
    }

    boolean isNestedRequest() {
        return this.nestedRequest;
    }

    RMIMessageKind getKind() {
        return this.kind;
    }

    boolean isCancelRequest() {
        return this.getRequestMessage().getOperation() == ABORT_CANCEL;
    }

    RMIServiceId getTentativeTarget() {
        return this.tentativeTarget;
    }

    void setTentativeTarget(RMIServiceId tentativeTarget) {
        if (this.requestMessage.getTarget() == null) {
            this.tentativeTarget = tentativeTarget;
        }
    }

    @Override
    public Executor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        this.executor = this.requestSender.getExecutor();
        return this.executor;
    }

    void assignConnection(RMIConnection connection) {
        this.assignedConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setSendingState(RMIConnection connection) {
        Notifier notifier = null;
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            if (this.state != RMIRequestState.WAITING_TO_SEND) {
                return false;
            }
            assert (this.assignedConnection == connection);
            this.runningStartTime = System.currentTimeMillis();
            assert (this.state == RMIRequestState.WAITING_TO_SEND);
            if (this.requestMessage.getRequestType() == RMIRequestType.ONE_WAY) {
                this.setSucceededStateInternal(Marshalled.forObject(null, this.getOperation().getResultMarshaller()), null);
                notifier = new Notifier();
            } else {
                this.state = RMIRequestState.SENDING;
                connection.requestsManager.addSentRequest(this);
                if (connection.closed) {
                    this.setFailedStateInternal(RMIExceptionType.DISCONNECTION, null, null);
                }
            }
        }
        if (this.requestMessage.getRequestType() != RMIRequestType.ONE_WAY) {
            this.requestSender.startTimeoutRequestMonitoringThread();
        }
        if (notifier != null) {
            notifier.notifyCompleted();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSentState(RMIConnection connection) {
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            RMIChannelState state;
            if (this.state == RMIRequestState.SENDING) {
                assert (this.assignedConnection == connection);
                this.state = RMIRequestState.SENT;
            }
            if (!(this.nestedRequest || (state = this.channel.getState()) != RMIChannelState.NEW && state != RMIChannelState.CANCELLING)) {
                this.channel.open(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSucceededState(Marshalled<?> marshalledResult, RMIRoute route) {
        Notifier notifier;
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            if (this.isCompleted()) {
                return;
            }
            this.setSucceededStateInternal(marshalledResult, route);
            notifier = new Notifier();
        }
        notifier.notifyCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFailedState(RMIExceptionType type, Throwable cause) {
        Notifier notifier;
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            if (this.isCompleted()) {
                return;
            }
            this.setFailedStateInternal(type, cause, null);
            notifier = new Notifier();
        }
        notifier.notifyCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFailedState(Marshalled<RMIException> marshalledCause, RMIRoute route) {
        Notifier notifier;
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            if (this.isCompleted()) {
                return;
            }
            try {
                marshalledCause.ensureBytes();
                this.setFailedStateInternal(new RMIErrorMessage(marshalledCause, route));
            }
            catch (Throwable t) {
                this.setFailedStateInternal(new RMIErrorMessage(RMIExceptionType.RESULT_MARSHALLING_ERROR, t, route));
            }
            finally {
                notifier = new Notifier();
            }
        }
        notifier.notifyCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abortOnTimeout(RMIRequestState expectedState) {
        Notifier notifier;
        assert (expectedState == RMIRequestState.WAITING_TO_SEND || expectedState == RMIRequestState.SENT);
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            RMIExceptionType type;
            if (expectedState != this.state) {
                return;
            }
            RMIExceptionType rMIExceptionType = type = this.state == RMIRequestState.WAITING_TO_SEND ? RMIExceptionType.REQUEST_SENDING_TIMEOUT : RMIExceptionType.REQUEST_RUNNING_TIMEOUT;
            if (type == RMIExceptionType.REQUEST_RUNNING_TIMEOUT) {
                this.sendCancellationMessageInternal(RMICancelType.ABORT_RUNNING);
            }
            this.setFailedStateInternal(type, null, null);
            notifier = new Notifier();
        }
        notifier.notifyCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFromSendingQueues() {
        if (this.requestSender.dropPendingRequest(this)) {
            return true;
        }
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            return this.assignedConnection != null && this.assignedConnection.requestsManager.removeOutgoingRequest(this);
        }
    }

    @GuardedBy(value="requestLock")
    private T getResultImpl() {
        if (this.requestMessage.getRequestType() == RMIRequestType.ONE_WAY || this.state != RMIRequestState.SUCCEEDED) {
            return null;
        }
        assert (this.state == RMIRequestState.SUCCEEDED);
        if (this.wasUnmarshall) {
            return (T)this.responseMessage.getMarshalledResult().getObject();
        }
        this.wasUnmarshall = true;
        try {
            return (T)this.responseMessage.getMarshalledResult().getObject();
        }
        catch (Throwable t) {
            this.setFailedStateInternal(RMIExceptionType.RESULT_UNMARSHALLING_ERROR, t, this.responseMessage.getRoute());
            return null;
        }
    }

    @GuardedBy(value="requestLock")
    private void setSucceededStateInternal(Marshalled<T> result, RMIRoute route) {
        if (!this.nestedRequest) {
            this.channel.close();
        }
        if (this.requestMessage.getRequestType() != RMIRequestType.ONE_WAY) {
            try {
                result.ensureBytes();
                if (!result.getMarshaller().equals(this.requestMessage.getOperation().getResultMarshaller())) {
                    throw new IllegalArgumentException("used an incorrect marshaller");
                }
            }
            catch (Throwable t) {
                this.setFailedState(RMIExceptionType.RESULT_MARSHALLING_ERROR, t);
                return;
            }
        }
        this.responseMessage = new RMIResultMessage<T>(this.requestMessage.getOperation(), result, route);
        this.state = RMIRequestState.SUCCEEDED;
        this.completionTime = System.currentTimeMillis();
    }

    @GuardedBy(value="requestLock")
    private void setFailedStateInternal(RMIExceptionType type, Throwable cause, RMIRoute route) {
        this.setFailedStateInternal(new RMIErrorMessage(type, cause, route));
    }

    @GuardedBy(value="requestLock")
    private void setFailedStateInternal(RMIResponseMessage errorMessage) {
        if (!this.nestedRequest) {
            this.channel.close();
        }
        this.state = RMIRequestState.FAILED;
        this.responseMessage = errorMessage;
        this.completionTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancel(RMICancelType type) {
        Notifier notifier;
        boolean needToRemoveFromSendingQueue = false;
        RequestLock requestLock = this.requestLock;
        synchronized (requestLock) {
            switch (this.state) {
                case NEW: {
                    if (!this.isNestedRequest()) {
                        this.channel.close();
                    }
                    this.setFailedStateInternal(RMIExceptionType.CANCELLED_BEFORE_EXECUTION, null, null);
                    break;
                }
                case WAITING_TO_SEND: {
                    if (!this.isNestedRequest()) {
                        this.channel.close();
                    }
                    needToRemoveFromSendingQueue = true;
                    this.setFailedStateInternal(RMIExceptionType.CANCELLED_BEFORE_EXECUTION, null, null);
                    break;
                }
                case SENDING: 
                case SENT: {
                    this.sendCancellationMessageInternal(type);
                    if (type == RMICancelType.ABORT_RUNNING) {
                        this.state = RMIRequestState.FAILED;
                        this.responseMessage = new RMIErrorMessage(RMIExceptionType.CANCELLED_DURING_EXECUTION, null, null);
                        this.completionTime = System.currentTimeMillis();
                        break;
                    }
                    this.state = RMIRequestState.CANCELLING;
                    return;
                }
                case CANCELLING: {
                    if (type == RMICancelType.DEFAULT) {
                        return;
                    }
                    if (this.assignedConnection != null) {
                        this.sendCancellationMessageInternal(RMICancelType.ABORT_RUNNING);
                    }
                    this.setFailedStateInternal(RMIExceptionType.CANCELLED_DURING_EXECUTION, null, null);
                    break;
                }
                case SUCCEEDED: 
                case FAILED: {
                    return;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected non-final state: " + (Object)((Object)this.state)));
                }
            }
            notifier = new Notifier();
        }
        notifier.notifyCompleted();
        if (needToRemoveFromSendingQueue) {
            this.removeFromSendingQueues();
        }
    }

    private void sendCancellationMessageInternal(RMICancelType type) {
        if (!this.isNestedRequest()) {
            this.channel.cancel(type);
        } else {
            this.channel.createRequest(new RMIRequestMessage<Void>(RMIRequestType.ONE_WAY, type == RMICancelType.ABORT_RUNNING ? ABORT_CANCEL : CANCEL_WITH_CONFIRMATION, this.id)).send();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.nestedRequest ? "Nested " : "Top-level ").append("Request{").append("id=").append(this.id).append(", ").append(this.requestMessage).append(", ");
        sb.append("state=").append((Object)this.state).append(", ");
        if (this.nestedRequest) {
            sb.append(", channel=").append(this.channel).append(", ");
        }
        sb.append("result=").append(this.responseMessage);
        sb.append("}");
        return sb.toString();
    }

    private static class RequestLock {
        private RequestLock() {
        }
    }

    private class Notifier {
        private final RMIRequestListener listenerNotifier;
        private final Promise<T> promiseNotifier;

        private Notifier() {
            this.listenerNotifier = RMIRequestImpl.this.listener;
            this.promiseNotifier = RMIRequestImpl.this.promise;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyCompleted() {
            RequestLock requestLock = RMIRequestImpl.this.requestLock;
            synchronized (requestLock) {
                assert (RMIRequestImpl.this.isCompleted());
                RMIRequestImpl.this.requestLock.notifyAll();
            }
            if (this.listenerNotifier != null || this.promiseNotifier != null) {
                RMIRequestImpl.this.getExecutor().execute(() -> {
                    if (this.listenerNotifier != null) {
                        this.notifyRequestListener();
                    }
                    if (this.promiseNotifier != null) {
                        this.notifyPromise();
                    }
                });
            }
        }

        private void notifyRequestListener() {
            this.listenerNotifier.requestCompleted(RMIRequestImpl.this);
        }

        private void notifyPromise() {
            RMIException e = RMIRequestImpl.this.getException();
            if (e == null) {
                this.promiseNotifier.complete(RMIRequestImpl.this.getNonBlocking());
            } else if (e.getType() == RMIExceptionType.APPLICATION_ERROR) {
                Throwable cause = e.getCause();
                RMIRequestInvocationHandler.trimStackTrace(cause);
                this.promiseNotifier.completeExceptionally(cause);
            } else {
                this.promiseNotifier.completeExceptionally(e);
            }
        }
    }
}

