/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.io.BufferedInput;
import com.devexperts.rmi.message.RMIResponseMessage;
import com.devexperts.rmi.message.RMIResponseType;
import com.devexperts.rmi.task.RMIChannelType;
import java.io.IOException;
import javax.annotation.Nonnull;

enum RMIMessageKind {
    REQUEST(64),
    SERVER_CHANNEL_REQUEST(65),
    CLIENT_CHANNEL_REQUEST(66),
    SUCCESS_RESPONSE(67),
    SERVER_CHANNEL_SUCCESS_RESPONSE(68),
    CLIENT_CHANNEL_SUCCESS_RESPONSE(69),
    ERROR_RESPONSE(70),
    SERVER_CHANNEL_ERROR_RESPONSE(71),
    CLIENT_CHANNEL_ERROR_RESPONSE(72),
    DESCRIBE_SUBJECT(73),
    DESCRIBE_OPERATION(74),
    ADVERTISE(75);

    private static final int KIND_BASE = 64;
    private static final int KIND_CNT = 12;
    private static final RMIMessageKind[] KIND_BY_ID;
    private final int id;

    static RMIMessageKind getById(int id) {
        return id >= 64 && id < 76 ? KIND_BY_ID[id - 64] : null;
    }

    static RMIMessageKind getKind(RMIResponseMessage message, RMIChannelType type) {
        if (type == null) {
            return message.getType() == RMIResponseType.SUCCESS ? SUCCESS_RESPONSE : ERROR_RESPONSE;
        }
        if (type == RMIChannelType.CLIENT_CHANNEL) {
            return message.getType() == RMIResponseType.SUCCESS ? CLIENT_CHANNEL_SUCCESS_RESPONSE : CLIENT_CHANNEL_ERROR_RESPONSE;
        }
        return message.getType() == RMIResponseType.SUCCESS ? SERVER_CHANNEL_SUCCESS_RESPONSE : SERVER_CHANNEL_ERROR_RESPONSE;
    }

    @Nonnull
    public static RMIMessageKind readFromRequest(BufferedInput in) throws IOException {
        int id = in.readCompactInt();
        RMIMessageKind kind = RMIMessageKind.getById(id);
        if (kind == null || !kind.isRequest()) {
            throw new IOException("Invalid request kind: " + Integer.toHexString(id));
        }
        return kind.getOppositeSide();
    }

    public static RMIMessageKind readFromResponse(BufferedInput in) throws IOException {
        int id = in.readCompactInt();
        RMIMessageKind kind = RMIMessageKind.getById(id);
        if (kind == null || !kind.isSuccess() && !kind.isError()) {
            throw new IOException("Invalid response kind: " + Integer.toHexString(id));
        }
        return kind.getOppositeSide();
    }

    private RMIMessageKind getOppositeSide() {
        switch (this) {
            case CLIENT_CHANNEL_ERROR_RESPONSE: {
                return SERVER_CHANNEL_ERROR_RESPONSE;
            }
            case CLIENT_CHANNEL_SUCCESS_RESPONSE: {
                return SERVER_CHANNEL_SUCCESS_RESPONSE;
            }
            case CLIENT_CHANNEL_REQUEST: {
                return SERVER_CHANNEL_REQUEST;
            }
            case SERVER_CHANNEL_REQUEST: {
                return CLIENT_CHANNEL_REQUEST;
            }
            case SERVER_CHANNEL_SUCCESS_RESPONSE: {
                return CLIENT_CHANNEL_SUCCESS_RESPONSE;
            }
            case SERVER_CHANNEL_ERROR_RESPONSE: {
                return CLIENT_CHANNEL_ERROR_RESPONSE;
            }
        }
        return this;
    }

    private RMIMessageKind(int id) {
        this.id = id;
    }

    boolean isRequest() {
        return this == REQUEST || this == SERVER_CHANNEL_REQUEST || this == CLIENT_CHANNEL_REQUEST;
    }

    boolean isError() {
        return this == CLIENT_CHANNEL_ERROR_RESPONSE || this == SERVER_CHANNEL_ERROR_RESPONSE || this == ERROR_RESPONSE;
    }

    boolean isSuccess() {
        return this == CLIENT_CHANNEL_SUCCESS_RESPONSE || this == SERVER_CHANNEL_SUCCESS_RESPONSE || this == SUCCESS_RESPONSE;
    }

    boolean hasChannel() {
        return this == CLIENT_CHANNEL_REQUEST || this == CLIENT_CHANNEL_ERROR_RESPONSE || this == CLIENT_CHANNEL_SUCCESS_RESPONSE || this == SERVER_CHANNEL_REQUEST || this == SERVER_CHANNEL_ERROR_RESPONSE || this == SERVER_CHANNEL_SUCCESS_RESPONSE;
    }

    boolean hasServer() {
        return this == SERVER_CHANNEL_REQUEST || this == SERVER_CHANNEL_ERROR_RESPONSE || this == SERVER_CHANNEL_SUCCESS_RESPONSE;
    }

    boolean hasClient() {
        return this == CLIENT_CHANNEL_REQUEST || this == CLIENT_CHANNEL_ERROR_RESPONSE || this == CLIENT_CHANNEL_SUCCESS_RESPONSE;
    }

    int getId() {
        return this.id;
    }

    static {
        KIND_BY_ID = new RMIMessageKind[12];
        for (RMIMessageKind kind : RMIMessageKind.values()) {
            if (KIND_BY_ID[kind.getId() - 64] != null) {
                throw new AssertionError((Object)("Duplicate id: " + kind.getId()));
            }
            RMIMessageKind.KIND_BY_ID[kind.getId() - 64] = kind;
        }
    }
}

