/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.auth.AuthSession;
import com.devexperts.io.BufferedInput;
import com.devexperts.qd.DataIterator;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.SubscriptionIterator;
import com.devexperts.qd.kit.DefaultScheme;
import com.devexperts.qd.kit.PentaCodec;
import com.devexperts.qd.qtp.MasterMessageAdapter;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageDescriptor;
import com.devexperts.qd.qtp.MessageProvider;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.MessageVisitor;
import com.devexperts.qd.qtp.ProtocolDescriptor;
import com.devexperts.qd.qtp.auth.QDAuthRealm;
import com.devexperts.qd.qtp.auth.QDLoginHandler;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.rmi.RMIEndpoint;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIQueueType;
import com.devexperts.rmi.impl.ServiceFilter;
import com.devexperts.util.LogUtil;
import com.devexperts.util.TypedMap;
import java.io.IOException;
import java.util.EnumSet;
import javax.annotation.Nonnull;

class RMIMessageAdapter
extends MessageAdapter
implements MasterMessageAdapter {
    private static final long LEGACY_WAIT_INTERVAL = RMIMessageAdapter.getLong(RMIMessageAdapter.class.getName() + ".LegacyWaitInterval", 3000L);
    private static final DataScheme EMPTY_SCHEME = new DefaultScheme(new PentaCodec(), new DataRecord[0]);
    private static final int RETRIEVE_ATTACH = 0;
    private static final int RETRIEVE_RMI_REQ = 1;
    private static final int RETRIEVE_RMI_RES = 2;
    private static final int RETRIEVE_RMI_ADS = 3;
    private static final int RETRIEVE_COUNT = 4;
    private static final MessageType ATTACHED_ADAPTER_MASK_TYPE = MessageType.RAW_DATA;
    private final RMIConnection connection;
    private final MessageAdapter attachedAdapter;
    private volatile boolean remoteSupportsComboResponseMessage = false;
    private volatile long legacyWaitTillTimeMillis;
    private volatile long nextRetrieveAttachedAdapter = Long.MAX_VALUE;
    private int retrieve = 0;

    private static long getLong(String key, long defVal) {
        try {
            defVal = Long.getLong(key, defVal);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return defVal;
    }

    RMIMessageAdapter(RMIConnection connection, QDStats stats, MessageAdapter attachedAdapter) {
        super(connection.endpoint.getQdEndpoint(), stats);
        this.connection = connection;
        this.attachedAdapter = attachedAdapter;
        if (attachedAdapter != null) {
            attachedAdapter.setCloseListener(adapter -> {
                if (adapter.isMarkedForImmediateRestart()) {
                    this.markForImmediateRestart();
                }
                this.close();
            });
            attachedAdapter.setMessageListener(this::attachedAdapterMessagesAvailable);
        }
    }

    @Override
    public DataScheme getScheme() {
        return this.attachedAdapter != null ? this.attachedAdapter.getScheme() : EMPTY_SCHEME;
    }

    @Override
    public void setAuthRealm(QDAuthRealm authRealm) {
        if (this.attachedAdapter != null) {
            this.attachedAdapter.setAuthRealm(authRealm);
        } else {
            super.setAuthRealm(authRealm);
        }
    }

    @Override
    public void setLoginHandler(QDLoginHandler loginHandler) {
        if (this.attachedAdapter != null) {
            this.attachedAdapter.setLoginHandler(loginHandler);
        } else {
            super.setLoginHandler(loginHandler);
        }
    }

    @Override
    public void setConnectionVariables(@Nonnull TypedMap connectionVariables) {
        super.setConnectionVariables(connectionVariables);
        if (this.attachedAdapter != null) {
            this.attachedAdapter.setConnectionVariables(connectionVariables);
        }
    }

    @Override
    protected void startImpl(MasterMessageAdapter master) {
        if (master != null) {
            throw new IllegalArgumentException();
        }
        this.legacyWaitTillTimeMillis = System.currentTimeMillis() + LEGACY_WAIT_INTERVAL;
        this.connection.start();
        if (this.attachedAdapter != null) {
            this.attachedAdapter.start(this);
        } else {
            super.startImpl(this);
        }
    }

    @Override
    protected void closeImpl() {
        this.connection.close();
        if (this.attachedAdapter != null) {
            this.attachedAdapter.close();
        }
    }

    @Override
    public boolean supportsMixedSubscription() {
        return this.attachedAdapter != null && this.attachedAdapter.supportsMixedSubscription();
    }

    @Override
    public void processOtherMessage(int messageTypeId, BufferedInput data, int len) {
        if (!this.isAlive()) {
            return;
        }
        try {
            switch (messageTypeId) {
                case 54: {
                    this.connection.messageProcessor.processOldResultMessage(data);
                    break;
                }
                case 55: {
                    this.connection.messageProcessor.processOldErrorMessage(data);
                    break;
                }
                case 56: {
                    this.connection.messageProcessor.processComboResponseMessage(data);
                    break;
                }
                case 52: {
                    if (this.remoteSupportsComboResponseMessage) {
                        this.connection.messageProcessor.processComboRequestMessage(data);
                        break;
                    }
                    this.connection.messageProcessor.processOldRequestMessage(data);
                    break;
                }
                case 49: {
                    this.connection.messageProcessor.processAdvertiseServicesMessage(data);
                    break;
                }
                case 51: {
                    this.connection.messageProcessor.processDescribeOperationMessage(data);
                    break;
                }
                case 50: {
                    this.connection.messageProcessor.processDescribeSubjectMessage(data);
                    break;
                }
                case 53: {
                    this.connection.messageProcessor.processOldCancelMessage(data);
                    break;
                }
                default: {
                    if (this.attachedAdapter == null) {
                        this.handleUnknownMessage(messageTypeId);
                        break;
                    }
                    this.attachedAdapter.processOtherMessage(messageTypeId, data, len);
                    break;
                }
            }
        }
        catch (IOException e) {
            this.handleCorruptedMessage(messageTypeId);
        }
    }

    @Override
    protected void processData(DataIterator iterator, MessageType message) {
        if (this.attachedAdapter == null) {
            super.processData(iterator, message);
        } else {
            switch (message) {
                case TICKER_DATA: {
                    this.attachedAdapter.processTickerData(iterator);
                    break;
                }
                case STREAM_DATA: {
                    this.attachedAdapter.processStreamData(iterator);
                    break;
                }
                case HISTORY_DATA: {
                    this.attachedAdapter.processHistoryData(iterator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("non-data message type");
                }
            }
        }
    }

    @Override
    protected void processSubscription(SubscriptionIterator iterator, MessageType message) {
        if (this.attachedAdapter == null) {
            super.processSubscription(iterator, message);
        } else {
            switch (message) {
                case TICKER_ADD_SUBSCRIPTION: {
                    this.attachedAdapter.processTickerAddSubscription(iterator);
                    break;
                }
                case TICKER_REMOVE_SUBSCRIPTION: {
                    this.attachedAdapter.processTickerRemoveSubscription(iterator);
                    break;
                }
                case STREAM_ADD_SUBSCRIPTION: {
                    this.attachedAdapter.processStreamAddSubscription(iterator);
                    break;
                }
                case STREAM_REMOVE_SUBSCRIPTION: {
                    this.attachedAdapter.processStreamRemoveSubscription(iterator);
                    break;
                }
                case HISTORY_ADD_SUBSCRIPTION: {
                    this.attachedAdapter.processHistoryAddSubscription(iterator);
                    break;
                }
                case HISTORY_REMOVE_SUBSCRIPTION: {
                    this.attachedAdapter.processHistoryRemoveSubscription(iterator);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not-subscription message type");
                }
            }
        }
    }

    @Override
    public boolean retrieveMessages(MessageVisitor visitor) {
        super.retrieveMessages(visitor);
        long currentTime = System.currentTimeMillis();
        if (currentTime >= this.legacyWaitTillTimeMillis) {
            this.processLegacyConnection();
        }
        long mask = this.retrieveMask();
        if (this.attachedAdapter == null) {
            mask = this.retrieveDescribeProtocolMessage(visitor, mask);
        }
        int i = 0;
        block6: while (i < 4) {
            switch (this.retrieve) {
                case 0: {
                    if (currentTime < this.nextRetrieveAttachedAdapter && !RMIMessageAdapter.hasMessageMask(mask, ATTACHED_ADAPTER_MASK_TYPE)) break;
                    mask = this.retrieveAttachedMessages(visitor, mask);
                    this.nextRetrieveAttachedAdapter = this.attachedAdapter.nextRetrieveTime(currentTime);
                    break block6;
                }
                case 3: {
                    if (!RMIMessageAdapter.hasMessageMask(mask, RMIQueueType.ADVERTISE.maskType())) break;
                    mask = this.retrieveRMIMessages(visitor, mask, RMIQueueType.ADVERTISE);
                    break block6;
                }
                case 1: {
                    if (!RMIMessageAdapter.hasMessageMask(mask, RMIQueueType.REQUEST.maskType())) break;
                    mask = this.retrieveRMIMessages(visitor, mask, RMIQueueType.REQUEST);
                    break block6;
                }
                case 2: {
                    if (!RMIMessageAdapter.hasMessageMask(mask, RMIQueueType.RESPONSE.maskType())) break;
                    mask = this.retrieveRMIMessages(visitor, mask, RMIQueueType.RESPONSE);
                    break block6;
                }
                default: {
                    throw new AssertionError();
                }
            }
            ++i;
            ++this.retrieve;
            this.retrieve %= 4;
        }
        ++this.retrieve;
        this.retrieve %= 4;
        this.addMask(mask);
        return mask != 0L || currentTime >= this.nextRetrieveAttachedAdapter;
    }

    private void attachedAdapterMessagesAvailable(MessageProvider provider) {
        assert (provider == this.attachedAdapter);
        this.addMask(RMIMessageAdapter.getMessageMask(ATTACHED_ADAPTER_MASK_TYPE));
    }

    private void processLegacyConnection() {
        QDLog.log.warn("Legacy connection (pre QDS 3.69) is detected. Assuming RMI is supported at " + LogUtil.hideCredentials(this.getRemoteHostAddress()));
        this.setRemoteReceiveSet(EnumSet.of(MessageType.RMI_DESCRIBE_SUBJECT, new MessageType[]{MessageType.RMI_DESCRIBE_OPERATION, MessageType.RMI_REQUEST, MessageType.RMI_CANCEL, MessageType.RMI_RESULT, MessageType.RMI_ERROR}));
    }

    @Override
    public long nextRetrieveTime(long currentTime) {
        return Math.min(Math.min(super.nextRetrieveTime(currentTime), this.legacyWaitTillTimeMillis), this.nextRetrieveAttachedAdapter);
    }

    @Override
    public void reinitConfiguration(AuthSession session) {
        if (this.attachedAdapter != null) {
            this.attachedAdapter.reinitConfiguration(session);
        } else {
            super.reinitConfiguration(session);
        }
    }

    @Override
    public void prepareProtocolDescriptor(ProtocolDescriptor desc) {
        super.prepareProtocolDescriptor(desc);
        if (this.attachedAdapter != null) {
            this.attachedAdapter.prepareProtocolDescriptor(desc);
        }
    }

    @Override
    public void augmentProtocolDescriptor(ProtocolDescriptor desc) {
        for (MessageType message : MessageType.values()) {
            if (message.isRMIChan() || message.isRMIReq() && this.connection.side.hasServer() || message.isRMIRes() && this.connection.side.hasClient()) {
                desc.addReceive(desc.newMessageDescriptor(message));
            }
            if (message.isRMIChan() || message.isRMIReq() && this.connection.side.hasClient() || message.isRMIRes() && this.connection.side.hasServer()) {
                desc.addSend(desc.newMessageDescriptor(message));
            }
            if (!message.isRMIAds()) continue;
            if (this.connection.side.hasClient()) {
                MessageDescriptor rmiAdsDesc = desc.newMessageDescriptor(message);
                rmiAdsDesc.setProperty("services", this.connection.configuredServices.toString());
                desc.addReceive(rmiAdsDesc);
            }
            if (!this.connection.side.hasServer() || this.connection.configuredServices == ServiceFilter.NOTHING || !this.connection.adFilter.isSendAdvertisement()) continue;
            desc.addSend(desc.newMessageDescriptor(message));
        }
        desc.setProperty("rmi", String.valueOf(this.connection.endpoint.side.toString()));
    }

    @Override
    protected void prepareAuthenticateProtocolDescriptor(ProtocolDescriptor desc) {
        super.prepareAuthenticateProtocolDescriptor(desc);
    }

    @Override
    public void processDescribeProtocol(ProtocolDescriptor desc, boolean logDescriptor) {
        super.processDescribeProtocol(desc, logDescriptor);
        if (this.attachedAdapter != null) {
            this.attachedAdapter.processDescribeProtocol(desc, false);
        }
        this.connection.messageComposer.setSupportTargetRouteProtocol(desc.getEndpointId() != null);
        this.setRemoteReceiveSet(desc.getReceiveSet());
        MessageDescriptor rmiAdsDesc = desc.getReceive(MessageType.RMI_ADVERTISE_SERVICES);
        ServiceFilter filter = rmiAdsDesc != null ? ServiceFilter.valueOf(rmiAdsDesc.getProperty("services")) : ServiceFilter.NOTHING;
        this.connection.serverDescriptorsManager.setServicesOnDescribeProtocolAndSendAllDescriptors(this.connection.configuredServices.intersection(filter));
        this.remoteSupportsComboResponseMessage = desc.canSend(MessageType.RMI_RESPONSE);
        if (this.getRemoteRMISide(desc).hasServer()) {
            this.connection.requestsManager.setAnonymousOnDescribeProtocol(!desc.canSend(MessageType.RMI_ADVERTISE_SERVICES));
        }
    }

    private RMIEndpoint.Side getRemoteRMISide(ProtocolDescriptor desc) {
        return desc.canSend(MessageType.RMI_RESPONSE) ? this.getRemoteRMISideFromProp(desc) : this.getRemoteRMISideByMessages(desc);
    }

    private RMIEndpoint.Side getRemoteRMISideFromProp(ProtocolDescriptor desc) {
        String s = desc.getProperty("rmi");
        if (s == null) {
            return RMIEndpoint.Side.NONE;
        }
        try {
            return RMIEndpoint.Side.valueOf(s);
        }
        catch (IllegalArgumentException e) {
            return RMIEndpoint.Side.NONE;
        }
    }

    private RMIEndpoint.Side getRemoteRMISideByMessages(ProtocolDescriptor desc) {
        RMIEndpoint.Side side = RMIEndpoint.Side.NONE;
        if (desc.canSend(MessageType.RMI_REQUEST)) {
            side = side.withClient();
        }
        if (desc.canSend(MessageType.RMI_RESULT) || desc.canSend(MessageType.RMI_ERROR)) {
            side = side.withServer();
        }
        return side;
    }

    private void setRemoteReceiveSet(EnumSet<MessageType> enumSet) {
        this.legacyWaitTillTimeMillis = Long.MAX_VALUE;
        this.connection.messageComposer.setRemoteReceiveSet(enumSet);
        if (this.connection.side.hasClient()) {
            this.rmiMessageAvailable(RMIQueueType.REQUEST);
        }
    }

    private long retrieveRMIMessages(MessageVisitor visitor, long mask, RMIQueueType type) {
        if (!this.connection.messageComposer.retrieveRMIMessages(visitor, type)) {
            mask = RMIMessageAdapter.clearMessageMask(mask, type.maskType());
        }
        return mask;
    }

    private long retrieveAttachedMessages(MessageVisitor visitor, long mask) {
        if (!this.attachedAdapter.retrieveMessages(visitor)) {
            mask = RMIMessageAdapter.clearMessageMask(mask, ATTACHED_ADAPTER_MASK_TYPE);
        }
        return mask;
    }

    @Override
    public boolean isProtocolDescriptorCompatible(ProtocolDescriptor desc) {
        boolean ok;
        RMIEndpoint.Side remoteRMISide = this.getRemoteRMISide(desc);
        boolean bl = ok = this.connection.side.hasClient() && remoteRMISide.hasServer() || this.connection.side.hasServer() && remoteRMISide.hasClient();
        if (ok || this.attachedAdapter == null) {
            return ok;
        }
        return this.attachedAdapter.isProtocolDescriptorCompatible(desc);
    }

    @Override
    public void useDescribeProtocol() {
        super.useDescribeProtocol();
        if (this.attachedAdapter != null) {
            this.attachedAdapter.useDescribeProtocol();
        }
    }

    boolean rmiMessageAvailable(RMIQueueType queueType) {
        return this.addMask(RMIMessageAdapter.getMessageMask(queueType.maskType()));
    }

    @Override
    public String toString() {
        return this.attachedAdapter == null ? "RMI" : this.attachedAdapter.toString();
    }
}

