/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.logging.Logging;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIExecutionTaskImpl;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.task.BalanceResult;
import com.dxfeed.promise.Promise;
import javax.annotation.Nonnull;

class RMILog {
    static final Logging log = Logging.getLogging("com.devexperts.rmi.RMI");

    private RMILog() {
    }

    static void logFailedTask(RMIExceptionType type, String info, RMIConnection connection, long requestId, long channelId, RMIRequestType requestType) {
        log.error(type.getMessage() + ". Details: " + info + ", " + RMILog.composeExecutionTaskString(connection, requestId, channelId, "reqType=" + requestType.toString()));
    }

    static <T> void logExecutionError(RMIExecutionTaskImpl<T> execution, RMIExceptionType type, Throwable e) {
        log.error(type.getMessage() + ": " + execution, e);
    }

    static String composeExecutionTaskString(RMIConnection connection, long requestId, long channelId, String task) {
        return "Task{host=" + connection.getRemoteHostAddress() + ", reqId=" + requestId + ", channelId=" + channelId + ", " + task + "}";
    }

    static void logBalancingCompletion(@Nonnull Object details, @Nonnull Promise<BalanceResult> balancePromise) {
        if (RMIEndpointImpl.RMI_TRACE_LOG) {
            log.trace("Balance result for request '" + details + " is " + (balancePromise.hasResult() ? balancePromise.getResult() : balancePromise.getException()));
        }
        if (!balancePromise.isCancelled() && balancePromise.hasException()) {
            log.error("RMI load balancing for '" + details + "' resulted in an exception", balancePromise.getException());
        }
        if (balancePromise.hasResult() && balancePromise.getResult().isReject()) {
            log.warn("RMI load balancing rejected the request '" + details + "' with reason '" + balancePromise.getResult().getRejectReason() + "'");
        }
    }
}

