/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIExecutionTask;
import com.devexperts.rmi.RMIExecutionTaskState;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMILog;
import com.devexperts.rmi.impl.RMITaskImpl;
import com.devexperts.rmi.message.RMIErrorMessage;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.task.RMIService;
import com.devexperts.rmi.task.RMITask;
import com.devexperts.util.TypedMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import javax.annotation.concurrent.GuardedBy;

class RMIExecutionTaskImpl<T>
extends RMIExecutionTask<T> {
    private RMIService<T> service;
    private final RMIConnection connection;
    private final long requestId;
    private final RMITaskImpl<T> task;
    private final Executor executor;
    @GuardedBy(value="task")
    private volatile RMIExecutionTaskState state = RMIExecutionTaskState.NEW;

    @Override
    public TypedMap getConnectionVariables() {
        return this.task.getConnectionVariables();
    }

    @Override
    public long getSubmissionTime() {
        return this.task.getSubmissionTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RMIExecutionTaskState getState() {
        RMITaskImpl<T> rMITaskImpl = this.task;
        synchronized (rMITaskImpl) {
            switch (this.task.getState()) {
                case FAILED: {
                    this.state = RMIExecutionTaskState.FAILED;
                    break;
                }
                case SUCCEEDED: {
                    this.state = RMIExecutionTaskState.SUCCEEDED;
                    break;
                }
                case SUSPENDED: {
                    if (this.state != RMIExecutionTaskState.RUNNING) break;
                    this.state = RMIExecutionTaskState.SUSPENDED;
                }
            }
            return this.state;
        }
    }

    void updateState(boolean submitNextInQueue) {
        if (this.submitNextNow() && submitNextInQueue) {
            this.task.channel.submitNextTask(this);
        }
    }

    @Override
    public boolean isOneWayRequest() {
        return this.task.getRequestMessage().getRequestType() == RMIRequestType.ONE_WAY;
    }

    @Override
    public RMITask<T> getTask() {
        return this.task;
    }

    @Override
    public String toString() {
        return RMILog.composeExecutionTaskString(this.connection, this.requestId, this.task.getChannelId(), this.task.toString());
    }

    RMIExecutionTaskImpl(long requestId, RMIConnection connection, RMITaskImpl<T> task, RMIService<T> service, Executor executor) {
        this.task = task;
        this.connection = connection;
        this.service = service;
        this.requestId = requestId;
        this.executor = executor;
        task.setExecutionTask(this);
    }

    boolean submitExecutionNow() {
        try {
            if (this.makeSubmitted()) {
                if (this.executor instanceof ExecutorService) {
                    ((ExecutorService)this.executor).submit(this);
                } else {
                    this.executor.execute(this);
                }
                return true;
            }
            return false;
        }
        catch (RejectedExecutionException e) {
            this.task.logError(RMIExceptionType.EXECUTION_REJECTION, e);
            this.task.completeResponseImpl(new RMIErrorMessage(RMIExceptionType.EXECUTION_REJECTION, e, null), false);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeSubmitted() {
        RMITaskImpl<T> rMITaskImpl = this.task;
        synchronized (rMITaskImpl) {
            switch (this.getState()) {
                case NEW: {
                    this.state = RMIExecutionTaskState.SUBMITTED;
                    return true;
                }
                case SUSPENDED: 
                case RESUMED_WHILE_RUNNING: {
                    this.state = RMIExecutionTaskState.SUBMITTED_ON_RESUME;
                    return true;
                }
            }
            return false;
        }
    }

    @Override
    public void run() {
        RMIService<T> service = this.makeRunning();
        if (service == null) {
            return;
        }
        try {
            if (!this.task.isNestedTask()) {
                if (this.task.isCompleted()) {
                    return;
                }
                if (!this.isOneWayRequest()) {
                    service.openChannel(this.task);
                    this.task.channel.open(this.connection);
                }
            }
            if (!this.task.isCompleted()) {
                service.processTask(this.task);
            }
        }
        catch (Throwable e) {
            this.task.completeExceptionally(RMIExceptionType.EXECUTION_ERROR, e);
        }
        finally {
            this.finishRun();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RMIService<T> makeRunning() {
        boolean submitNextNow;
        RMIService<T> result = null;
        RMITaskImpl<T> rMITaskImpl = this.task;
        synchronized (rMITaskImpl) {
            switch (this.getState()) {
                case SUBMITTED: 
                case SUBMITTED_ON_RESUME: {
                    this.state = RMIExecutionTaskState.RUNNING;
                    result = this.service;
                }
            }
            submitNextNow = this.submitNextNow();
        }
        if (submitNextNow) {
            this.task.channel.submitNextTask(this);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishRun() {
        boolean resubmitExecution = false;
        RMIExceptionType exceptionType = null;
        RMITaskImpl<T> rMITaskImpl = this.task;
        synchronized (rMITaskImpl) {
            switch (this.getState()) {
                case RESUMED_WHILE_RUNNING: {
                    resubmitExecution = true;
                    break;
                }
                case RUNNING: {
                    if (!this.task.hasCancelListener()) {
                        exceptionType = RMIExceptionType.TASK_CANCEL_LISTENER_NOT_SET;
                        break;
                    }
                    this.task.suspendImpl();
                }
            }
        }
        if (exceptionType != null) {
            this.task.completeExceptionally(exceptionType, null);
        }
        if (resubmitExecution && this.submitExecutionNow()) {
            return;
        }
        this.task.channel.submitNextTask(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume(RMIService<T> continuationService) {
        boolean submitExecution = false;
        RMITaskImpl<T> rMITaskImpl = this.task;
        synchronized (rMITaskImpl) {
            this.service = continuationService;
            switch (this.getState()) {
                case SUSPENDED: {
                    submitExecution = true;
                    break;
                }
                case RUNNING: {
                    this.state = RMIExecutionTaskState.RESUMED_WHILE_RUNNING;
                }
            }
        }
        if (submitExecution) {
            this.enqueueForSubmissionSerially();
        }
    }

    void enqueueForSubmissionSerially() {
        this.task.channel.enqueueForSubmissionSerially(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean submitNextNow() {
        RMITaskImpl<T> rMITaskImpl = this.task;
        synchronized (rMITaskImpl) {
            RMIExecutionTaskState state = this.getState();
            return state.isCompleted() || state.isSuspended() || !this.task.isNestedTask() && state == RMIExecutionTaskState.RUNNING;
        }
    }
}

