/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.connector.proto.EndpointId;
import com.devexperts.io.SerialClassContext;
import com.devexperts.logging.Logging;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.QDEndpoint;
import com.devexperts.rmi.RMIEndpoint;
import com.devexperts.rmi.RMIEndpointListener;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequest;
import com.devexperts.rmi.impl.RMIClientImpl;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIConnectorInitializer;
import com.devexperts.rmi.impl.RMIQueueType;
import com.devexperts.rmi.impl.RMIServerImpl;
import com.devexperts.rmi.impl.RMISupportingDXEndpoint;
import com.devexperts.rmi.security.SecurityContext;
import com.devexperts.rmi.security.SecurityController;
import com.devexperts.rmi.task.RMILoadBalancerFactory;
import com.devexperts.rmi.task.RMIServiceImplementation;
import com.devexperts.services.Services;
import com.devexperts.transport.stats.EndpointStats;
import com.devexperts.util.ExecutorProvider;
import com.devexperts.util.SynchronizedIndexedSet;
import com.devexperts.util.SystemProperties;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.impl.ExtensibleDXEndpoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import javax.annotation.concurrent.GuardedBy;
import javax.net.ssl.TrustManager;

public final class RMIEndpointImpl
extends RMIEndpoint {
    static final boolean RMI_TRACE_LOG = RMIEndpointImpl.class.desiredAssertionStatus();
    private static final Logging log = Logging.getLogging(RMIEndpointImpl.class);
    private static final String THREAD_COUNT_SYSTEM_PROPERTY = "com.devexperts.rmi.ThreadCount";
    private final String name;
    private final Object lock;
    private final QDEndpoint qdEndpoint;
    private SerialClassContext serialContext;
    private final SynchronizedIndexedSet<RMIConnection, RMIConnection> connections = new SynchronizedIndexedSet();
    private final List<RMIEndpointListener> endpointListeners = new CopyOnWriteArrayList<RMIEndpointListener>();
    private final RMIClientImpl client;
    private final RMIServerImpl server;
    private String address;
    ExtensibleDXEndpoint dxEndpoint;
    final RMIEndpoint.Side side;
    private final ExecutorProvider defaultExecutorProvider;
    private SecurityController securityController;
    private MessageAdapter.ConfigurableFactory attachedMessageAdapterFactory;
    TrustManager trustManager;
    private volatile List<RMILoadBalancerFactory> loadBalancerFactories;
    @GuardedBy(value="this")
    private boolean closed;

    public RMIEndpointImpl(RMIEndpoint.Side side, QDEndpoint qdEndpoint, MessageAdapter.Factory attachedMessageAdapterFactory, DXEndpoint dxEndpoint) {
        SecurityController securityController;
        if (side == null) {
            throw new NullPointerException();
        }
        if (qdEndpoint == null) {
            throw new NullPointerException();
        }
        if (dxEndpoint != null) {
            if (!(dxEndpoint instanceof RMISupportingDXEndpoint)) {
                throw new IllegalArgumentException("Unsupported instance of DXEndpoint");
            }
            if (((RMISupportingDXEndpoint)((Object)dxEndpoint)).getQDEndpoint() != qdEndpoint) {
                throw new IllegalArgumentException("DXEndpoint for a different QDEndpoint");
            }
        }
        this.name = qdEndpoint.getName();
        this.lock = qdEndpoint.getLock();
        this.side = side;
        this.qdEndpoint = qdEndpoint;
        this.serialContext = SerialClassContext.getDefaultSerialContext(null);
        this.defaultExecutorProvider = new ExecutorProvider(SystemProperties.getIntProperty(THREAD_COUNT_SYSTEM_PROPERTY, Runtime.getRuntime().availableProcessors()), this.name + "-RMIExecutorThread", QDLog.log);
        if (!qdEndpoint.hasConnectorInitializer()) {
            qdEndpoint.setConnectorInitializer(new RMIConnectorInitializer(this));
        }
        if ((securityController = Services.createService(SecurityController.class, null, null)) == null) {
            securityController = SecurityContext.getInstance();
        }
        this.securityController = securityController;
        this.dxEndpoint = (ExtensibleDXEndpoint)dxEndpoint;
        if (attachedMessageAdapterFactory != null) {
            this.setAttachedMessageAdapterFactoryImpl(attachedMessageAdapterFactory);
        }
        this.client = this.side.hasClient() ? new RMIClientImpl(this) : null;
        this.server = this.side.hasServer() ? new RMIServerImpl(this) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String address) {
        if (address == null) {
            throw new NullPointerException();
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.qdEndpoint.isClosed() || address.equals(this.address)) {
                return;
            }
            this.disconnect();
            this.qdEndpoint.connect(address);
            this.setConnectedAddressSync(address);
            if (this.dxEndpoint != null) {
                this.dxEndpoint.setConnectedAddressSync(address);
            }
        }
    }

    public void setConnectedAddressSync(String address) {
        this.address = address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (this.qdEndpoint.isClosed()) {
                return;
            }
            this.qdEndpoint.reconnectActiveConnectors();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            if (this.address == null) {
                return;
            }
            this.address = null;
            this.qdEndpoint.cleanupConnectors();
            this.connections.clear();
            if (this.side.hasClient()) {
                this.getClient().stopTimeoutRequestMonitoringThread();
            }
            if (this.dxEndpoint != null) {
                this.dxEndpoint.disconnect();
            }
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.disconnect();
            this.qdEndpoint.close();
        }
        if (this.client != null) {
            this.client.close();
        }
        if (this.server != null) {
            this.server.close();
        }
    }

    @Override
    public boolean isConnected() {
        return !this.connections.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndpointStats getEndpointStats() {
        Object object = this.lock;
        synchronized (object) {
            return MessageConnectors.getEndpointStats(this.qdEndpoint.getConnectors());
        }
    }

    @Override
    public void addEndpointListener(RMIEndpointListener listener) {
        this.endpointListeners.add(listener);
    }

    @Override
    public void removeEndpointListener(RMIEndpointListener listener) {
        this.endpointListeners.remove(listener);
    }

    @Override
    public void setSerialClassContext(SerialClassContext serialClassContexts) {
        this.serialContext = serialClassContexts;
    }

    @Override
    public SerialClassContext getSerialClassContext() {
        return this.serialContext;
    }

    @Override
    public SecurityController getSecurityController() {
        return this.securityController;
    }

    @Override
    public void setSecurityController(SecurityController securityController) {
        this.securityController = securityController;
    }

    @Override
    public DXEndpoint getDXEndpoint() {
        if (this.dxEndpoint == null) {
            throw new IllegalStateException("There is no DXEndpoint associated with this RMIEndpoint.");
        }
        return this.dxEndpoint;
    }

    @Override
    @Deprecated
    public MessageAdapter.ConfigurableFactory getAttachedMessageAdapterFactory() {
        return this.attachedMessageAdapterFactory;
    }

    @Override
    @Deprecated
    public void setAttachedMessageAdapterFactory(MessageAdapter.Factory attachedMessageAdapterFactory) {
        if (attachedMessageAdapterFactory == null) {
            return;
        }
        if (this.dxEndpoint != null) {
            throw new IllegalStateException("Cannot set attached message factory for dxFeed-enabled endpoint.");
        }
        this.setAttachedMessageAdapterFactoryImpl(attachedMessageAdapterFactory);
    }

    private void setAttachedMessageAdapterFactoryImpl(MessageAdapter.Factory attachedMessageAdapterFactory) {
        if (this.attachedMessageAdapterFactory != null) {
            throw new IllegalStateException("Cannot change attached message factory");
        }
        this.attachedMessageAdapterFactory = MessageConnectors.configurableFactory(attachedMessageAdapterFactory);
        this.attachedMessageAdapterFactory.setEndpoint(RMIEndpoint.class, this);
    }

    @Override
    public void setTrustManager(TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public RMIEndpoint.Side getSide() {
        return this.side;
    }

    @Override
    public RMIServerImpl getServer() {
        if (this.server == null) {
            throw new IllegalStateException("This RMIEndpoint has RMIEndpoint.Side.CLIENT");
        }
        return this.server;
    }

    @Override
    public RMIClientImpl getClient() {
        if (this.client == null) {
            throw new IllegalStateException("This RMIEndpoint has RMIEndpoint.Side.SERVER");
        }
        return this.client;
    }

    @Override
    @Deprecated
    public <T> void export(T implementation, Class<T> serviceInterface) {
        this.getServer().export(implementation, serviceInterface);
    }

    @Override
    @Deprecated
    public <T> void export(T implementation, Class<T> serviceInterface, ExecutorService executor) {
        RMIServiceImplementation<T> service = new RMIServiceImplementation<T>(implementation, serviceInterface);
        service.setExecutor(executor);
        this.getServer().export(service);
    }

    @Override
    @Deprecated
    public <T> void export(T implementation, Class<T> serviceInterface, String serviceName) {
        this.getServer().export(new RMIServiceImplementation<T>(implementation, serviceInterface, serviceName));
    }

    @Override
    @Deprecated
    public <T> void export(T implementation, Class<T> serviceInterface, String serviceName, ExecutorService executor) {
        RMIServiceImplementation<T> service = new RMIServiceImplementation<T>(implementation, serviceInterface, serviceName);
        service.setExecutor(executor);
        this.getServer().export(service);
    }

    @Override
    @Deprecated
    public ExecutorService getDefaultExecutor() {
        return (ExecutorService)this.getServer().getDefaultExecutor();
    }

    @Override
    @Deprecated
    public void setDefaultExecutor(ExecutorService executor) {
        this.getServer().setDefaultExecutor(executor);
    }

    @Override
    @Deprecated
    public <T> T getProxy(Class<T> serviceInterface) {
        return this.getProxy(serviceInterface, serviceInterface.getName());
    }

    @Override
    @Deprecated
    public <T> T getProxy(Class<T> serviceInterface, String serviceName) {
        return this.getClient().getProxy(serviceInterface, serviceName);
    }

    @Override
    @Deprecated
    public <T> RMIRequest<T> createRequest(Object subject, RMIOperation<T> operation, Object ... parameters) {
        return this.getClient().createRequest(subject, operation, parameters);
    }

    @Override
    @Deprecated
    public <T> RMIRequest<T> createOneWayRequest(Object subject, RMIOperation<T> operation, Object ... parameters) {
        return this.getClient().createOneWayRequest(subject, operation, parameters);
    }

    @Override
    @Deprecated
    public void setRequestSendingTimeout(long timeout) {
        this.getClient().setRequestSendingTimeout(timeout);
    }

    @Override
    @Deprecated
    public long getRequestSendingTimeout() {
        return this.getClient().getRequestSendingTimeout();
    }

    @Override
    @Deprecated
    public void setRequestRunningTimeout(long timeout) {
        this.getClient().setRequestRunningTimeout(timeout);
    }

    @Override
    @Deprecated
    public long getRequestRunningTimeout() {
        return this.getClient().getRequestRunningTimeout();
    }

    @Override
    @Deprecated
    public void setStoredSubjectsLimit(int limit) {
        this.getClient().setStoredSubjectsLimit(limit);
    }

    @Override
    @Deprecated
    public int getStoredSubjectsLimit() {
        return this.getClient().getStoredSubjectsLimit();
    }

    @Override
    @Deprecated
    public int getSendingRequestsQueueLength() {
        return this.getClient().getSendingRequestsQueueLength();
    }

    public String toString() {
        return "RMIEndpoint{side=" + (Object)((Object)this.side) + ",id=" + this.getEndpointId() + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<RMILoadBalancerFactory> getRMILoadBalancerFactories() {
        List<RMILoadBalancerFactory> factories = this.loadBalancerFactories;
        if (factories != null) {
            return factories;
        }
        Object object = this.lock;
        synchronized (object) {
            factories = this.loadBalancerFactories;
            if (factories != null) {
                return factories;
            }
            Iterable<RMILoadBalancerFactory> factoryServices = Services.createServices(RMILoadBalancerFactory.class, null);
            ArrayList factoryList = new ArrayList();
            factoryServices.forEach(factoryList::add);
            this.loadBalancerFactories = Collections.unmodifiableList(factoryList);
            return this.loadBalancerFactories;
        }
    }

    public QDEndpoint getQdEndpoint() {
        return this.qdEndpoint;
    }

    public EndpointId getEndpointId() {
        return this.qdEndpoint.getEndpointId();
    }

    Object getLock() {
        return this.lock;
    }

    ExecutorProvider getDefaultExecutorProvider() {
        return this.defaultExecutorProvider;
    }

    void registerConnection(RMIConnection connection) {
        this.connections.add(connection);
        this.notifyListeners();
        if (this.side.hasClient() && this.getClient().getSendingRequestsQueueLength() > 0) {
            connection.messageAdapter.rmiMessageAvailable(RMIQueueType.REQUEST);
        }
    }

    void unregisterConnection(RMIConnection connection) {
        this.connections.remove(connection);
        if (this.side.hasClient()) {
            this.getClient().removeConnection(connection);
        }
        this.notifyListeners();
    }

    Iterator<RMIConnection> concurrentConnectionsIterator() {
        return this.connections.concurrentIterator();
    }

    private void notifyListeners() {
        for (RMIEndpointListener listener : this.endpointListeners) {
            try {
                listener.stateChanged(this);
            }
            catch (Throwable t) {
                log.error("Error in RMIEndpointListener", t);
            }
        }
    }
}

