/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.connector.codec.ssl.SSLConnectionFactory;
import com.devexperts.connector.proto.Configurable;
import com.devexperts.connector.proto.ConfigurationException;
import com.devexperts.connector.proto.ConfigurationKey;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.qtp.MessageConnector;
import com.devexperts.qd.qtp.MessageConnectors;
import com.devexperts.qd.qtp.QDEndpoint;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.rmi.impl.AdvertisementFilter;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.ServiceFilter;
import com.devexperts.util.SystemProperties;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class RMIConnectorInitializer
implements QDEndpoint.ConnectorInitializer {
    public static final int DEFAULT_WEIGHT = SystemProperties.getIntProperty(RMIConnectorInitializer.class, "defaultWeight", 10);
    private RMIEndpointImpl rmiEndpoint;

    public RMIConnectorInitializer(RMIEndpointImpl rmiEndpoint) {
        this.rmiEndpoint = rmiEndpoint;
    }

    @Override
    public void createAndAddConnector(QDEndpoint qdEndpoint, String address) {
        List<MessageConnector> connectors = MessageConnectors.createMessageConnectors(MessageConnectors.applicationConnectionFactory(new AdapterFactory()), address, qdEndpoint.getRootStats());
        if (this.rmiEndpoint.trustManager != null) {
            try {
                for (MessageConnector connector : connectors) {
                    SSLConnectionFactory factory = MessageConnectors.getCodecFactory(connector.getFactory(), SSLConnectionFactory.class);
                    if (factory == null) continue;
                    factory.setTrustManager(this.rmiEndpoint.trustManager);
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Trust store may be specified for client socket connector only", e);
            }
        }
        qdEndpoint.addConnectors(connectors);
        this.rmiEndpoint.setConnectedAddressSync(address);
    }

    private class AdapterFactory
    extends MessageAdapter.ConfigurableFactory {
        private ServiceFilter services = ServiceFilter.ANYTHING;
        private AdvertisementFilter advertisementFilter = AdvertisementFilter.ALL;
        private int weight = DEFAULT_WEIGHT;
        private MessageAdapter.ConfigurableFactory attachedMessageAdapterFactory = RMIConnectorInitializer.access$100(RMIConnectorInitializer.this).getAttachedMessageAdapterFactory();

        private AdapterFactory() {
        }

        @Override
        public MessageAdapter createAdapter(QDStats stats) {
            MessageAdapter attachedAdapter = this.attachedMessageAdapterFactory == null ? null : this.attachedMessageAdapterFactory.createAdapter(stats);
            return new RMIConnection((RMIEndpointImpl)((RMIConnectorInitializer)RMIConnectorInitializer.this).rmiEndpoint, (QDStats)stats, (MessageAdapter)attachedAdapter, (ServiceFilter)this.services, (AdvertisementFilter)this.advertisementFilter, (int)this.weight).messageAdapter;
        }

        @Override
        public MessageAdapter.ConfigurableFactory clone() {
            AdapterFactory clone = (AdapterFactory)super.clone();
            if (this.attachedMessageAdapterFactory != null) {
                clone.attachedMessageAdapterFactory = this.attachedMessageAdapterFactory.clone();
            }
            return clone;
        }

        @Override
        public Set<ConfigurationKey<?>> supportedConfiguration() {
            if (this.attachedMessageAdapterFactory != null) {
                LinkedHashSet set = new LinkedHashSet(this.attachedMessageAdapterFactory.supportedConfiguration());
                set.addAll(super.supportedConfiguration());
                return set;
            }
            return super.supportedConfiguration();
        }

        @Override
        public <T> T getConfiguration(ConfigurationKey<T> key) {
            if (this.attachedMessageAdapterFactory != null && this.attachedMessageAdapterFactory.supportedConfiguration().contains(key)) {
                return this.attachedMessageAdapterFactory.getConfiguration(key);
            }
            return super.getConfiguration(key);
        }

        @Override
        public <T> boolean setConfiguration(ConfigurationKey<T> key, T value) throws ConfigurationException {
            if (this.attachedMessageAdapterFactory != null && this.attachedMessageAdapterFactory.supportedConfiguration().contains(key)) {
                return this.attachedMessageAdapterFactory.setConfiguration(key, value);
            }
            return super.setConfiguration(key, value);
        }

        @Configurable(description="advertised services pattern/filter")
        public void setServices(ServiceFilter services) {
            this.services = services;
        }

        public ServiceFilter getServices() {
            return this.services;
        }

        @Configurable(description="services advertisement mode on this connection")
        public void setAdvertise(AdvertisementFilter filter) {
            this.advertisementFilter = filter;
        }

        public AdvertisementFilter getAdvertise() {
            return this.advertisementFilter;
        }

        @Configurable(description="connection weight")
        public void setWeight(int weight) {
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }

        @Override
        public <T> void setEndpoint(Class<?> endpointClass, T endpointInstance) {
            if (this.attachedMessageAdapterFactory == null) {
                super.setEndpoint(endpointClass, endpointInstance);
            } else {
                this.attachedMessageAdapterFactory.setEndpoint(endpointClass, endpointInstance);
            }
        }

        @Override
        public <T> T getEndpoint(Class<T> endpointClass) {
            if (this.attachedMessageAdapterFactory == null) {
                return super.getEndpoint(endpointClass);
            }
            return this.attachedMessageAdapterFactory.getEndpoint(endpointClass);
        }

        @Override
        public String toString() {
            return this.attachedMessageAdapterFactory == null ? "RMI" : this.attachedMessageAdapterFactory.toString();
        }
    }
}

