/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.connector.proto.EndpointId;
import com.devexperts.connector.proto.TransportConnection;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.qd.stats.QDStats;
import com.devexperts.rmi.RMIEndpoint;
import com.devexperts.rmi.impl.AdvertisementFilter;
import com.devexperts.rmi.impl.ChannelsManager;
import com.devexperts.rmi.impl.ClientDescriptorsManager;
import com.devexperts.rmi.impl.MessageComposer;
import com.devexperts.rmi.impl.MessageProcessor;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIMessageAdapter;
import com.devexperts.rmi.impl.RequestsManager;
import com.devexperts.rmi.impl.ServerDescriptorsManager;
import com.devexperts.rmi.impl.ServiceFilter;
import com.devexperts.rmi.impl.TasksManager;
import com.devexperts.util.TypedMap;

class RMIConnection {
    volatile boolean closed;
    final RMIEndpointImpl endpoint;
    final RequestsManager requestsManager;
    final TasksManager tasksManager;
    final ClientDescriptorsManager clientDescriptorsManager;
    final ServerDescriptorsManager serverDescriptorsManager;
    final ChannelsManager channelsManager;
    final MessageComposer messageComposer;
    final MessageProcessor messageProcessor;
    final RMIMessageAdapter messageAdapter;
    final RMIEndpoint.Side side;
    final int weight;
    final ServiceFilter configuredServices;
    final AdvertisementFilter adFilter;

    RMIConnection(RMIEndpointImpl endpoint, QDStats stats, MessageAdapter attachedAdapter, ServiceFilter services, AdvertisementFilter adFilter, int weight) {
        this.endpoint = endpoint;
        this.side = endpoint.side;
        this.configuredServices = services;
        this.adFilter = adFilter;
        this.messageComposer = new MessageComposer(this);
        this.messageProcessor = new MessageProcessor(this);
        this.requestsManager = new RequestsManager(this);
        this.tasksManager = new TasksManager(this);
        this.clientDescriptorsManager = new ClientDescriptorsManager();
        this.serverDescriptorsManager = new ServerDescriptorsManager(this);
        this.channelsManager = new ChannelsManager();
        this.messageAdapter = new RMIMessageAdapter(this, stats, attachedAdapter);
        this.weight = weight;
    }

    void start() {
        this.endpoint.registerConnection(this);
    }

    void close() {
        this.closed = true;
        this.endpoint.unregisterConnection(this);
        this.requestsManager.close();
        this.messageProcessor.close();
        this.tasksManager.close();
        this.messageComposer.close();
    }

    TypedMap variables() {
        return this.messageAdapter.getConnectionVariables();
    }

    String getRemoteHostAddress() {
        return this.variables().get(TransportConnection.REMOTE_HOST_ADDRESS_KEY);
    }

    EndpointId getRemoteEndpointId() {
        return this.messageAdapter.getRemoteEndpointId();
    }

    Object getSubject() {
        return this.variables().get(TransportConnection.SUBJECT_KEY);
    }

    public String toString() {
        return "RMIConnection{" + this.endpoint + "}";
    }
}

