/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.logging.Logging;
import com.devexperts.rmi.RMIClient;
import com.devexperts.rmi.RMIRequest;
import com.devexperts.rmi.impl.ForwardService;
import com.devexperts.rmi.impl.RMIClientImpl;
import com.devexperts.rmi.impl.ServiceFilter;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceDescriptorsListener;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.rmi.task.RMITask;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.TypedKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nonnull;

class RMIClientService
extends ForwardService {
    private static final TypedKey<RMIRequest> REQUEST = new TypedKey();
    private final IndexedSet<RMIServiceId, RMIServiceDescriptor> descriptors = IndexedSet.create(RMIServiceDescriptor.INDEXER_BY_SERVICE_ID);
    private final List<RMIServiceDescriptorsListener> listeners = new CopyOnWriteArrayList<RMIServiceDescriptorsListener>();
    private final ServiceFilter filter;
    private final RMIClient client;

    RMIClientService(String serviceName, RMIClientImpl client) {
        super(serviceName, client.getPort(null));
        this.filter = ServiceFilter.valueOf(serviceName);
        this.client = client;
    }

    @Override
    public synchronized void addServiceDescriptorsListener(RMIServiceDescriptorsListener listener) {
        super.addServiceDescriptorsListener(listener);
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeServiceDescriptorsListener(RMIServiceDescriptorsListener listener) {
        super.removeServiceDescriptorsListener(listener);
        this.listeners.remove(listener);
    }

    @Override
    public void openChannel(RMITask<Object> task) {
        RMIRequest<Object> request = this.client.getPort(task.getSubject()).createRequest(task.getRequestMessage());
        request.getChannel().addChannelHandler(new ForwardService("*", task.getChannel()));
        task.getChannel().addChannelHandler(new ForwardService("*", request.getChannel()));
        task.getTaskVariables().set(REQUEST, request);
    }

    @Override
    RMIRequest<?> createRequest(RMITask<?> task) {
        if (task.getRequestMessage().getRequestType() == RMIRequestType.ONE_WAY) {
            return this.client.getPort(task.getSubject()).createRequest(task.getRequestMessage());
        }
        return task.getTaskVariables().get(REQUEST);
    }

    synchronized void updateDescriptors(List<RMIServiceDescriptor> descriptors) {
        for (RMIServiceDescriptor descriptor : descriptors) {
            if (descriptor.isAvailable()) {
                this.descriptors.add(descriptor);
                continue;
            }
            this.descriptors.remove(descriptor);
        }
        for (RMIServiceDescriptorsListener listener : this.listeners) {
            try {
                listener.descriptorsUpdated(Collections.unmodifiableList(descriptors));
            }
            catch (Throwable t) {
                Logging.getLogging(RMIClientService.class).error("Failed to update service descriptors", t);
            }
        }
    }

    @Override
    @Nonnull
    public List<RMIServiceDescriptor> getDescriptors() {
        return Arrays.asList(this.descriptors.toArray(new RMIServiceDescriptor[this.descriptors.size()]));
    }

    @Override
    public boolean isAvailable() {
        return !this.descriptors.isEmpty();
    }

    ServiceFilter getFilter() {
        return this.filter;
    }
}

