/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.io.Marshalled;
import com.devexperts.rmi.RMIClientPort;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequest;
import com.devexperts.rmi.impl.ObjectMethods;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIRequestImpl;
import com.devexperts.rmi.impl.RMIRequestInvocationHandler;
import com.devexperts.rmi.impl.RequestSender;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.message.RMIRoute;
import com.devexperts.rmi.task.RMIService;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

abstract class RMIClientPortImpl
implements RMIClientPort {
    @Nullable
    private final Marshalled<?> subject;
    private final RMIEndpointImpl endpoint;
    @GuardedBy(value="this")
    private Map<String, Object> cachedProxies;

    protected RMIClientPortImpl(RMIEndpointImpl endpoint, @Nullable Marshalled<?> subject) {
        this.subject = subject;
        this.endpoint = endpoint;
    }

    protected abstract RequestSender getRequestSender();

    @Override
    public Marshalled<?> getSubject() {
        if (this.subject != null) {
            return this.subject;
        }
        return Marshalled.forObject(this.endpoint.getSecurityController().getSubject());
    }

    @Override
    public boolean isOpen() {
        return !this.endpoint.getQdEndpoint().isClosed();
    }

    @Override
    public synchronized <V> V getProxy(Class<V> serviceInterface, String serviceName) {
        Object proxy;
        if (this.cachedProxies == null) {
            this.cachedProxies = new HashMap<String, Object>();
        }
        if ((proxy = this.cachedProxies.get(serviceName)) == null) {
            proxy = Proxy.newProxyInstance(serviceInterface.getClassLoader(), new Class[]{serviceInterface}, (InvocationHandler)new RMIRequestInvocationHandler(this, serviceName, RMIClientPortImpl.getObjectOverrideMethods(serviceInterface)));
            this.cachedProxies.put(serviceName, proxy);
        }
        if (!serviceInterface.isInstance(proxy)) {
            throw new IllegalArgumentException("Wrong interface");
        }
        return (V)proxy;
    }

    @Override
    public <V> V getProxy(Class<V> serviceInterface) {
        return this.getProxy(serviceInterface, RMIService.getServiceName(serviceInterface));
    }

    @Override
    public <T> RMIRequest<T> createRequest(RMIRequestType type, RMIOperation<T> operation, Object ... parameters) {
        return new RMIRequestImpl<T>(this.getRequestSender(), this.getSubject(), this.createRequestMessage(type, operation, parameters));
    }

    @Override
    public <T> RMIRequest<T> createRequest(RMIRequestMessage<T> message) {
        return new RMIRequestImpl<T>(this.getRequestSender(), this.getSubject(), this.updateRequestMessage(message));
    }

    private static <T> EnumSet<ObjectMethods> getObjectOverrideMethods(Class<T> serviceInterface) {
        EnumSet<ObjectMethods> result = EnumSet.noneOf(ObjectMethods.class);
        for (Method method : serviceInterface.getMethods()) {
            if (ObjectMethods.getMethod(method) == null) continue;
            result.add(ObjectMethods.getMethod(method));
        }
        return result;
    }

    protected final RMIEndpointImpl getEndpoint() {
        return this.endpoint;
    }

    @Nonnull
    protected final <T> RMIRequestMessage<T> createRequestMessage(RMIRequestType type, RMIOperation<T> operation, Object[] parameters) {
        RMIRoute route = RMIRoute.createRMIRoute(this.endpoint.getEndpointId());
        return new RMIRequestMessage<T>(type, operation, Marshalled.forObject(parameters, operation.getParametersMarshaller()), route, null);
    }

    @Nonnull
    protected final <T> RMIRequestMessage<T> updateRequestMessage(RMIRequestMessage<T> message) {
        RMIRoute route = message.getRoute().append(this.endpoint.getEndpointId());
        return message.changeTargetRoute(message.getTarget(), route);
    }
}

