/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.io.Marshalled;
import com.devexperts.logging.Logging;
import com.devexperts.rmi.RMIClient;
import com.devexperts.rmi.RMIClientPort;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequest;
import com.devexperts.rmi.impl.ClientSideServices;
import com.devexperts.rmi.impl.PendingRequests;
import com.devexperts.rmi.impl.RMIClientPortImpl;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIFailedException;
import com.devexperts.rmi.impl.RMILog;
import com.devexperts.rmi.impl.RMIRequestImpl;
import com.devexperts.rmi.impl.RMITimeoutRequestMonitoringThread;
import com.devexperts.rmi.impl.RequestSender;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.message.RMIRoute;
import com.devexperts.rmi.task.BalanceResult;
import com.devexperts.rmi.task.RMIService;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.util.ExecutorProvider;
import com.devexperts.util.SystemProperties;
import com.dxfeed.api.DXEndpoint;
import com.dxfeed.api.impl.ExtensibleDXEndpoint;
import com.dxfeed.promise.Promise;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;

public class RMIClientImpl
extends RMIClient {
    private static final Logging log = Logging.getLogging(RMIClientImpl.class);
    final RMIEndpointImpl endpoint;
    private long requestSendingTimeout = SystemProperties.getLongProperty("com.devexperts.rmi.RequestSendingTimeout", 60000L);
    private long requestRunningTimeout = SystemProperties.getLongProperty("com.devexperts.rmi.RequestRunningTimeout", Long.MAX_VALUE);
    private int storedSubjectsLimit = SystemProperties.getIntProperty("com.devexperts.rmi.StoredSubjectsLimit", 100000);
    @GuardedBy(value="services")
    private final ClientSideServices services;
    private final PendingRequests pendingRequests = new PendingRequests();
    private final RMITimeoutRequestMonitoringThread timeoutRequestMonitoringThread;
    private final ClientRequestSender requestSender;
    private final RMIClientPort defaultPort;
    private final ExecutorProvider.Reference defaultExecutorReference;

    RMIClientImpl(RMIEndpointImpl endpoint) {
        this.endpoint = endpoint;
        this.services = new ClientSideServices(this, endpoint.getRMILoadBalancerFactories());
        this.timeoutRequestMonitoringThread = new RMITimeoutRequestMonitoringThread(endpoint);
        this.requestSender = new ClientRequestSender();
        this.defaultPort = new PortImpl(null);
        ExecutorProvider.Reference sharedExecutorReference = this.getSharedExecutorReference();
        this.defaultExecutorReference = sharedExecutorReference != null ? sharedExecutorReference : endpoint.getDefaultExecutorProvider().newReference();
    }

    @Override
    public <T> RMIRequest<T> createRequest(Object subject, RMIOperation<T> operation, Object ... parameters) {
        return this.getPort(Marshalled.forObject(subject)).createRequest(operation, parameters);
    }

    @Override
    public <T> RMIRequest<T> createOneWayRequest(Object subject, RMIOperation<T> operation, Object ... parameters) {
        RMIRoute route = RMIRoute.createRMIRoute(this.endpoint.getEndpointId());
        RMIRequestMessage<T> requestMessage = new RMIRequestMessage<T>(RMIRequestType.ONE_WAY, operation, Marshalled.forObject(parameters, operation.getParametersMarshaller()), route, null);
        return this.getPort(Marshalled.forObject(subject)).createRequest(requestMessage);
    }

    @Override
    public RMIClientPort getPort(Object subject) {
        if (subject == null) {
            return this.defaultPort;
        }
        Marshalled<Object> marshalledSubject = subject instanceof Marshalled ? (Marshalled<Object>)subject : Marshalled.forObject(subject);
        return new PortImpl(marshalledSubject);
    }

    @Override
    public <T> RMIRequest<T> createRequest(RMIRequestMessage<T> message) {
        return this.defaultPort.createRequest(message);
    }

    @Override
    public <T> T getProxy(Class<T> serviceInterface) {
        return this.defaultPort.getProxy(serviceInterface, RMIService.getServiceName(serviceInterface));
    }

    @Override
    public <T> T getProxy(Class<T> serviceInterface, String serviceName) {
        return this.defaultPort.getProxy(serviceInterface, serviceName);
    }

    @Override
    public RMIService<?> getService(String serviceName) {
        return this.services.getService(serviceName);
    }

    @Override
    public void setDefaultExecutor(Executor executor) {
        this.defaultExecutorReference.setExecutor(executor);
    }

    @Override
    public Executor getDefaultExecutor() {
        return this.defaultExecutorReference.getOrCreateExecutor();
    }

    @Override
    public void setRequestSendingTimeout(long timeout) {
        this.requestSendingTimeout = timeout;
        this.timeoutRequestMonitoringThread.wakeUp();
    }

    @Override
    public long getRequestSendingTimeout() {
        return this.requestSendingTimeout;
    }

    @Override
    public void setRequestRunningTimeout(long timeout) {
        this.requestRunningTimeout = timeout;
        this.timeoutRequestMonitoringThread.wakeUp();
    }

    @Override
    public long getRequestRunningTimeout() {
        return this.requestRunningTimeout;
    }

    @Override
    public void setStoredSubjectsLimit(int limit) {
        this.storedSubjectsLimit = limit;
    }

    @Override
    public int getStoredSubjectsLimit() {
        return this.storedSubjectsLimit;
    }

    @Override
    public int getSendingRequestsQueueLength() {
        return this.pendingRequests.size();
    }

    private ExecutorProvider.Reference getSharedExecutorReference() {
        ExtensibleDXEndpoint dx = this.endpoint.dxEndpoint;
        return dx != null && dx.getRole() == DXEndpoint.Role.FEED ? dx.getExecutorReference() : null;
    }

    void close() {
        this.services.close();
        this.timeoutRequestMonitoringThread.wakeUp();
        ExecutorProvider.Reference sharedExecutorReference = this.getSharedExecutorReference();
        if (this.defaultExecutorReference != sharedExecutorReference) {
            this.defaultExecutorReference.close();
        }
    }

    ClientSideServices getServices() {
        return this.services;
    }

    void forEachPendingRequest(@Nonnull Consumer<RMIRequestImpl<?>> consumer) {
        this.pendingRequests.forEachRMIRequest(consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateServiceDescriptors(List<RMIServiceDescriptor> descriptors, RMIConnection connection) {
        ClientSideServices clientSideServices = this.services;
        synchronized (clientSideServices) {
            if (connection.requestsManager.isAnonymous()) {
                this.services.updateAnonymousRouter(connection);
                this.rebalancePendingRequests(null);
            } else {
                connection.clientDescriptorsManager.updateDescriptors(descriptors);
                this.services.updateDescriptorAndUpdateServices(descriptors, connection);
                this.rebalancePendingRequests(descriptors);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(RMIConnection connection) {
        ClientSideServices clientSideServices = this.services;
        synchronized (clientSideServices) {
            ArrayList<RMIServiceDescriptor> result = new ArrayList<RMIServiceDescriptor>();
            for (RMIServiceDescriptor descriptor : connection.clientDescriptorsManager.clearDescriptors()) {
                result.add(RMIServiceDescriptor.createUnavailableDescriptor(descriptor.getServiceId(), descriptor.getProperties()));
            }
            this.updateServiceDescriptors(result, connection);
        }
    }

    @GuardedBy(value="services")
    private void balance(RMIRequestImpl<?> request) {
        Promise<BalanceResult> balancePromise = this.services.balance(request.getRequestMessage());
        if (balancePromise.isDone()) {
            RMILog.logBalancingCompletion(request, balancePromise);
            this.balancingCompleted(request, balancePromise);
            return;
        }
        this.pendingRequests.addBalancePromise(request, balancePromise, this::balancingCompleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void balancingCompleted(RMIRequestImpl<?> request, Promise<? extends BalanceResult> result) {
        if (request.isCompleted()) {
            return;
        }
        if (result.hasException() || result.getResult().isReject()) {
            Throwable cause = result.hasException() ? result.getException() : new RMIFailedException(result.getResult().getRejectReason());
            request.setFailedState(RMIExceptionType.SERVICE_UNAVAILABLE, cause);
            return;
        }
        BalanceResult decision = result.getResult();
        ClientSideServices clientSideServices = this.services;
        synchronized (clientSideServices) {
            request.setTentativeTarget(decision.getTarget());
            RMIConnection connection = this.services.getConnection(request.getTentativeTarget());
            if (connection != null) {
                connection.requestsManager.addOutgoingRequest(request);
            } else {
                this.pendingRequests.addPendingRequest(request);
            }
        }
    }

    @GuardedBy(value="services")
    private void rebalancePendingRequests(List<RMIServiceDescriptor> descriptors) {
        Iterator<RMIConnection> it = this.endpoint.concurrentConnectionsIterator();
        while (it.hasNext()) {
            RMIConnection connection = it.next();
            List<RMIRequestImpl<?>> requests = connection.requestsManager.getByDescriptorsAndRemove(descriptors);
            if (requests == null || requests.isEmpty()) continue;
            for (RMIRequestImpl<?> request : requests) {
                this.pendingRequests.addPendingRequest(request);
            }
        }
        List<RMIRequestImpl<?>> toBeRebalanced = this.pendingRequests.removeAllBalanced();
        toBeRebalanced.forEach(rmiRequest -> {
            rmiRequest.setTentativeTarget(null);
            rmiRequest.assignConnection(null);
            this.balance((RMIRequestImpl<?>)rmiRequest);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOutgoingRequestImpl(RMIRequestImpl<?> request) {
        ClientSideServices clientSideServices = this.services;
        synchronized (clientSideServices) {
            if (RMIEndpointImpl.RMI_TRACE_LOG) {
                log.trace("Add outgoing request " + request + " to " + this.endpoint);
            }
            this.balance(request);
        }
        this.timeoutRequestMonitoringThread.startIfNotAlive();
    }

    void stopTimeoutRequestMonitoringThread() {
        this.timeoutRequestMonitoringThread.stop();
    }

    private class PortImpl
    extends RMIClientPortImpl {
        PortImpl(Marshalled<?> marshalledSubject) {
            super(RMIClientImpl.this.endpoint, marshalledSubject);
        }

        @Override
        protected RequestSender getRequestSender() {
            return RMIClientImpl.this.requestSender;
        }
    }

    private class ClientRequestSender
    extends RequestSender {
        private ClientRequestSender() {
        }

        @Override
        void startTimeoutRequestMonitoringThread() {
            RMIClientImpl.this.timeoutRequestMonitoringThread.startIfNotAlive();
        }

        @Override
        RMIEndpointImpl getEndpoint() {
            return RMIClientImpl.this.endpoint;
        }

        @Override
        public Executor getExecutor() {
            return RMIClientImpl.this.getDefaultExecutor();
        }

        @Override
        public void addOutgoingRequest(RMIRequestImpl<?> request) {
            RMIClientImpl.this.addOutgoingRequestImpl(request);
        }

        @Override
        public boolean dropPendingRequest(RMIRequestImpl<?> request) {
            return RMIClientImpl.this.pendingRequests.dropPendingRequest(request.getId());
        }
    }
}

