/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.io.Marshalled;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequest;
import com.devexperts.rmi.impl.RMIChannelOwner;
import com.devexperts.rmi.impl.RMIClientPortImpl;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIExecutionTaskImpl;
import com.devexperts.rmi.impl.RMIRequestImpl;
import com.devexperts.rmi.impl.RMITaskImpl;
import com.devexperts.rmi.impl.RequestSender;
import com.devexperts.rmi.impl.ServerRequestInfo;
import com.devexperts.rmi.message.RMICancelType;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.task.RMIChannel;
import com.devexperts.rmi.task.RMIChannelState;
import com.devexperts.rmi.task.RMIChannelType;
import com.devexperts.rmi.task.RMIService;
import com.devexperts.rmi.task.RMIServiceImplementation;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.IndexerFunction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.concurrent.GuardedBy;

class RMIChannelImpl
extends RMIClientPortImpl
implements RMIChannel {
    static final IndexerFunction.LongKey<RMIChannelImpl> CHANNEL_INDEXER_BY_REQUEST_ID = value -> value.channelId;
    private final ChannelRequestSender requestSender = new ChannelRequestSender();
    private final RMIChannelOwner owner;
    private final long channelId;
    private final RMIChannelType type;
    @GuardedBy(value="this")
    private final IndexedSet<String, RMIService<?>> handlers = IndexedSet.create(RMIService.RMI_SERVICE_INDEXER);
    @GuardedBy(value="this")
    private volatile RMIChannelState state = RMIChannelState.NEW;
    @GuardedBy(value="this")
    private List<RMIRequestImpl<?>> preOpenOutgoingRequests;
    @GuardedBy(value="this")
    private List<ServerRequestInfo> preOpenIncomingRequests;
    @GuardedBy(value="this")
    private RMIConnection connection;
    @GuardedBy(value="this")
    private ArrayDeque<RMIExecutionTaskImpl<?>> executionTasks;

    RMIChannelImpl(RMIEndpointImpl endpoint, Marshalled<?> subject, long channelId, RMIChannelOwner owner) {
        super(endpoint, subject);
        assert (subject != null);
        this.owner = owner;
        this.type = owner.getChannelType();
        this.channelId = channelId;
    }

    @Override
    public Object getOwner() {
        return this.owner;
    }

    @Override
    public <T> RMIRequest<T> createRequest(RMIRequestType type, RMIOperation<T> operation, Object ... parameters) {
        return new RMIRequestImpl<T>((RequestSender)this.requestSender, this, this.createRequestMessage(type, operation, parameters));
    }

    @Override
    public <T> RMIRequest<T> createRequest(RMIRequestMessage<T> message) {
        return new RMIRequestImpl<T>((RequestSender)this.requestSender, this, this.updateRequestMessage(message));
    }

    @Override
    public boolean isOpen() {
        return this.state == RMIChannelState.OPEN;
    }

    @Override
    public synchronized void addChannelHandler(RMIService<?> handler) {
        if (this.state != RMIChannelState.NEW) {
            throw new IllegalStateException("The channel has already been opened or closed");
        }
        if (this.handlers.containsKey(handler.getServiceName())) {
            throw new IllegalArgumentException("Handler named " + handler.getServiceName() + " has been added");
        }
        this.handlers.add(handler);
    }

    @Override
    public RMIChannelState getState() {
        return this.state;
    }

    @Override
    public <T> void addChannelHandler(T implementation, Class<T> handlerInterface) {
        this.addChannelHandler(new RMIServiceImplementation<T>(implementation, handlerInterface, RMIService.getServiceName(handlerInterface)));
    }

    @Override
    public synchronized void removeChannelHandler(RMIService<?> handler) {
        this.handlers.removeValue(handler);
    }

    @Override
    public RMIChannelType getType() {
        return this.type;
    }

    @Override
    protected RequestSender getRequestSender() {
        return this.requestSender;
    }

    long getChannelId() {
        return this.channelId;
    }

    synchronized void registerChannel(RMIConnection connection) {
        assert (this.connection == null);
        this.connection = connection;
        connection.channelsManager.addChannel(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open(RMIConnection connection) {
        List<ServerRequestInfo> preOpenIncomingRequests;
        RMIChannelImpl rMIChannelImpl = this;
        synchronized (rMIChannelImpl) {
            if (this.state == RMIChannelState.CLOSED) {
                return;
            }
            if (connection.closed) {
                return;
            }
            if (this.type == RMIChannelType.CLIENT_CHANNEL) {
                assert (this.connection == null);
                this.registerChannel(connection);
            }
            if (this.state == RMIChannelState.CANCELLING) {
                if (this.preOpenOutgoingRequests != null && !this.preOpenOutgoingRequests.isEmpty()) {
                    connection.requestsManager.addOutgoingRequest(this.preOpenOutgoingRequests.get(0));
                }
                this.preOpenOutgoingRequests = null;
                this.preOpenIncomingRequests = null;
                return;
            }
            this.state = RMIChannelState.OPEN;
            if (this.preOpenOutgoingRequests != null) {
                this.preOpenOutgoingRequests.forEach(connection.requestsManager::addOutgoingRequest);
                this.preOpenOutgoingRequests = null;
            }
            preOpenIncomingRequests = this.preOpenIncomingRequests;
            this.preOpenIncomingRequests = null;
        }
        if (preOpenIncomingRequests != null) {
            for (ServerRequestInfo requestInfo : preOpenIncomingRequests) {
                connection.messageProcessor.createAndSubmitTask(this, requestInfo);
            }
        }
    }

    synchronized void close() {
        if (this.state == RMIChannelState.CLOSED) {
            return;
        }
        if (this.state == RMIChannelState.NEW) {
            this.preOpenOutgoingRequests = null;
            this.preOpenIncomingRequests = null;
        }
        this.state = RMIChannelState.CLOSED;
        if (this.connection != null) {
            this.connection.channelsManager.removeChannel(this.channelId, this.type);
            this.connection.tasksManager.notifyTaskCompleted(this.owner, this.channelId);
        }
    }

    synchronized RMIService<?> getHandler(String handlerName) {
        RMIService<?> result = this.handlers.getByKey(handlerName);
        if (result != null) {
            return result;
        }
        return this.handlers.getByKey("*");
    }

    public String toString() {
        return "Channel{channelId=" + this.channelId + ", type=" + (Object)((Object)this.type) + ", owner=" + this.owner + ", state=" + (Object)((Object)this.state) + "}";
    }

    synchronized void cancel(RMICancelType cancel) {
        if (this.type == RMIChannelType.SERVER_CHANNEL) {
            if (cancel == RMICancelType.ABORT_RUNNING) {
                ((RMITaskImpl)this.owner).cancel();
            } else {
                ((RMITaskImpl)this.owner).cancelWithConfirmation();
            }
            return;
        }
        switch (this.state) {
            case NEW: {
                if (this.preOpenOutgoingRequests == null) {
                    this.preOpenOutgoingRequests = new ArrayList();
                }
                for (RMIRequestImpl<?> request2 : this.preOpenOutgoingRequests) {
                    request2.setFailedState(RMIExceptionType.CHANNEL_CLOSED, null);
                }
                this.preOpenOutgoingRequests.clear();
                break;
            }
            case OPEN: {
                this.connection.tasksManager.cancelAllTasks(this.getChannelId(), cancel.getId(), this.type);
                break;
            }
            default: {
                return;
            }
        }
        RMIRequest<Void> cancelChannel = this.createRequest(new RMIRequestMessage<Void>(RMIRequestType.ONE_WAY, cancel == RMICancelType.ABORT_RUNNING ? RMIRequestImpl.ABORT_CANCEL : RMIRequestImpl.CANCEL_WITH_CONFIRMATION, 0L));
        cancelChannel.setListener(request -> this.close());
        this.state = RMIChannelState.CANCELLING;
        cancelChannel.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addIncomingRequest(ServerRequestInfo request) {
        RMIChannelImpl rMIChannelImpl = this;
        synchronized (rMIChannelImpl) {
            switch (this.state) {
                case NEW: {
                    if (this.preOpenIncomingRequests == null) {
                        this.preOpenIncomingRequests = new ArrayList<ServerRequestInfo>();
                    }
                    this.preOpenIncomingRequests.add(request);
                    return true;
                }
                case CLOSED: {
                    return false;
                }
            }
        }
        this.connection.messageProcessor.createAndSubmitTask(this, request);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOutgoingRequestImpl(RMIRequestImpl<?> request) {
        RMIChannelImpl rMIChannelImpl = this;
        synchronized (rMIChannelImpl) {
            switch (this.state) {
                case NEW: {
                    if (this.preOpenOutgoingRequests == null) {
                        this.preOpenOutgoingRequests = new ArrayList();
                    }
                    this.preOpenOutgoingRequests.add(request);
                    return;
                }
                case OPEN: {
                    this.connection.requestsManager.addOutgoingRequest(request);
                    return;
                }
                case CANCELLING: {
                    if (this.preOpenOutgoingRequests == null) {
                        this.connection.requestsManager.addOutgoingRequest(request);
                    } else {
                        this.preOpenOutgoingRequests.add(request);
                    }
                    return;
                }
            }
        }
        request.setFailedState(RMIExceptionType.CHANNEL_CLOSED, null);
    }

    private synchronized boolean dropPendingRequestImpl(RMIRequestImpl<?> request) {
        return this.preOpenOutgoingRequests != null && this.preOpenOutgoingRequests.remove(request);
    }

    Executor getExecutor() {
        return this.owner.getExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueForSubmissionSerially(RMIExecutionTaskImpl<?> executionTask) {
        boolean submitNow;
        RMIChannelImpl rMIChannelImpl = this;
        synchronized (rMIChannelImpl) {
            if (this.executionTasks == null) {
                this.executionTasks = new ArrayDeque(2);
            }
            submitNow = this.executionTasks.isEmpty();
            this.executionTasks.add(executionTask);
        }
        if (submitNow && !executionTask.submitExecutionNow()) {
            this.submitNextTask(executionTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void submitNextTask(RMIExecutionTaskImpl<?> executionTask) {
        do {
            assert (executionTask.submitNextNow());
            RMIChannelImpl rMIChannelImpl = this;
            synchronized (rMIChannelImpl) {
                if (this.executionTasks.peekFirst() != executionTask) {
                    return;
                }
                this.executionTasks.removeFirst();
                executionTask = this.executionTasks.peekFirst();
                if (executionTask == null) {
                    return;
                }
            }
        } while (!executionTask.submitExecutionNow());
    }

    private class ChannelRequestSender
    extends RequestSender {
        private ChannelRequestSender() {
        }

        @Override
        RMIEndpointImpl getEndpoint() {
            return RMIChannelImpl.this.getEndpoint();
        }

        @Override
        public Executor getExecutor() {
            return RMIChannelImpl.this.getExecutor();
        }

        @Override
        public void addOutgoingRequest(RMIRequestImpl<?> request) {
            RMIChannelImpl.this.addOutgoingRequestImpl(request);
        }

        @Override
        public boolean dropPendingRequest(RMIRequestImpl<?> request) {
            return RMIChannelImpl.this.dropPendingRequestImpl(request);
        }
    }
}

