/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.impl.RMILog;
import com.devexperts.rmi.impl.RMIRequestImpl;
import com.devexperts.rmi.impl.ServerRequestInfo;
import com.devexperts.rmi.task.BalanceResult;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.SynchronizedIndexedSet;
import com.dxfeed.promise.Promise;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class PendingRequests {
    private final IndexedSet<Long, PendingRequest> requests = SynchronizedIndexedSet.createLong(PendingRequest::getId);

    PendingRequests() {
    }

    void addPendingRequest(@Nonnull RMIRequestImpl<?> pendingRequest) {
        this.requests.add(PendingRequest.fromRMIRequest(pendingRequest));
    }

    void addBalancePromise(@Nonnull RMIRequestImpl<?> rmiRequest, @Nonnull Promise<BalanceResult> balancePromise, @Nonnull BiConsumer<RMIRequestImpl<?>, Promise<BalanceResult>> promiseCompletionAction) {
        this.requests.add(PendingRequest.fromBalancePromise(rmiRequest, balancePromise));
        long reqId = rmiRequest.getId();
        balancePromise.whenDone(result -> {
            PendingRequest pendingRequest = this.requests.removeKey(reqId);
            if (pendingRequest == null) {
                return;
            }
            RMILog.logBalancingCompletion(pendingRequest.rmiRequest, balancePromise);
            promiseCompletionAction.accept(pendingRequest.rmiRequest, balancePromise);
        });
    }

    void addBalancePromise(@Nonnull ServerRequestInfo requestInfo, @Nonnull Promise<BalanceResult> balancePromise, @Nonnull BiConsumer<ServerRequestInfo, Promise<BalanceResult>> promiseCompletionAction) {
        this.requests.add(PendingRequest.fromBalancePromise(requestInfo, balancePromise));
        long reqId = requestInfo.reqId;
        balancePromise.whenDone(result -> {
            PendingRequest pendingRequest = this.requests.removeKey(reqId);
            if (pendingRequest == null) {
                return;
            }
            RMILog.logBalancingCompletion(requestInfo, balancePromise);
            promiseCompletionAction.accept(pendingRequest.serverRequestInfo, balancePromise);
        });
    }

    boolean dropPendingRequest(long requestId) {
        PendingRequest pendingRequest = this.requests.removeKey(requestId);
        if (pendingRequest != null && pendingRequest.balancePromise != null) {
            pendingRequest.balancePromise.cancel();
        }
        return pendingRequest != null;
    }

    int size() {
        return this.requests.size();
    }

    void forEachRMIRequest(@Nonnull Consumer<RMIRequestImpl<?>> consumer) {
        Iterator<PendingRequest> it = this.requests.concurrentIterator();
        while (it.hasNext()) {
            PendingRequest pendingRequest = it.next();
            if (pendingRequest.rmiRequest == null) continue;
            consumer.accept(pendingRequest.rmiRequest);
        }
    }

    private void forEachBalancePromise(@Nonnull Consumer<Promise<BalanceResult>> consumer) {
        Iterator<PendingRequest> it = this.requests.concurrentIterator();
        while (it.hasNext()) {
            PendingRequest pendingRequest = it.next();
            if (pendingRequest.balancePromise == null) continue;
            consumer.accept(pendingRequest.balancePromise);
        }
    }

    List<RMIRequestImpl<?>> removeAllBalanced() {
        ArrayList result = new ArrayList();
        Iterator<PendingRequest> it = this.requests.concurrentIterator();
        while (it.hasNext()) {
            PendingRequest pendingRequest = it.next();
            if (pendingRequest.balancePromise != null) continue;
            it.remove();
            result.add(pendingRequest.rmiRequest);
        }
        return result;
    }

    void clear() {
        this.forEachBalancePromise(Promise::cancel);
        this.requests.clear();
    }

    private static class PendingRequest {
        final Promise<BalanceResult> balancePromise;
        final RMIRequestImpl<?> rmiRequest;
        final ServerRequestInfo serverRequestInfo;

        PendingRequest(Promise<BalanceResult> balancePromise, RMIRequestImpl<?> rmiRequest, ServerRequestInfo serverRequestInfo) {
            assert (rmiRequest != null || serverRequestInfo != null);
            this.balancePromise = balancePromise;
            this.rmiRequest = rmiRequest;
            this.serverRequestInfo = serverRequestInfo;
        }

        static PendingRequest fromBalancePromise(RMIRequestImpl<?> request, Promise<BalanceResult> balancePromise) {
            return new PendingRequest(balancePromise, request, null);
        }

        static PendingRequest fromBalancePromise(ServerRequestInfo request, Promise<BalanceResult> balancePromise) {
            return new PendingRequest(balancePromise, null, request);
        }

        static PendingRequest fromRMIRequest(RMIRequestImpl<?> request) {
            return new PendingRequest(null, request, null);
        }

        long getId() {
            return this.rmiRequest != null ? this.rmiRequest.getId() : this.serverRequestInfo.reqId;
        }
    }
}

