/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.impl.RMIRequestImpl;
import com.devexperts.rmi.impl.ServiceFilter;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class OutgoingRequests {
    private final ServiceFilter filter;
    private final PriorityQueue<RMIRequestImpl<?>> outgoingRequests = new PriorityQueue(11, RMIRequestImpl.REQUEST_COMPARATOR_BY_SENDING_TIME);

    OutgoingRequests(ServiceFilter filter) {
        this.filter = filter;
    }

    synchronized void add(RMIRequestImpl<?> request) {
        if (!request.isWaitingToSend()) {
            return;
        }
        this.outgoingRequests.add(request);
    }

    synchronized List<RMIRequestImpl<?>> getByDescriptorsAndRemove(List<RMIServiceDescriptor> descriptors) {
        if (descriptors == null) {
            ArrayList result = new ArrayList(this.outgoingRequests);
            this.outgoingRequests.clear();
            return result;
        }
        ArrayList result = new ArrayList();
        Iterator<RMIRequestImpl<?>> it = this.outgoingRequests.iterator();
        while (it.hasNext()) {
            RMIRequestImpl<?> request = it.next();
            boolean needRemove = false;
            for (RMIServiceDescriptor descriptor : descriptors) {
                if (!this.filter.accept(descriptor.getServiceName()) || !request.getOperation().getServiceName().equals(descriptor.getServiceName())) continue;
                needRemove = true;
                result.add(request);
            }
            if (!needRemove) continue;
            it.remove();
        }
        return result;
    }

    synchronized RMIRequestImpl<?> poll() {
        return this.outgoingRequests.poll();
    }

    synchronized boolean remove(RMIRequestImpl<?> request) {
        return this.outgoingRequests.remove(request);
    }

    synchronized int size() {
        return this.outgoingRequests.size();
    }

    synchronized RMIRequestImpl<?>[] getRequests(RMIRequestImpl<?>[] requests) {
        return this.outgoingRequests.toArray(requests);
    }
}

