/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.connector.proto.EndpointId;
import com.devexperts.connector.proto.JVMId;
import com.devexperts.io.BufferedInput;
import com.devexperts.io.Marshalled;
import com.devexperts.io.Marshaller;
import com.devexperts.logging.Logging;
import com.devexperts.rmi.RMIException;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.impl.PendingRequests;
import com.devexperts.rmi.impl.RMIChannelImpl;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIExecutionTaskImpl;
import com.devexperts.rmi.impl.RMIFailedException;
import com.devexperts.rmi.impl.RMILog;
import com.devexperts.rmi.impl.RMIMessageKind;
import com.devexperts.rmi.impl.RMIRequestImpl;
import com.devexperts.rmi.impl.RMITaskImpl;
import com.devexperts.rmi.impl.RMITaskResponse;
import com.devexperts.rmi.impl.ServerRequestInfo;
import com.devexperts.rmi.message.RMICancelType;
import com.devexperts.rmi.message.RMIErrorMessage;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.message.RMIResponseMessage;
import com.devexperts.rmi.message.RMIRoute;
import com.devexperts.rmi.task.BalanceResult;
import com.devexperts.rmi.task.RMIChannelType;
import com.devexperts.rmi.task.RMIService;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.util.LongHashMap;
import com.devexperts.util.SystemProperties;
import com.dxfeed.promise.Promise;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.Executor;

class MessageProcessor {
    private static final Logging log = Logging.getLogging(MessageProcessor.class);
    private static final int MAX_LENGTH_RMI_ROUTE = SystemProperties.getIntProperty("com.devexperts.rmi.maxLengthRMIRoute", 10);
    private final RMIConnection connection;
    private final Subjects subjects = new Subjects();
    private final Operations operations = new Operations();
    private volatile boolean closed = false;
    private final PendingRequests pendingRequests = new PendingRequests();

    MessageProcessor(RMIConnection connection) {
        this.connection = connection;
    }

    void processComboRequestMessage(BufferedInput data) throws IOException {
        long requestId = data.readCompactLong();
        RMIMessageKind kind = RMIMessageKind.readFromRequest(data);
        long channelId = kind.hasChannel() ? data.readCompactLong() : 0L;
        RMIRequestType requestType = RMIRequestType.readFromRequest(data);
        try {
            JVMId.ReadContext ctx = new JVMId.ReadContext();
            RMIRoute route = this.parseRoute(data, ctx);
            RMIServiceId target = RMIServiceId.readRMIServiceId(data, ctx);
            int subjectId = data.readCompactInt();
            int operationId = data.readCompactInt();
            Marshalled<Object[]> parametersRequest = null;
            RMIOperation<?> operation = this.operations.getOperation(operationId);
            if (operation != null) {
                parametersRequest = data.readMarshalled(operation.getParametersMarshaller(), this.connection.endpoint.getSerialClassContext());
            }
            this.makeTask(channelId, requestId, subjectId, operationId, kind, parametersRequest, requestType, route, target);
        }
        catch (IOException e) {
            this.signalFailure(RMIExceptionType.FAILED_TO_READ_REQUEST, "Failed read request", kind, requestType, channelId, requestId);
        }
    }

    void processComboResponseMessage(BufferedInput data) throws IOException {
        long requestId = data.readCompactLong();
        RMIMessageKind kind = RMIMessageKind.readFromResponse(data);
        long channelId = kind.hasChannel() ? data.readCompactLong() : 0L;
        RMIRequestImpl<RMIException> request = this.retrieveRequest(channelId, requestId, kind);
        if (request == null) {
            return;
        }
        RMIRoute route = this.parseRoute(data, new JVMId.ReadContext());
        Marshaller<RMIException> marshaller = kind.isError() ? RMIResponseMessage.getExceptionMarshaller() : request.getOperation().getResultMarshaller();
        Marshalled<RMIException> resultMarshalled = data.readMarshalled(marshaller, this.connection.endpoint.getSerialClassContext());
        if (kind.isError()) {
            request.setFailedState(resultMarshalled, route);
        } else {
            request.setSucceededState(resultMarshalled, route);
        }
    }

    void processDescribeSubjectMessage(BufferedInput data) throws IOException {
        int subjectId = data.readCompactInt();
        Marshalled<Object> subject = data.readMarshalled(Marshaller.SERIALIZATION, this.connection.endpoint.getSerialClassContext());
        this.subjects.putSubject(subjectId, subject);
    }

    void processDescribeOperationMessage(BufferedInput data) throws IOException {
        int operationId = data.readCompactInt();
        String signature = data.readUTFString();
        this.operations.putOperation(operationId, RMIOperation.valueOf(signature));
    }

    void processAdvertiseServicesMessage(BufferedInput data) throws IOException {
        JVMId.ReadContext ctx = new JVMId.ReadContext();
        ArrayList<RMIServiceDescriptor> descriptors = new ArrayList<RMIServiceDescriptor>();
        while (data.hasAvailable()) {
            RMIServiceId serviceId = RMIServiceId.readRMIServiceId(data, ctx);
            int distance = data.readCompactInt();
            int nIntermediateNodes = data.readCompactInt();
            HashSet<EndpointId> intermediateNodes = new HashSet<EndpointId>(nIntermediateNodes + 1);
            for (int j = 0; j < nIntermediateNodes; ++j) {
                intermediateNodes.add(EndpointId.readEndpointId(data, ctx));
            }
            intermediateNodes.add(this.connection.endpoint.getEndpointId());
            int nProps = data.readCompactInt();
            HashMap<String, String> props = new HashMap<String, String>();
            for (int j = 0; j < nProps; ++j) {
                props.put(data.readUTFString(), data.readUTFString());
            }
            if (!this.connection.configuredServices.accept(serviceId.getName())) continue;
            RMIServiceDescriptor descriptor = distance == Integer.MAX_VALUE ? RMIServiceDescriptor.createUnavailableDescriptor(serviceId, props) : RMIServiceDescriptor.createDescriptor(serviceId, distance + this.connection.weight, intermediateNodes, props);
            descriptors.add(descriptor);
        }
        if (RMIEndpointImpl.RMI_TRACE_LOG) {
            log.trace("Process advertise services " + descriptors + " at " + this.connection);
        }
        this.connection.endpoint.getClient().updateServiceDescriptors(descriptors, this.connection);
    }

    private RMIRoute parseRoute(BufferedInput data, JVMId.ReadContext ctx) throws IOException {
        int size = data.readCompactInt();
        if (size < 0) {
            throw new IOException("The size of the route request can not be negative");
        }
        EndpointId[] result = new EndpointId[size + 1];
        for (int i = 0; i < size; ++i) {
            result[i] = EndpointId.readEndpointId(data, ctx);
        }
        result[size] = this.connection.getRemoteEndpointId();
        return RMIRoute.createRMIRoute(result);
    }

    void processOldRequestMessage(BufferedInput data) throws IOException {
        long requestId = data.readCompactLong();
        int channelId = 0;
        int reqTypeId = data.readCompactInt();
        RMIRequestType requestType = RMIRequestType.getById(reqTypeId & 0xF);
        if (requestType == null) {
            throw new IOException("Failed to read request type");
        }
        try {
            JVMId.ReadContext ctx = new JVMId.ReadContext();
            RMIRoute route = (reqTypeId & 0x20) != 0 ? this.parseRoute(data, ctx) : RMIRoute.createRMIRoute(this.connection.getRemoteEndpointId());
            RMIServiceId target = (reqTypeId & 0x10) != 0 ? RMIServiceId.readRMIServiceId(data, ctx) : null;
            int subjectId = data.readCompactInt();
            int operationId = data.readCompactInt();
            Marshalled<Object[]> parametersRequest = null;
            RMIOperation<?> operation = this.operations.getOperation(operationId);
            if (operation != null) {
                parametersRequest = data.readMarshalled(operation.getParametersMarshaller(), this.connection.endpoint.getSerialClassContext());
            }
            this.makeTask(channelId, requestId, subjectId, operationId, RMIMessageKind.REQUEST, parametersRequest, requestType, route, target);
        }
        catch (IOException e) {
            this.signalFailure(RMIExceptionType.FAILED_TO_READ_REQUEST, "Failed to read a request", RMIMessageKind.REQUEST, requestType, channelId, requestId);
        }
    }

    void processOldResultMessage(BufferedInput data) throws IOException {
        int channelId = 0;
        long requestId = data.readCompactLong();
        RMIRequestImpl<?> request = this.retrieveRequest(channelId, requestId, null);
        if (request == null) {
            return;
        }
        Marshalled<?> resultMarshalled = data.readMarshalled(request.getOperation().getResultMarshaller(), this.connection.endpoint.getSerialClassContext());
        RMIRoute route = null;
        if (data.hasAvailable()) {
            route = this.parseRoute(data, new JVMId.ReadContext());
        }
        if (route == null) {
            route = RMIRoute.createRMIRoute(this.connection.getRemoteEndpointId());
        }
        request.setSucceededState(resultMarshalled, route);
    }

    void processOldErrorMessage(BufferedInput data) throws IOException {
        int channelId = 0;
        long requestId = data.readCompactLong();
        RMIRequestImpl<?> request = this.retrieveRequest(channelId, requestId, null);
        if (request == null) {
            return;
        }
        Marshalled<RMIException> marshalledException = data.readMarshalled(RMIResponseMessage.getExceptionMarshaller(), this.connection.endpoint.getSerialClassContext());
        RMIRoute route = null;
        if (data.hasAvailable()) {
            route = this.parseRoute(data, new JVMId.ReadContext());
        }
        if (route == null) {
            route = RMIRoute.createRMIRoute(this.connection.getRemoteEndpointId());
        }
        request.setFailedState(marshalledException, route);
    }

    void processOldCancelMessage(BufferedInput data) throws IOException {
        long requestId = data.readCompactLong();
        int cancellationFlags = data.readCompactInt();
        this.connection.tasksManager.cancelTask(requestId, 0L, cancellationFlags, null);
    }

    void createAndSubmitTask(RMIChannelImpl channel, ServerRequestInfo requestInfo) {
        Executor executor;
        RMITaskImpl<?> task;
        RMIService<?> service;
        boolean nestedTask;
        boolean bl = nestedTask = requestInfo.channelId != 0L;
        if (nestedTask) {
            assert (channel != null);
            service = channel.getHandler(requestInfo.message.getOperation().getServiceName());
        } else {
            assert (channel == null);
            service = this.connection.endpoint.getServer().getProvidedService(requestInfo.message.getTarget());
        }
        if (service == null) {
            if (requestInfo.retargetedByLoadBalancer) {
                this.signalServiceUnavailable(requestInfo, "Load balancer selected an unreachable service " + requestInfo.message.getTarget());
            } else {
                this.signalFailure(RMIExceptionType.UNKNOWN_SERVICE, "\"" + requestInfo.message.getOperation().getServiceName() + "\"", requestInfo.kind, requestInfo.message.getRequestType(), requestInfo.channelId, requestInfo.reqId);
            }
            return;
        }
        RMITaskImpl<?> rMITaskImpl = task = nestedTask ? RMITaskImpl.createNestedTask(requestInfo.message, this.connection, channel, requestInfo.reqId) : RMITaskImpl.createTopLevelTask(requestInfo.subject, requestInfo.message, this.connection, requestInfo.reqId);
        if (RMIEndpointImpl.RMI_TRACE_LOG) {
            log.trace("Create task " + task + " at " + this.connection);
        }
        if (requestInfo.message.getRequestType() != RMIRequestType.ONE_WAY) {
            this.connection.tasksManager.registerTask(task);
        }
        if ((executor = service.getExecutor()) == null) {
            executor = nestedTask ? channel.getExecutor() : this.connection.endpoint.getServer().getDefaultExecutor();
        }
        task.setExecutor(executor);
        RMIExecutionTaskImpl executionTask = new RMIExecutionTaskImpl(requestInfo.reqId, this.connection, task, service, executor);
        executionTask.enqueueForSubmissionSerially();
    }

    private RMIRequestImpl<?> retrieveRequest(long channelId, long requestId, RMIMessageKind kind) {
        RMIRequestImpl<?> request = this.connection.requestsManager.removeSentRequest(channelId, requestId, kind);
        if (request == null) {
            log.error("No request with request ID#" + requestId + (channelId != 0L ? " (channel ID#" + channelId + ")" : "") + " was pending for execution");
        }
        return request;
    }

    private void makeTask(long channelId, long curReqId, int subjectId, int operationId, RMIMessageKind kind, Marshalled<Object[]> parametersRequest, RMIRequestType requestType, RMIRoute route, RMIServiceId target) {
        EndpointId lastNode;
        boolean nestedTask;
        Marshalled<Object> marshalledSubject = this.subjects.getSubject(subjectId);
        if (marshalledSubject == null) {
            this.signalFailure(RMIExceptionType.UNKNOWN_SUBJECT, "#" + subjectId, kind, requestType, channelId, curReqId);
            return;
        }
        RMIOperation<?> operation = this.operations.getOperation(operationId);
        if (operation == null) {
            this.signalFailure(RMIExceptionType.UNKNOWN_OPERATION, "#" + operationId, kind, requestType, channelId, curReqId);
            return;
        }
        boolean bl = nestedTask = channelId != 0L;
        if (!nestedTask && !this.connection.configuredServices.accept(operation.getServiceName())) {
            this.signalFailure(RMIExceptionType.UNKNOWN_SERVICE, "\"" + operation.getServiceName() + "\"", kind, requestType, channelId, curReqId);
            return;
        }
        if (!(route.isEmpty() || route.indexOf(lastNode = route.getLast()) == route.size() - 1 && route.size() < MAX_LENGTH_RMI_ROUTE)) {
            this.signalFailure(RMIExceptionType.ROUTE_IS_NOT_FOUND, "Request for \"" + operation.getServiceName() + "\" got into routing loop: Route = " + route, kind, requestType, channelId, curReqId);
            return;
        }
        if (this.processCancel(channelId, parametersRequest, operation, kind)) {
            return;
        }
        RMIRequestMessage requestMessage = new RMIRequestMessage(requestType, operation, parametersRequest, route, target);
        ServerRequestInfo requestInfo = new ServerRequestInfo(kind, curReqId, channelId, requestMessage, marshalledSubject);
        if (target == null && !nestedTask) {
            Promise<BalanceResult> balanceResult = this.connection.endpoint.getServer().balance(requestMessage);
            if (balanceResult.isDone()) {
                RMILog.logBalancingCompletion(requestInfo, balanceResult);
                this.balancingCompleted(requestInfo, balanceResult);
                return;
            }
            this.pendingRequests.addBalancePromise(requestInfo, balanceResult, this::balancingCompleted);
        } else {
            this.createAndSubmitTask(requestInfo);
        }
    }

    private void balancingCompleted(ServerRequestInfo requestInfo, Promise<BalanceResult> balanceResult) {
        if (balanceResult.isCancelled()) {
            if (!this.closed) {
                this.signalFailure(RMIExceptionType.CANCELLED_BEFORE_EXECUTION, null, requestInfo.kind, requestInfo.message.getRequestType(), requestInfo.channelId, requestInfo.reqId);
            }
            return;
        }
        if (balanceResult.hasException() || balanceResult.getResult().isReject()) {
            String rejectReason = balanceResult.hasException() ? balanceResult.getException().getMessage() : balanceResult.getResult().getRejectReason();
            this.signalServiceUnavailable(requestInfo, rejectReason);
            return;
        }
        RMIServiceId target = balanceResult.getResult().getTarget();
        requestInfo = requestInfo.changeTargetRoute(target);
        this.createAndSubmitTask(requestInfo);
    }

    private void signalServiceUnavailable(ServerRequestInfo requestInfo, String rejectReason) {
        this.signalFailure(RMIExceptionType.SERVICE_UNAVAILABLE, rejectReason, requestInfo.kind, requestInfo.message.getRequestType(), requestInfo.channelId, requestInfo.reqId);
    }

    private void createAndSubmitTask(ServerRequestInfo requestInfo) {
        boolean nestedTask;
        boolean bl = nestedTask = requestInfo.channelId != 0L;
        if (nestedTask) {
            boolean ok;
            RMIChannelImpl channel = this.connection.channelsManager.getChannel(requestInfo.channelId, requestInfo.kind.hasClient() ? RMIChannelType.CLIENT_CHANNEL : RMIChannelType.SERVER_CHANNEL);
            boolean bl2 = ok = channel != null && channel.addIncomingRequest(requestInfo);
            if (!ok) {
                RMILog.logFailedTask(RMIExceptionType.CHANNEL_CLOSED, ". The channel number " + requestInfo.channelId + " has already been closed or never existed", this.connection, requestInfo.reqId, requestInfo.channelId, requestInfo.message.getRequestType());
            }
        } else {
            this.createAndSubmitTask(null, requestInfo);
        }
    }

    private boolean processCancel(long channelId, Marshalled<Object[]> parametersRequest, RMIOperation<?> operation, RMIMessageKind kind) {
        if (!RMIRequestImpl.isCancelOperation(operation)) {
            return false;
        }
        Object[] params = parametersRequest.getObject();
        RMIChannelType channelType = kind.hasClient() ? RMIChannelType.CLIENT_CHANNEL : RMIChannelType.SERVER_CHANNEL;
        long requestId = (Long)params[0];
        if (requestId == 0L) {
            this.pendingRequests.dropPendingRequest(channelId);
            RMIChannelImpl channel = this.connection.channelsManager.getChannel(channelId, channelType);
            if (channel != null) {
                channel.cancel(RMICancelType.valueOf(operation.getMethodName()));
            }
        } else if (!this.pendingRequests.dropPendingRequest(requestId)) {
            this.connection.tasksManager.cancelTask(requestId, channelId, RMICancelType.valueOf(operation.getMethodName()).getId(), channelType);
        }
        return true;
    }

    private void signalFailure(RMIExceptionType exceptionType, String info, RMIMessageKind kind, RMIRequestType requestType, long channelId, long requestId) {
        RMILog.logFailedTask(exceptionType, info, this.connection, requestId, channelId, requestType);
        this.connection.tasksManager.notifyTaskCompleted(requestType, new RMITaskResponse(new RMIErrorMessage(exceptionType, new RMIFailedException(info), null), channelId, requestId, kind.hasClient() ? RMIChannelType.CLIENT_CHANNEL : RMIChannelType.SERVER_CHANNEL));
    }

    void close() {
        this.closed = true;
        this.pendingRequests.clear();
    }

    private static class Operations {
        private final LongHashMap<RMIOperation<?>> map = new LongHashMap();

        private Operations() {
        }

        RMIOperation<?> getOperation(int operationId) {
            return this.map.get(operationId);
        }

        void putOperation(int id, RMIOperation<?> operation) {
            this.map.put(id, operation);
        }
    }

    private class Subjects {
        private LongHashMap<Marshalled<Object>> map;
        private Marshalled<Object> defaultSubject;

        private Subjects() {
        }

        Marshalled<Object> getSubject(int subjectId) {
            if (subjectId == 0) {
                if (this.defaultSubject == null) {
                    Object connectionSubject = MessageProcessor.this.connection.getSubject();
                    this.defaultSubject = connectionSubject != null ? Marshalled.forObject(connectionSubject) : Marshalled.NULL;
                }
                return this.defaultSubject;
            }
            return this.map == null ? null : this.map.get(subjectId);
        }

        void putSubject(int id, Marshalled<Object> subject) {
            if (this.map == null) {
                this.map = new LongHashMap();
            }
            this.map.put(id, subject);
        }
    }
}

