/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.connector.proto.EndpointId;
import com.devexperts.connector.proto.JVMId;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.Chunk;
import com.devexperts.io.Marshalled;
import com.devexperts.logging.Logging;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.qd.qtp.MessageVisitor;
import com.devexperts.rmi.RMIEndpoint;
import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequestState;
import com.devexperts.rmi.impl.ComposedMessage;
import com.devexperts.rmi.impl.ComposedMessageQueue;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIMessageKind;
import com.devexperts.rmi.impl.RMIQueueType;
import com.devexperts.rmi.impl.RMIRequestImpl;
import com.devexperts.rmi.impl.RMITaskResponse;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIRequestType;
import com.devexperts.rmi.message.RMIResponseMessage;
import com.devexperts.rmi.message.RMIResponseType;
import com.devexperts.rmi.message.RMIRoute;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.rmi.task.RMITaskState;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.SystemProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

class MessageComposer {
    private static final Logging log = Logging.getLogging(MessageComposer.class);
    private static final int MAX_CONCURRENT_RMI_MESSAGES = SystemProperties.getIntProperty("com.devexperts.rmi.maxConcurrentRMIMessages", 6);
    private static final int DESCRIBE_AHEAD_LIMIT = SystemProperties.getIntProperty("com.devexperts.rmi.describeAheadLimit", 2);
    private final RMIConnection connection;
    @GuardedBy(value="this")
    private final ByteArrayOutput aux = new ByteArrayOutput(20);
    @GuardedBy(value="this")
    private final Subjects subjects = new Subjects();
    @GuardedBy(value="this")
    private final Operations operations = new Operations();
    @GuardedBy(value="this")
    private final Queues queues;
    @GuardedBy(value="this")
    private int sequence = 1;
    private volatile boolean canEnqueueRequest;
    private volatile boolean supportsComboResponse;
    private volatile boolean supportsMessagePart;
    private volatile boolean supportTargetRouteProtocol;

    MessageComposer(RMIConnection connection) {
        this.connection = connection;
        this.queues = new Queues(connection.side);
    }

    void setRemoteReceiveSet(EnumSet<MessageType> remoteReceiveSet) {
        this.canEnqueueRequest = remoteReceiveSet.contains((Object)MessageType.RMI_DESCRIBE_OPERATION) && remoteReceiveSet.contains((Object)MessageType.RMI_DESCRIBE_SUBJECT) && remoteReceiveSet.contains((Object)MessageType.RMI_REQUEST);
        this.supportsMessagePart = remoteReceiveSet.contains((Object)MessageType.PART);
        this.supportsComboResponse = remoteReceiveSet.contains((Object)MessageType.RMI_RESPONSE);
    }

    void setSupportTargetRouteProtocol(boolean supportTargetRouteProtocol) {
        this.supportTargetRouteProtocol = supportTargetRouteProtocol;
    }

    synchronized void close() {
        ComposedMessage message;
        while ((message = this.queues.get(RMIQueueType.REQUEST).remove()) != null) {
            if (message.kind().isRequest()) {
                ((RMIRequestImpl)message.getObject()).setFailedState(RMIExceptionType.DISCONNECTION, null);
            }
            ComposedMessage.releaseComposedMessage(message);
        }
    }

    synchronized boolean retrieveRMIMessages(MessageVisitor visitor, RMIQueueType type) {
        MessageQueueState queueState;
        boolean hasCapacity;
        if (type == RMIQueueType.ADVERTISE && !this.connection.side.hasServer()) {
            throw new AssertionError();
        }
        ComposedMessageQueue queue = this.queues.get(type);
        boolean bl = hasCapacity = queue.size() == 0 || this.supportsMessagePart && queue.size() < MAX_CONCURRENT_RMI_MESSAGES;
        if (hasCapacity && this.hasMoreMessages(type)) {
            this.enqueueMessage(type);
        }
        return (queueState = this.retrieveMessageImpl(visitor, queue)).hasMoreWork() || this.hasMoreMessages(type);
    }

    private MessageQueueState retrieveMessageImpl(MessageVisitor visitor, ComposedMessageQueue queue) {
        ComposedMessage message;
        do {
            MessageQueueState state;
            if ((message = queue.remove()) == null) {
                return MessageQueueState.NO_MORE_MESSAGES;
            }
            if (!message.kind().isRequest()) continue;
            for (int i = 0; i < DESCRIBE_AHEAD_LIMIT && (state = this.retrieveMessageImpl(visitor, this.queues.get(RMIQueueType.DESCRIBE))) != MessageQueueState.NO_MORE_MESSAGES; ++i) {
                if (state != MessageQueueState.VISITOR_FULL) continue;
                return state;
            }
        } while (!this.canSendMessage(message, queue));
        if (this.sendRetrievedMessage(visitor, message, queue)) {
            return MessageQueueState.VISITOR_FULL;
        }
        if (message.isEmpty()) {
            this.messageSentCompletely(message);
        } else {
            queue.addLast(message);
        }
        return MessageQueueState.NOT_ALL_SENT;
    }

    private void completeMessageImpl(ComposedMessageQueue queue, ComposedMessage message) {
        message.flushOutputChunks();
        if (message.chunksCount() > 1) {
            if (this.supportsMessagePart) {
                message.completeMessageParts(this.sequence++, this.aux);
            } else {
                message.completeMonolithicMessage();
            }
        }
        queue.addLast(message);
    }

    private boolean sendRetrievedMessage(MessageVisitor visitor, ComposedMessage message, ComposedMessageQueue queue) {
        Chunk chunk = message.firstChunk();
        if (visitor.visitOtherMessage(message.type(), chunk.getBytes(), chunk.getOffset(), chunk.getLength())) {
            queue.addFirst(message);
            return true;
        }
        message.chunkTransmitted();
        return false;
    }

    private boolean canSendMessage(ComposedMessage message, ComposedMessageQueue queue) {
        RMIMessageKind type = message.kind();
        if (!type.isRequest()) {
            return true;
        }
        RMIRequestImpl request = (RMIRequestImpl)message.getObject();
        if (!message.startedTransmission() && request.getRequestMessage().getRequestType() == RMIRequestType.DEFAULT) {
            if (!request.isNestedRequest() && System.currentTimeMillis() - request.getSendTime() > this.connection.endpoint.getClient().getRequestSendingTimeout()) {
                request.setFailedState(RMIExceptionType.REQUEST_SENDING_TIMEOUT, null);
            }
            if (request.getState() != RMIRequestState.SENDING && this.abortRequest(message)) {
                return false;
            }
        }
        if ((request.getState() == RMIRequestState.CANCELLING || request.getState() == RMIRequestState.FAILED) && this.abortRequest(message)) {
            return false;
        }
        if (message.startedTransmission()) {
            return true;
        }
        if (this.subjects.hasOutgoingSubject(request.getMarshalledSubject()) || this.operations.hasOutgoingOperation(request.getOperation())) {
            queue.addLast(message);
            return false;
        }
        return true;
    }

    private void messageSentCompletely(ComposedMessage message) {
        if (message.kind() != null) {
            switch (message.kind()) {
                case DESCRIBE_SUBJECT: {
                    this.subjects.removeOutgoingSubject((Marshalled)message.getObject());
                    break;
                }
                case DESCRIBE_OPERATION: {
                    this.operations.removeOutgoingOperation((RMIOperation)message.getObject());
                }
            }
        }
        if (message.kind().isRequest()) {
            ((RMIRequestImpl)message.getObject()).setSentState(this.connection);
        }
        ComposedMessage.releaseComposedMessage(message);
    }

    private boolean abortRequest(ComposedMessage message) {
        ((RMIRequestImpl)message.getObject()).setFailedState(RMIExceptionType.CANCELLED_BEFORE_EXECUTION, null);
        if (!message.startedTransmission()) {
            ComposedMessage.releaseComposedMessage(message);
            return true;
        }
        message.abortRemainingMessageParts();
        return false;
    }

    private void completeMessage(ComposedMessage message) {
        this.completeMessageImpl(this.queues.get(RMIQueueType.DESCRIBE), message);
    }

    private void composeComboRequest(RMIRequestImpl<?> request, int subjectId, int operationId) {
        try {
            RMIRequestMessage<?> requestMessage = request.getRequestMessage();
            JVMId.WriteContext ctx = new JVMId.WriteContext();
            ComposedMessage message = ComposedMessage.allocateComposedMessage(MessageType.RMI_REQUEST, request.getKind(), request);
            message.output().writeCompactLong(request.getId());
            message.output().writeCompactInt(message.kind().getId());
            if (message.kind().hasChannel()) {
                message.output().writeCompactLong(request.getChannelId());
            }
            message.output().writeCompactInt(requestMessage.getRequestType().getId());
            MessageComposer.composeRoute(message, requestMessage.getRoute(), ctx);
            RMIServiceId.writeRMIServiceId(message.output(), request.getTentativeTarget(), ctx);
            message.output().writeCompactInt(subjectId);
            message.output().writeCompactInt(operationId);
            message.output().writeMarshalled(requestMessage.getParameters());
            this.completeMessageImpl(this.queues.get(RMIQueueType.REQUEST), message);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
    }

    private void composeComboResponse(RMIResponseMessage responseMessage, long channelId, long requestId, RMIMessageKind kind) {
        try {
            ComposedMessage message = ComposedMessage.allocateComposedMessage(MessageType.RMI_RESPONSE, kind, responseMessage);
            message.output().writeCompactLong(requestId);
            message.output().writeCompactInt(kind.getId());
            if (kind.hasChannel()) {
                message.output().writeCompactLong(channelId);
            }
            MessageComposer.composeRoute(message, responseMessage.getRoute(), new JVMId.WriteContext());
            message.output().writeMarshalled(responseMessage.getMarshalledResult());
            this.completeMessageImpl(this.queues.get(RMIQueueType.RESPONSE), message);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
    }

    private void composeAdvertiseServicesMessage(List<RMIServiceDescriptor> descriptors) {
        try {
            if (descriptors.isEmpty()) {
                return;
            }
            if (RMIEndpointImpl.RMI_TRACE_LOG) {
                log.trace("Compose advertise services " + descriptors + " at " + this.connection);
            }
            ComposedMessage message = ComposedMessage.allocateComposedMessage(MessageType.RMI_ADVERTISE_SERVICES, RMIMessageKind.ADVERTISE, descriptors);
            JVMId.WriteContext ctx = new JVMId.WriteContext();
            for (RMIServiceDescriptor serviceDescriptor : descriptors) {
                RMIServiceId.writeRMIServiceId(message.output(), serviceDescriptor.getServiceId(), ctx);
                message.output().writeCompactInt(serviceDescriptor.getDistance());
                message.output().writeCompactInt(serviceDescriptor.getIntermediateNodes().size());
                for (EndpointId endpointId : serviceDescriptor.getIntermediateNodes()) {
                    EndpointId.writeEndpointId(message.output(), endpointId, ctx);
                }
                message.output().writeCompactInt(serviceDescriptor.getProperties().size());
                for (Map.Entry entry : serviceDescriptor.getProperties().entrySet()) {
                    message.output().writeUTFString((String)entry.getKey());
                    message.output().writeUTFString((String)entry.getValue());
                }
            }
            this.completeMessageImpl(this.queues.get(RMIQueueType.ADVERTISE), message);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
    }

    private static void composeRoute(ComposedMessage message, RMIRoute route, JVMId.WriteContext ctx) throws IOException {
        int size = message.kind().isRequest() ? route.size() - 1 : route.size();
        message.output().writeCompactInt(size);
        for (int i = 0; i < size; ++i) {
            EndpointId.writeEndpointId(message.output(), route.get(i), ctx);
        }
    }

    private void composeOldRequest(RMIRequestImpl<?> request, int subjectId, int operationId) {
        try {
            ComposedMessage message = ComposedMessage.allocateComposedMessage(MessageType.RMI_REQUEST, RMIMessageKind.REQUEST, request);
            message.output().writeCompactLong(request.getId());
            int typeId = request.getRequestMessage().getRequestType().getId();
            RMIRoute route = request.getRequestMessage().getRoute();
            JVMId.WriteContext ctx = new JVMId.WriteContext();
            if (this.supportTargetRouteProtocol) {
                if (route.isNotEmptyWithLast(this.connection.endpoint.getEndpointId())) {
                    typeId |= 0x20;
                }
                if (request.getTentativeTarget() != null) {
                    typeId |= 0x10;
                }
            }
            message.output().writeCompactInt(typeId);
            if ((typeId & 0x20) != 0) {
                MessageComposer.composeRoute(message, request.getRequestMessage().getRoute(), ctx);
            }
            if ((typeId & 0x10) != 0) {
                RMIServiceId.writeRMIServiceId(message.output(), request.getTentativeTarget(), ctx);
            }
            message.output().writeCompactInt(subjectId);
            message.output().writeCompactInt(operationId);
            message.output().writeMarshalled(request.getRequestMessage().getParameters());
            this.completeMessageImpl(this.queues.get(RMIQueueType.REQUEST), message);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
    }

    private void composeOldCancel(RMIRequestImpl<?> cancel) {
        try {
            ComposedMessage message = ComposedMessage.allocateComposedMessage(MessageType.RMI_CANCEL, null, null);
            message.output().writeCompactLong((Long)cancel.getParameters()[0]);
            message.output().writeCompactInt((Integer)cancel.getParameters()[1]);
            this.completeMessageImpl(this.queues.get(RMIQueueType.REQUEST), message);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
    }

    private void composeOldResponse(RMITaskResponse taskResponse, MessageType messageType) {
        try {
            RMIMessageKind kind = taskResponse.state == RMITaskState.SUCCEEDED ? RMIMessageKind.SUCCESS_RESPONSE : RMIMessageKind.ERROR_RESPONSE;
            ComposedMessage message = ComposedMessage.allocateComposedMessage(messageType, kind, taskResponse);
            message.output().writeCompactLong(taskResponse.requestId);
            message.output().writeMarshalled(taskResponse.responseMessage.getMarshalledResult());
            if (!taskResponse.responseMessage.getRoute().isEmpty()) {
                MessageComposer.composeRoute(message, taskResponse.responseMessage.getRoute(), new JVMId.WriteContext());
            }
            this.completeMessageImpl(this.queues.get(RMIQueueType.RESPONSE), message);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
    }

    private void enqueueMessage(RMIQueueType type) {
        switch (type) {
            case REQUEST: {
                this.enqueueRequest();
                break;
            }
            case RESPONSE: {
                this.enqueueResponse();
                break;
            }
            case ADVERTISE: {
                this.enqueueAdvertise();
            }
        }
    }

    private boolean hasMoreMessages(RMIQueueType type) {
        switch (type) {
            case REQUEST: {
                return this.canEnqueueRequest && this.connection.requestsManager.outgoingRequestSize() > 0;
            }
            case RESPONSE: {
                return this.connection.tasksManager.completedTaskSize() > 0;
            }
            case ADVERTISE: {
                return this.connection.side.hasServer() && this.connection.serverDescriptorsManager.descriptorsSize() > 0;
            }
        }
        return false;
    }

    private void enqueueRequest() {
        RMIRequestImpl<?> request = this.connection.requestsManager.pollOutgoingRequest();
        if (request == null) {
            return;
        }
        if (RMIEndpointImpl.RMI_TRACE_LOG) {
            log.trace("Compose request " + request + " at " + this.connection);
        }
        if (request.isCancelRequest() && !this.supportsComboResponse) {
            this.composeOldCancel(request);
        }
        if (!request.setSendingState(this.connection)) {
            request.setFailedState(RMIExceptionType.CANCELLED_BEFORE_EXECUTION, null);
            return;
        }
        Integer subjectId = this.subjects.getOrComposeSubject(request);
        if (subjectId == null) {
            return;
        }
        Integer operationId = this.operations.getOrComposeOperation(request.getOperation());
        if (this.supportsComboResponse) {
            this.composeComboRequest(request, subjectId, operationId);
        } else {
            this.composeOldRequest(request, subjectId, operationId);
        }
    }

    private void enqueueResponse() {
        RMITaskResponse taskResponse = this.connection.tasksManager.pollCompletedTask();
        if (taskResponse == null) {
            return;
        }
        if (RMIEndpointImpl.RMI_TRACE_LOG) {
            log.trace("Compose response " + taskResponse + " at " + this.connection);
        }
        RMIResponseMessage message = taskResponse.responseMessage;
        RMIMessageKind kind = taskResponse.kind;
        if (this.supportsComboResponse) {
            this.composeComboResponse(taskResponse.responseMessage, taskResponse.channelId, taskResponse.requestId, kind);
        } else {
            this.composeOldResponse(taskResponse, message.getType() == RMIResponseType.SUCCESS ? MessageType.RMI_RESULT : MessageType.RMI_ERROR);
        }
    }

    private void enqueueAdvertise() {
        List<RMIServiceDescriptor> descriptors = this.connection.serverDescriptorsManager.pollServiceDescriptors();
        if (descriptors == null) {
            return;
        }
        this.composeAdvertiseServicesMessage(descriptors);
    }

    private static class Queues {
        private final EnumMap<RMIQueueType, ComposedMessageQueue> separateQueues = new EnumMap(RMIQueueType.class);

        Queues(RMIEndpoint.Side side) {
            this.separateQueues.put(RMIQueueType.DESCRIBE, new ComposedMessageQueue());
            this.separateQueues.put(RMIQueueType.RESPONSE, new ComposedMessageQueue());
            this.separateQueues.put(RMIQueueType.REQUEST, new ComposedMessageQueue());
            if (side.hasServer()) {
                this.separateQueues.put(RMIQueueType.ADVERTISE, new ComposedMessageQueue());
            }
        }

        ComposedMessageQueue get(RMIQueueType type) {
            return this.separateQueues.get((Object)type);
        }
    }

    private class Operations {
        private final Map<RMIOperation<?>, Integer> ids = new HashMap();
        private final Set<RMIOperation<?>> outgoing = new IndexedSet();
        private int counter;

        private Operations() {
        }

        Integer getOrComposeOperation(RMIOperation<?> operation) {
            Integer id = this.ids.get(operation);
            if (id != null) {
                return id;
            }
            ComposedMessage message = ComposedMessage.allocateComposedMessage(MessageType.RMI_DESCRIBE_OPERATION, RMIMessageKind.DESCRIBE_OPERATION, operation);
            id = ++this.counter;
            try {
                message.output().writeCompactInt(id);
                message.output().writeUTFString(operation.getSignature());
            }
            catch (IOException e) {
                throw new AssertionError((Object)"Unexpected IOException");
            }
            this.ids.put(operation, id);
            this.outgoing.add(operation);
            MessageComposer.this.completeMessage(message);
            return id;
        }

        boolean hasOutgoingOperation(RMIOperation<?> operation) {
            return this.outgoing.contains(operation);
        }

        void removeOutgoingOperation(RMIOperation<?> operation) {
            this.outgoing.remove(operation);
        }
    }

    private class Subjects {
        private final List<Integer> freeIds = new ArrayList<Integer>();
        private final LinkedHashMap<Marshalled<?>, Integer> ids;
        private final Set<Marshalled<?>> outgoing = new IndexedSet();
        private int counter;

        Subjects() {
            this.ids = new LinkedHashMap<Marshalled<?>, Integer>(16, 0.5f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<Marshalled<?>, Integer> eldest) {
                    boolean remove;
                    int subjectLimit = ((MessageComposer)MessageComposer.this).connection.endpoint.side.hasClient() ? ((MessageComposer)MessageComposer.this).connection.endpoint.getClient().getStoredSubjectsLimit() : 100000;
                    boolean bl = remove = this.size() > subjectLimit;
                    if (remove) {
                        Subjects.this.freeIds.add(eldest.getValue());
                    }
                    return remove;
                }
            };
        }

        Integer getOrComposeSubject(RMIRequestImpl<?> request) {
            Marshalled<?> marshalledSubject = request.getMarshalledSubject();
            if (marshalledSubject == Marshalled.NULL) {
                return 0;
            }
            Integer id = this.ids.get(marshalledSubject);
            if (id != null) {
                return id;
            }
            ComposedMessage message = ComposedMessage.allocateComposedMessage(MessageType.RMI_DESCRIBE_SUBJECT, RMIMessageKind.DESCRIBE_SUBJECT, marshalledSubject);
            int n = this.freeIds.size();
            id = n > 0 ? this.freeIds.remove(n - 1) : Integer.valueOf(++this.counter);
            try {
                message.output().writeCompactInt(id);
                message.output().writeMarshalled(marshalledSubject);
            }
            catch (Throwable t) {
                request.setFailedState(RMIExceptionType.SUBJECT_MARSHALLING_ERROR, t);
                ComposedMessage.releaseComposedMessage(message);
                return null;
            }
            this.ids.put(marshalledSubject, id);
            this.outgoing.add(marshalledSubject);
            MessageComposer.this.completeMessage(message);
            return id;
        }

        boolean hasOutgoingSubject(Marshalled<?> marshalledSubject) {
            return this.outgoing.contains(marshalledSubject);
        }

        void removeOutgoingSubject(Marshalled<?> marshalledSubject) {
            this.outgoing.remove(marshalledSubject);
        }
    }

    private static enum MessageQueueState {
        VISITOR_FULL(true),
        NO_MORE_MESSAGES(false),
        NOT_ALL_SENT(true);

        private boolean hasMoreWork;

        public boolean hasMoreWork() {
            return this.hasMoreWork;
        }

        private MessageQueueState(boolean hasMoreWork) {
            this.hasMoreWork = hasMoreWork;
        }
    }
}

