/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.impl.RMIFailedException;
import com.devexperts.rmi.impl.RMILog;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.task.BalanceResult;
import com.devexperts.rmi.task.RMILoadBalancer;
import com.devexperts.rmi.task.RMILoadBalancerFactory;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.dxfeed.promise.Promise;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

class LoadBalancers {
    private final Map<String, RMILoadBalancer> loadBalancers = new HashMap<String, RMILoadBalancer>();
    private final List<RMILoadBalancerFactory> factories;
    private boolean closed = false;

    LoadBalancers(List<RMILoadBalancerFactory> rmiLoadBalancerFactories) {
        this.factories = rmiLoadBalancerFactories;
    }

    @Nonnull
    Promise<BalanceResult> balance(RMIRequestMessage<?> message) {
        if (this.closed) {
            RMILog.log.error("Attempt to balance a message on closed endpoint: " + message, new Exception());
            return Promise.failed(new RMIFailedException("Attempt to balance a message on closed endpoint"));
        }
        try {
            String serviceName = message.getOperation().getServiceName();
            RMILoadBalancer loadBalancer = this.getBalancer(serviceName);
            Promise<BalanceResult> result = loadBalancer.balance(message);
            if (result == null) {
                return Promise.failed(new RMIFailedException("Load balancer returned null"));
            }
            return result;
        }
        catch (Throwable e) {
            return Promise.failed(e);
        }
    }

    @Nonnull
    private RMILoadBalancer getBalancer(String serviceName) {
        RMILoadBalancer loadBalancer = this.loadBalancers.get(serviceName);
        if (loadBalancer == null) {
            loadBalancer = this.createLoadBalancer(serviceName);
            this.loadBalancers.put(serviceName, loadBalancer);
        }
        assert (loadBalancer != null);
        return loadBalancer;
    }

    void updateDescriptorInLoadBalancer(RMIServiceDescriptor descriptor) {
        if (this.closed) {
            return;
        }
        RMILoadBalancer loadBalancer = this.getBalancer(descriptor.getServiceName());
        try {
            loadBalancer.updateServiceDescriptor(descriptor);
        }
        catch (Exception e) {
            RMILog.log.error("Error updating descriptor " + descriptor + " in RMI load balancer " + loadBalancer, e);
        }
    }

    void close() {
        this.loadBalancers.forEach((k, v) -> this.closeBalancer((RMILoadBalancer)v));
        this.loadBalancers.clear();
        this.closed = true;
    }

    private void closeBalancer(RMILoadBalancer loadBalancer) {
        try {
            loadBalancer.close();
        }
        catch (Exception e) {
            RMILog.log.error("Error closing RMI load balancer " + loadBalancer, e);
        }
    }

    private RMILoadBalancer createLoadBalancer(String serviceName) {
        if (RMIEndpointImpl.RMI_TRACE_LOG) {
            RMILog.log.trace("Creating RMI load balancer for service " + serviceName);
        }
        for (RMILoadBalancerFactory factory : this.factories) {
            RMILoadBalancer loadBalancer = factory.createLoadBalancer(serviceName);
            if (loadBalancer == null) continue;
            return loadBalancer;
        }
        throw new IllegalStateException("Could not create a load balancer for " + serviceName);
    }
}

