/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.io.BufferedOutput;
import com.devexperts.io.ByteArrayOutput;
import com.devexperts.io.Chunk;
import com.devexperts.io.ChunkList;
import com.devexperts.io.ChunkPool;
import com.devexperts.io.ChunkedInput;
import com.devexperts.io.ChunkedOutput;
import com.devexperts.io.IOUtil;
import com.devexperts.qd.qtp.MessageType;
import com.devexperts.rmi.impl.RMIMessageKind;
import com.devexperts.util.SystemProperties;
import com.devexperts.util.ThreadLocalPool;
import java.io.IOException;

class ComposedMessage {
    static final int MESSAGE_PART_MAX_SIZE = SystemProperties.getIntProperty("com.devexperts.rmi.messagePartMaxSize", 4000);
    static final int RESERVE = 20;
    private static final ChunkPoolWithReserveBytesForHeader CHUNK_POOL = new ChunkPoolWithReserveBytesForHeader("com.devexperts.rmi");
    private static final ThreadLocalPool<ComposedMessage> MESSAGE_POOL = new ThreadLocalPool("com.devexperts.rmi.Message", 3, 1024);
    private final ChunkedOutput output = new ChunkedOutput(CHUNK_POOL);
    private ChunkList chunks;
    private RMIMessageKind kind;
    private int type;
    private Object object;
    private long sequence = -1L;
    private boolean startedTransmission;

    ComposedMessage() {
    }

    static ComposedMessage allocateComposedMessage(MessageType messageType, RMIMessageKind kind, Object object) {
        ComposedMessage result = MESSAGE_POOL.poll();
        if (result == null) {
            result = new ComposedMessage();
        }
        result.kind = kind;
        result.type = messageType.getId();
        result.object = object;
        return result;
    }

    static void releaseComposedMessage(ComposedMessage composedMessage) {
        composedMessage.clear();
        MESSAGE_POOL.offer(composedMessage);
    }

    BufferedOutput output() {
        return this.output;
    }

    RMIMessageKind kind() {
        return this.kind;
    }

    int type() {
        return this.type;
    }

    Object getObject() {
        return this.object;
    }

    long sequence() {
        return this.sequence;
    }

    boolean startedTransmission() {
        return this.startedTransmission;
    }

    void chunkTransmitted() {
        this.startedTransmission = true;
        this.chunks.poll(this).recycle(this);
    }

    Chunk firstChunk() {
        return this.chunks.get(0);
    }

    boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    int chunksCount() {
        return this.chunks.size();
    }

    long totalChunksLength() {
        return this.chunks.getTotalLength();
    }

    void flushOutputChunks() {
        this.chunks = this.output.getOutput(this);
    }

    void completeMessageParts(int sequence, ByteArrayOutput aux) {
        try {
            long messageLength = (long)IOUtil.getCompactLength(this.type()) + this.chunks.getTotalLength();
            aux.clear();
            aux.writeCompactLong(messageLength);
            aux.writeCompactInt(this.type());
            int prefixLength = aux.getPosition();
            Chunk firstChunk = this.chunks.get(0);
            this.chunks.setChunkRange(0, firstChunk.getOffset() - prefixLength, firstChunk.getLength() + prefixLength, this);
            System.arraycopy(aux.getBuffer(), 0, firstChunk.getBytes(), firstChunk.getOffset(), prefixLength);
            this.sequence = sequence;
            aux.clear();
            aux.writeCompactLong(this.sequence());
            int sequenceLength = aux.getPosition();
            for (int i = 0; i < this.chunks.size(); ++i) {
                Chunk chunk = this.chunks.get(i);
                this.chunks.setChunkRange(i, chunk.getOffset() - sequenceLength, chunk.getLength() + sequenceLength, this);
                System.arraycopy(aux.getBuffer(), 0, chunk.getBytes(), chunk.getOffset(), sequenceLength);
            }
            aux.clear();
            this.type = MessageType.PART.getId();
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
    }

    void completeMonolithicMessage() {
        try {
            byte[] bytes = new byte[(int)this.chunks.getTotalLength()];
            ChunkedInput input = new ChunkedInput();
            input.addAllToInput(this.chunks, this);
            input.read(bytes);
            input.clear();
            this.chunks = ChunkList.wrap(bytes, this);
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
    }

    void abortRemainingMessageParts() {
        this.chunks.recycle(this);
        try {
            this.output.writeCompactLong(this.sequence());
        }
        catch (IOException e) {
            throw new AssertionError((Object)"Unexpected IOException");
        }
        this.chunks = this.output.getOutput(this);
    }

    private void clear() {
        this.output.clear();
        if (this.chunks != null) {
            this.chunks.recycle(this);
            this.chunks = null;
        }
        this.kind = null;
        this.object = null;
        this.type = -1;
        this.sequence = -1L;
        this.startedTransmission = false;
    }

    private static final class ChunkPoolWithReserveBytesForHeader
    extends ChunkPool {
        ChunkPoolWithReserveBytesForHeader(String poolName) {
            super(poolName, 3, 4096, 1024, MESSAGE_PART_MAX_SIZE + 20, 1024);
        }

        @Override
        public Chunk getChunk(Object owner) {
            Chunk chunk = super.getChunk(owner);
            chunk.setRange(20, MESSAGE_PART_MAX_SIZE, owner);
            return chunk;
        }
    }
}

