/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.impl.AbstractServiceDescriptorsProcessor;
import com.devexperts.rmi.impl.LoadBalancers;
import com.devexperts.rmi.impl.RMIClientImpl;
import com.devexperts.rmi.impl.RMIClientService;
import com.devexperts.rmi.impl.RMIConnection;
import com.devexperts.rmi.impl.ServiceRouter;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.task.BalanceResult;
import com.devexperts.rmi.task.RMILoadBalancerFactory;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceId;
import com.dxfeed.promise.Promise;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;

class ClientSideServices {
    private ServiceRouter<RMIConnection> anonymousRouter;
    private final Map<RMIServiceId, ServiceRouter<RMIConnection>> routers = new HashMap<RMIServiceId, ServiceRouter<RMIConnection>>();
    private final Map<String, RMIClientService> services = new HashMap<String, RMIClientService>();
    private final LoadBalancers loadBalancers;
    private final RMIClientImpl client;

    ClientSideServices(RMIClientImpl client, List<RMILoadBalancerFactory> rmiLoadBalancerFactories) {
        this.client = client;
        this.loadBalancers = new LoadBalancers(rmiLoadBalancerFactories);
    }

    synchronized RMIClientService getService(String serviceName) {
        return this.getOrCreateRMIServiceClient(serviceName);
    }

    synchronized RMIConnection getConnection(RMIServiceId serviceId) {
        ServiceRouter<RMIConnection> router = this.routers.get(serviceId);
        if (router == null) {
            router = this.anonymousRouter;
        }
        return router == null ? null : router.pickRandom();
    }

    synchronized void updateAnonymousRouter(RMIConnection connection) {
        if (!connection.closed) {
            if (this.anonymousRouter == null) {
                this.anonymousRouter = ServiceRouter.createAnonymousRouter(this.client.endpoint.getEndpointId());
            }
            this.anonymousRouter.updateDescriptor(null, connection.weight, connection);
            return;
        }
        if (this.anonymousRouter == null) {
            return;
        }
        this.anonymousRouter.removeDescriptor(null, connection);
        if (this.anonymousRouter.isEmpty()) {
            this.anonymousRouter = null;
        }
    }

    synchronized Promise<BalanceResult> balance(RMIRequestMessage<?> message) {
        return this.loadBalancers.balance(message);
    }

    synchronized void updateDescriptorAndUpdateServices(List<RMIServiceDescriptor> descriptors, RMIConnection connection) {
        for (RMIServiceDescriptor descriptor : descriptors) {
            if (!this.updateServiceRouter(descriptor, connection)) continue;
            this.loadBalancers.updateDescriptorInLoadBalancer(descriptor);
        }
    }

    private synchronized void updateServices(List<RMIServiceDescriptor> descriptors) {
        HashMap batchedMap = new HashMap();
        ArrayList<RMIServiceDescriptor> acceptedDescriptors = new ArrayList<RMIServiceDescriptor>();
        for (RMIClientService rMIClientService : this.services.values()) {
            for (RMIServiceDescriptor descriptor : descriptors) {
                if (!rMIClientService.getFilter().accept(descriptor.getServiceName())) continue;
                acceptedDescriptors.add(descriptor);
            }
            if (acceptedDescriptors.isEmpty()) continue;
            batchedMap.put(rMIClientService, new ArrayList(acceptedDescriptors));
            acceptedDescriptors.clear();
        }
        for (Map.Entry entry : batchedMap.entrySet()) {
            ((RMIClientService)entry.getKey()).updateDescriptors((List)entry.getValue());
        }
    }

    @GuardedBy(value="this")
    private boolean updateServiceRouter(RMIServiceDescriptor descriptor, RMIConnection connection) {
        RMIServiceId serviceId = descriptor.getServiceId();
        ServiceRouter<RMIConnection> router = this.routers.get(serviceId);
        boolean changes = false;
        if (router == null) {
            if (!descriptor.isAvailable()) {
                return false;
            }
            router = ServiceRouter.createRouter(this.client.endpoint.getEndpointId(), serviceId);
            router.addServiceDescriptorsListener(new ClientRouterProcessor());
            this.routers.put(serviceId, router);
            changes = true;
        }
        router.updateDescriptor(descriptor, descriptor.getDistance(), connection);
        if (router.isEmpty()) {
            this.routers.remove(descriptor.getServiceId());
            changes = true;
        }
        return changes;
    }

    @GuardedBy(value="this")
    private ServiceRouter<RMIConnection> getRouter(String serviceName) {
        for (Map.Entry<RMIServiceId, ServiceRouter<RMIConnection>> serviceIdRouterEntry : this.routers.entrySet()) {
            if (!serviceIdRouterEntry.getKey().getName().equals(serviceName)) continue;
            return serviceIdRouterEntry.getValue();
        }
        return this.anonymousRouter;
    }

    @GuardedBy(value="this")
    private RMIClientService getOrCreateRMIServiceClient(String name) {
        if (!this.services.containsKey(name)) {
            RMIClientService service = new RMIClientService(name, this.client);
            ArrayList<RMIServiceDescriptor> result = new ArrayList<RMIServiceDescriptor>();
            for (Map.Entry<RMIServiceId, ServiceRouter<RMIConnection>> serviceIdRouterEntity : this.routers.entrySet()) {
                if (!service.getFilter().accept(serviceIdRouterEntity.getKey().getName())) continue;
                result.add(serviceIdRouterEntity.getValue().pickFirstDescriptor());
            }
            service.updateDescriptors(result);
            this.services.put(name, service);
        }
        return this.services.get(name);
    }

    synchronized void close() {
        this.loadBalancers.close();
    }

    private class ClientRouterProcessor
    extends AbstractServiceDescriptorsProcessor {
        private ClientRouterProcessor() {
            super(ClientSideServices.this.client.getDefaultExecutor());
        }

        @Override
        protected void process(List<RMIServiceDescriptor> descriptors) {
            ClientSideServices.this.updateServices(descriptors);
        }

        public String toString() {
            return "ClientRouterProcessor{" + ((ClientSideServices)ClientSideServices.this).client.endpoint + "}";
        }
    }
}

