/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.util.IndexedSet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.GuardedBy;

public class ClientDescriptorsManager {
    @GuardedBy(value="RMIClientImpl.services")
    private final IndexedSet<RMIServiceId, RMIServiceDescriptor> serviceDescriptors = IndexedSet.create(RMIServiceDescriptor.INDEXER_BY_SERVICE_ID);

    @GuardedBy(value="RMIClientImpl.services")
    void updateDescriptors(List<RMIServiceDescriptor> descriptors) {
        for (RMIServiceDescriptor descriptor : descriptors) {
            if (descriptor.isAvailable()) {
                this.serviceDescriptors.add(descriptor);
                continue;
            }
            this.serviceDescriptors.removeValue(descriptor);
        }
    }

    @GuardedBy(value="RMIClientImpl.services")
    List<RMIServiceDescriptor> clearDescriptors() {
        ArrayList<RMIServiceDescriptor> result = new ArrayList<RMIServiceDescriptor>(this.serviceDescriptors);
        this.serviceDescriptors.clear();
        return result;
    }
}

