/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.rmi.impl.RMIChannelImpl;
import com.devexperts.rmi.task.RMIChannelType;
import com.devexperts.util.IndexedSet;
import java.util.EnumMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class ChannelsManager {
    private final EnumMap<RMIChannelType, IndexedSet<Long, RMIChannelImpl>> channels = new EnumMap(RMIChannelType.class);

    ChannelsManager() {
    }

    synchronized void addChannel(RMIChannelImpl channel) {
        this.getSet(channel.getType()).add(channel);
    }

    synchronized void removeChannel(long id, RMIChannelType type) {
        this.getSet(type).removeKey(id);
    }

    synchronized RMIChannelImpl getChannel(Long id, RMIChannelType type) {
        return this.getSet(type).getByKey(id);
    }

    private IndexedSet<Long, RMIChannelImpl> getSet(RMIChannelType type) {
        IndexedSet<Long, RMIChannelImpl> result = this.channels.get((Object)type);
        if (result == null) {
            result = IndexedSet.createLong(RMIChannelImpl.CHANNEL_INDEXER_BY_REQUEST_ID);
            this.channels.put(type, result);
        }
        return result;
    }
}

