/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.util.InvalidFormatException;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class AdvertisementFilter {
    public static final AdvertisementFilter ALL = new AdvertisementFilter(FilterType.ALL);
    public static final AdvertisementFilter NONE = new AdvertisementFilter(FilterType.NONE);
    private final FilterType type;

    private AdvertisementFilter(FilterType type) {
        this.type = type;
    }

    @Nonnull
    public static AdvertisementFilter valueOf(String filter) {
        Objects.requireNonNull(filter, "filter");
        if (filter.trim().isEmpty()) {
            throw new IllegalArgumentException("Advertisement filter is empty");
        }
        String trimmed = filter.trim();
        if (AdvertisementFilter.ALL.type.code.equalsIgnoreCase(trimmed)) {
            return ALL;
        }
        if (AdvertisementFilter.NONE.type.code.equalsIgnoreCase(trimmed)) {
            return NONE;
        }
        throw new InvalidFormatException("Advertisement filter: unsupported value '" + trimmed + "'. Only 'all' or 'none' are supported");
    }

    public boolean isSendAdvertisement() {
        return this.type == FilterType.ALL;
    }

    private static enum FilterType {
        ALL("all"),
        NONE("none");

        private final String code;

        private FilterType(String code) {
            this.code = code;
        }
    }
}

