/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi.impl;

import com.devexperts.logging.Logging;
import com.devexperts.rmi.impl.RMIEndpointImpl;
import com.devexperts.rmi.task.RMIServiceDescriptor;
import com.devexperts.rmi.task.RMIServiceDescriptorsListener;
import com.devexperts.rmi.task.RMIServiceId;
import com.devexperts.util.IndexedSet;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;

abstract class AbstractServiceDescriptorsProcessor
implements RMIServiceDescriptorsListener,
Runnable {
    private final Logging log = Logging.getLogging(this.getClass());
    private final Executor executor;
    @GuardedBy(value="this")
    private final IndexedSet<RMIServiceId, RMIServiceDescriptor> descriptors = IndexedSet.create(RMIServiceDescriptor.INDEXER_BY_SERVICE_ID);
    private final AtomicInteger scheduled = new AtomicInteger(0);

    AbstractServiceDescriptorsProcessor(Executor executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void descriptorsUpdated(List<RMIServiceDescriptor> descriptors) {
        boolean schedule;
        AbstractServiceDescriptorsProcessor abstractServiceDescriptorsProcessor = this;
        synchronized (abstractServiceDescriptorsProcessor) {
            this.descriptors.addAll(descriptors);
        }
        boolean bl = schedule = this.scheduled.getAndIncrement() == 0;
        if (RMIEndpointImpl.RMI_TRACE_LOG) {
            this.log.trace("Update descriptors by " + this + ", descriptors=" + descriptors + ", schedule=" + schedule);
        }
        if (schedule) {
            this.executor.execute(this);
        }
    }

    @Override
    public void run() {
        int oldScheduled;
        do {
            oldScheduled = this.scheduled.get();
            List<RMIServiceDescriptor> descriptors = this.takeDescriptors();
            if (RMIEndpointImpl.RMI_TRACE_LOG) {
                this.log.trace("Process descriptors by " + this + ", descriptors=" + descriptors);
            }
            this.process(descriptors);
        } while (!this.scheduled.compareAndSet(oldScheduled, 0));
    }

    protected abstract void process(List<RMIServiceDescriptor> var1);

    private synchronized List<RMIServiceDescriptor> takeDescriptors() {
        ArrayList<RMIServiceDescriptor> result = new ArrayList<RMIServiceDescriptor>(this.descriptors);
        this.descriptors.clear();
        return result;
    }
}

