/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi;

import com.devexperts.rmi.RMIException;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequestListener;
import com.devexperts.rmi.RMIRequestState;
import com.devexperts.rmi.impl.RMIPromiseImpl;
import com.devexperts.rmi.message.RMIRequestMessage;
import com.devexperts.rmi.message.RMIResponseMessage;
import com.devexperts.rmi.task.RMIChannel;
import com.dxfeed.promise.Promise;
import java.util.concurrent.Executor;

public abstract class RMIRequest<T> {
    public abstract void setListener(RMIRequestListener var1);

    public abstract void setExecutor(Executor var1);

    public abstract void send();

    public abstract boolean isCompleted();

    public abstract boolean isOneWay();

    public abstract void cancelWithConfirmation();

    public void cancelWith(boolean confirmation) {
        if (confirmation) {
            this.cancelWithConfirmation();
        } else {
            this.cancelOrAbort();
        }
    }

    public abstract void cancelOrAbort();

    public abstract RMIRequestState getState();

    public abstract T getBlocking() throws RMIException;

    public abstract T getNonBlocking();

    public abstract RMIException getException();

    public abstract long getSendTime();

    public abstract long getRunningStartTime();

    public abstract long getCompletionTime();

    public abstract Object getSubject();

    public abstract RMIOperation<T> getOperation();

    public abstract Object[] getParameters();

    public abstract RMIRequestMessage<T> getRequestMessage();

    public abstract RMIResponseMessage getResponseMessage();

    public abstract Promise<T> getPromise();

    public abstract RMIChannel getChannel();

    public static <T> RMIRequest<T> of(Promise<T> promise) {
        return promise instanceof RMIPromiseImpl ? ((RMIPromiseImpl)promise).getRequest() : null;
    }
}

