/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi;

import com.devexperts.io.Marshaller;
import com.devexperts.rmi.RMIServiceMethod;
import com.dxfeed.promise.Promise;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class RMIOperation<T> {
    private static final char SIGNATURE_SERVICE_NAME_SEP = '#';
    private static final char SIGNATURE_START_PARAMS_SEP = '(';
    private static final String SIGNATURE_END_PARAMS_SEP = "):";
    private final String signature;
    private final String serviceName;
    private final String methodName;
    private final Marshaller.Typed<Object[]> parametersMarshaller;
    private final Marshaller.Typed<T> resultMarshaller;

    public static <T> RMIOperation<T> valueOf(Class<?> serviceInterface, Method method) {
        return RMIOperation.valueOf(serviceInterface.getName(), method);
    }

    public static <T> RMIOperation<T> valueOf(String serviceName, Method method) {
        RMIServiceMethod methodAnnotation;
        Class<?> resultClass = method.getReturnType();
        if (resultClass == Promise.class) {
            resultClass = RMIOperation.extractPromiseReturnType(method);
        }
        String name = (methodAnnotation = method.getAnnotation(RMIServiceMethod.class)) != null && !methodAnnotation.name().isEmpty() ? methodAnnotation.name() : method.getName();
        return RMIOperation.valueOf(serviceName, resultClass, name, method.getParameterTypes());
    }

    private static Class<?> extractPromiseReturnType(Method method) {
        Type returnType = method.getGenericReturnType();
        if (!(returnType instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Promise return type '" + returnType + "' of method '" + method + " is not parameterized");
        }
        Type[] actualTypeArguments = ((ParameterizedType)returnType).getActualTypeArguments();
        assert (actualTypeArguments.length == 1);
        Type argument = actualTypeArguments[0];
        if (argument instanceof Class) {
            return (Class)argument;
        }
        if (argument instanceof ParameterizedType) {
            return (Class)((ParameterizedType)argument).getRawType();
        }
        throw new IllegalArgumentException("Promise return type '" + returnType + "' of method '" + method + " is not properly parameterized");
    }

    public static <T> RMIOperation<T> valueOf(String serviceName, Class<T> resultClass, String methodName, Class<?> ... parameterClasses) {
        return new RMIOperation<T>(serviceName, resultClass, methodName, parameterClasses);
    }

    public static <T> RMIOperation<T> valueOf(Class<?> serviceInterface, Class<T> resultClass, String methodName, Class<?> ... parameterClasses) {
        return new RMIOperation<T>(serviceInterface.getName(), resultClass, methodName, parameterClasses);
    }

    public static <T> RMIOperation<T> valueOf(String signature) {
        return new RMIOperation<T>(signature);
    }

    public String getSignature() {
        return this.signature;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Marshaller.Typed<Object[]> getParametersMarshaller() {
        return this.parametersMarshaller;
    }

    public Marshaller.Typed<T> getResultMarshaller() {
        return this.resultMarshaller;
    }

    public boolean equals(Object other) {
        return other instanceof RMIOperation && ((RMIOperation)other).signature.equals(this.signature);
    }

    public int hashCode() {
        return this.signature.hashCode();
    }

    public String toString() {
        return this.signature;
    }

    private RMIOperation(String serviceName, Class<T> resultClass, String methodName, Class<?>[] parameterClasses) {
        if (serviceName.indexOf(35) >= 0) {
            throw new IllegalArgumentException("Invalid service name: " + serviceName);
        }
        if (methodName.indexOf(40) >= 0) {
            throw new IllegalArgumentException("Invalid method name: " + methodName);
        }
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.parametersMarshaller = Marshaller.forClasses(parameterClasses);
        this.resultMarshaller = Marshaller.forClass(resultClass);
        this.signature = serviceName + '#' + methodName + '(' + this.parametersMarshaller.getTypes() + SIGNATURE_END_PARAMS_SEP + resultClass.getName();
    }

    private RMIOperation(String signature) {
        this.signature = signature;
        int i = signature.indexOf(35);
        int j = signature.indexOf(40, i + 1);
        int k = signature.indexOf(SIGNATURE_END_PARAMS_SEP, j + 1);
        this.serviceName = signature.substring(0, i);
        this.methodName = signature.substring(i + 1, j);
        this.parametersMarshaller = Marshaller.forTypes(signature.substring(j + 1, k));
        this.resultMarshaller = Marshaller.forType(signature.substring(k + SIGNATURE_END_PARAMS_SEP.length()));
    }
}

