/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi;

public enum RMIExceptionType {
    APPLICATION_ERROR(1, FailureInstant.AFTER_EXECUTION, "Request execution finished by throwing an internal application error"),
    CANCELLED_BEFORE_EXECUTION(10, FailureInstant.BEFORE_EXECUTION, "Request was cancelled before execution"),
    CANCELLED_DURING_EXECUTION(11, FailureInstant.ANYWHERE_DURING_EXECUTION, "Request was cancelled during execution"),
    CANCELLED_AFTER_EXECUTION(12, FailureInstant.AFTER_EXECUTION, "Request was cancelled after execution"),
    DISCONNECTION(20, FailureInstant.ANYWHERE_DURING_EXECUTION, "Connection broke"),
    EXECUTION_REJECTION(21, FailureInstant.BEFORE_EXECUTION, "The task was rejected by executor"),
    ILLEGAL_ACCESS(22, FailureInstant.BEFORE_EXECUTION, "Could not access method"),
    SECURITY_VIOLATION(23, FailureInstant.BEFORE_EXECUTION, "Request execution was forbidden by security controller"),
    EXECUTION_ERROR(24, FailureInstant.ANYWHERE_DURING_EXECUTION, "Could not execute method"),
    REQUEST_SENDING_TIMEOUT(25, FailureInstant.BEFORE_EXECUTION, "Could not send request within timeout"),
    REQUEST_RUNNING_TIMEOUT(26, FailureInstant.ANYWHERE_DURING_EXECUTION, "Request remote execution timeout exceeded"),
    UNKNOWN_SUBJECT(30, FailureInstant.BEFORE_EXECUTION, "Unknown subject identifier in request"),
    UNKNOWN_OPERATION(31, FailureInstant.BEFORE_EXECUTION, "Unknown operation identifier in request"),
    OPERATION_NOT_PROVIDED(32, FailureInstant.BEFORE_EXECUTION, "Requested operation is not provided by remote side"),
    UNKNOWN_RMI_EXCEPTION(33, FailureInstant.ANYWHERE_DURING_EXECUTION, "Unknown RMI exception occurred"),
    UNKNOWN_SERVICE(34, FailureInstant.BEFORE_EXECUTION, "Unknown service in request"),
    TASK_CANCEL_LISTENER_NOT_SET(35, FailureInstant.ANYWHERE_DURING_EXECUTION, "Service implementation did not set task cancel listener"),
    INVALID_SUSPEND_STATE(36, FailureInstant.ANYWHERE_DURING_EXECUTION, "Service implementation did handle suspended state properly"),
    ROUTE_IS_NOT_FOUND(37, FailureInstant.BEFORE_EXECUTION, "Route to server could not be found"),
    FAILED_TO_READ_REQUEST(38, FailureInstant.BEFORE_EXECUTION, "Server was unable to read request"),
    CHANNEL_CLOSED(39, FailureInstant.ANYWHERE_DURING_EXECUTION, "The channel closed, or closed during the execution of the request"),
    SERVICE_UNAVAILABLE(40, FailureInstant.BEFORE_EXECUTION, "Load balancing could not select the target service"),
    PARAMETERS_MARSHALLING_ERROR(50, FailureInstant.BEFORE_EXECUTION, "Could not marshall method parameters"),
    PARAMETERS_UNMARSHALLING_ERROR(51, FailureInstant.BEFORE_EXECUTION, "Could not unmarshall method parameters"),
    SUBJECT_MARSHALLING_ERROR(52, FailureInstant.BEFORE_EXECUTION, "Could not marshall subject"),
    SUBJECT_UNMARSHALLING_ERROR(53, FailureInstant.BEFORE_EXECUTION, "Could not unmarshall subject"),
    RESULT_MARSHALLING_ERROR(54, FailureInstant.AFTER_EXECUTION, "Could not marshall execution result"),
    RESULT_UNMARSHALLING_ERROR(55, FailureInstant.AFTER_EXECUTION, "Could not unmarshall execution result"),
    APPLICATION_ERROR_MARSHALLING_ERROR(56, FailureInstant.AFTER_EXECUTION, "Could not marshall application error"),
    APPLICATION_ERROR_UNMARSHALLING_ERROR(57, FailureInstant.AFTER_EXECUTION, "Could not unmarshall application error");

    private static final RMIExceptionType[] TYPE_BY_ID;
    private final String message;
    private final int id;
    private final FailureInstant failureInstant;

    public boolean isFailedBeforeExecution() {
        return this.failureInstant == FailureInstant.BEFORE_EXECUTION;
    }

    public boolean isFailedAfterExecution() {
        return this.failureInstant == FailureInstant.AFTER_EXECUTION;
    }

    public boolean isCancelled() {
        return this == CANCELLED_DURING_EXECUTION || this == CANCELLED_BEFORE_EXECUTION || this == CANCELLED_AFTER_EXECUTION;
    }

    public String getMessage() {
        return this.message;
    }

    public int getId() {
        return this.id;
    }

    public static RMIExceptionType getById(int id) {
        return id >= 0 && id < TYPE_BY_ID.length ? TYPE_BY_ID[id] : null;
    }

    private RMIExceptionType(int id, FailureInstant failureInstant, String message) {
        this.id = id;
        this.failureInstant = failureInstant;
        this.message = message;
    }

    static {
        TYPE_BY_ID = new RMIExceptionType[60];
        for (RMIExceptionType type : RMIExceptionType.values()) {
            if (TYPE_BY_ID[type.getId()] != null) {
                throw new AssertionError((Object)("Duplicate id: " + type.getId()));
            }
            RMIExceptionType.TYPE_BY_ID[type.getId()] = type;
        }
    }

    private static enum FailureInstant {
        BEFORE_EXECUTION,
        ANYWHERE_DURING_EXECUTION,
        AFTER_EXECUTION;

    }
}

