/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi;

import com.devexperts.rmi.RMIExceptionType;
import com.devexperts.rmi.RMIRequest;
import java.rmi.RemoteException;

public final class RMIException
extends RemoteException {
    private static final long serialVersionUID = 0L;
    private final RMIExceptionType type;
    private final boolean requestInfo;

    public RMIException(RMIExceptionType type, Throwable cause) {
        super(type.getMessage(), cause);
        if (type == RMIExceptionType.APPLICATION_ERROR && cause == null) {
            throw new NullPointerException("Application error cause can never be null.");
        }
        this.type = type;
        this.requestInfo = false;
    }

    public RMIException(RMIException exception, RMIRequest<?> request) {
        super(exception.getMessage() + " (" + request.toString() + ")", exception.getCause());
        this.type = exception.type;
        this.requestInfo = true;
    }

    public boolean hasRequestInfo() {
        return this.requestInfo;
    }

    public RMIExceptionType getType() {
        return this.type;
    }
}

