/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.rmi;

import com.devexperts.io.SerialClassContext;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.qtp.MessageAdapter;
import com.devexperts.rmi.RMIClient;
import com.devexperts.rmi.RMIEndpointListener;
import com.devexperts.rmi.RMIOperation;
import com.devexperts.rmi.RMIRequest;
import com.devexperts.rmi.RMIServer;
import com.devexperts.rmi.security.SecurityController;
import com.devexperts.services.Service;
import com.devexperts.services.Services;
import com.devexperts.transport.stats.EndpointStats;
import com.dxfeed.api.DXEndpoint;
import java.io.Closeable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.TrustManager;

public abstract class RMIEndpoint
implements Closeable {
    public static final String NAME_PROPERTY = "name";

    public static Builder newBuilder() {
        Builder builder = Services.createService(Builder.class, null, null);
        if (builder == null) {
            throw new IllegalStateException("There is no " + Builder.class + " implementation service in class path");
        }
        return builder;
    }

    public static RMIEndpoint createEndpoint() {
        return RMIEndpoint.newBuilder().build();
    }

    public static RMIEndpoint createEndpoint(DXEndpoint.Role role) {
        return RMIEndpoint.newBuilder().withRole(role).build();
    }

    public static RMIEndpoint createEndpoint(Side side) {
        return RMIEndpoint.newBuilder().withSide(side).build();
    }

    public abstract void connect(String var1);

    public abstract void reconnect();

    public abstract void disconnect();

    @Override
    public abstract void close();

    public abstract boolean isConnected();

    public abstract EndpointStats getEndpointStats();

    public abstract void addEndpointListener(RMIEndpointListener var1);

    public abstract void removeEndpointListener(RMIEndpointListener var1);

    public abstract void setSerialClassContext(SerialClassContext var1);

    public abstract SerialClassContext getSerialClassContext();

    public abstract SecurityController getSecurityController();

    public abstract void setSecurityController(SecurityController var1);

    public abstract DXEndpoint getDXEndpoint();

    public abstract MessageAdapter.Factory getAttachedMessageAdapterFactory();

    public abstract void setAttachedMessageAdapterFactory(MessageAdapter.Factory var1);

    public abstract void setTrustManager(TrustManager var1);

    public abstract String getName();

    public abstract Side getSide();

    public abstract RMIServer getServer();

    public abstract RMIClient getClient();

    public abstract <T> void export(T var1, Class<T> var2);

    public abstract <T> void export(T var1, Class<T> var2, ExecutorService var3);

    public abstract <T> void export(T var1, Class<T> var2, String var3);

    public abstract <T> void export(T var1, Class<T> var2, String var3, ExecutorService var4);

    public abstract ExecutorService getDefaultExecutor();

    public abstract void setDefaultExecutor(ExecutorService var1);

    public abstract <T> T getProxy(Class<T> var1);

    public abstract <T> T getProxy(Class<T> var1, String var2);

    public abstract <T> RMIRequest<T> createRequest(Object var1, RMIOperation<T> var2, Object ... var3);

    public abstract <T> RMIRequest<T> createOneWayRequest(Object var1, RMIOperation<T> var2, Object ... var3);

    public abstract void setRequestSendingTimeout(long var1);

    public abstract long getRequestSendingTimeout();

    public abstract void setRequestRunningTimeout(long var1);

    public abstract long getRequestRunningTimeout();

    public abstract void setStoredSubjectsLimit(int var1);

    public abstract int getStoredSubjectsLimit();

    public abstract int getSendingRequestsQueueLength();

    @Service
    public static abstract class Builder {
        private static final AtomicInteger INSTANCES_NUMERATOR = new AtomicInteger();
        protected DataScheme scheme;
        protected DXEndpoint.Role dxRole;
        protected Side side = Side.CLIENT_SERVER;
        protected final Properties props = new Properties();

        protected Builder() {
        }

        public final Builder withName(String name) {
            return this.withProperty(RMIEndpoint.NAME_PROPERTY, name);
        }

        public final Builder withScheme(DataScheme scheme) {
            if (scheme == null) {
                throw new NullPointerException();
            }
            this.scheme = scheme;
            return this;
        }

        public Builder withSide(Side side) {
            this.side = side;
            return this;
        }

        public Builder withRole(DXEndpoint.Role role) {
            if (role != DXEndpoint.Role.FEED && role != DXEndpoint.Role.PUBLISHER) {
                throw new IllegalArgumentException("Unsupported role " + (Object)((Object)role));
            }
            this.dxRole = role;
            return this;
        }

        public final Builder withProperty(String key, String value) {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            if (this.supportsProperty(key)) {
                this.props.setProperty(key, value);
            }
            return this;
        }

        public final Builder withProperties(Properties props) {
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                this.withProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return this;
        }

        public boolean supportsProperty(String key) {
            return RMIEndpoint.NAME_PROPERTY.equals(key);
        }

        protected final String getOrCreateName() {
            String name = this.props.getProperty(RMIEndpoint.NAME_PROPERTY);
            if (name != null) {
                return name;
            }
            int number = INSTANCES_NUMERATOR.getAndIncrement();
            return "rmi" + (number == 0 ? "" : "-" + number);
        }

        public abstract RMIEndpoint build();
    }

    public static enum Side {
        NONE(false, false),
        CLIENT(true, false),
        SERVER(false, true),
        CLIENT_SERVER(true, true);

        private final boolean client;
        private final boolean server;

        private Side(boolean client, boolean server) {
            this.client = client;
            this.server = server;
        }

        public boolean hasClient() {
            return this.client;
        }

        public boolean hasServer() {
            return this.server;
        }

        public Side withClient() {
            return this.client ? this : (this == NONE ? CLIENT : CLIENT_SERVER);
        }

        public Side withServer() {
            return this.server ? this : (this == NONE ? SERVER : CLIENT_SERVER);
        }
    }
}

