/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.util.InvalidFormatException;
import java.util.Date;
import java.util.TimeZone;

public class TimeFormat {
    public static final TimeFormat DEFAULT = new TimeFormat(TimeZone.getDefault());
    public static final TimeFormat GMT = new TimeFormat(TimeZone.getTimeZone("GMT"));
    private final com.devexperts.util.TimeFormat instance;

    public TimeFormat(TimeZone timezone) {
        this.instance = com.devexperts.util.TimeFormat.getInstance(timezone);
    }

    public Date parseDateTime(String value) throws InvalidFormatException, NullPointerException {
        try {
            return this.instance.parse(value);
        }
        catch (com.devexperts.util.InvalidFormatException e) {
            throw new InvalidFormatException(e.getMessage(), e);
        }
    }

    public String formatDateTime(Date time) throws NullPointerException {
        return this.instance.withTimeZone().format(time);
    }

    public String formatDateTimeWithoutTimeZone(Date time) throws NullPointerException {
        return this.instance.format(time);
    }

    public String formatDateTimeWithMillis(Date time) throws NullPointerException {
        return this.instance.withTimeZone().withMillis().format(time);
    }

    public String formatDateTimeWithMillisWithoutTimeZone(Date time) throws NullPointerException {
        return this.instance.withMillis().format(time);
    }

    public TimeZone getTimeZone() {
        return this.instance.getTimeZone();
    }
}

