/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SymbolReceiver;
import com.devexperts.qd.impl.matrix.MatrixSymbolSet;
import com.devexperts.qd.util.StringUtil;
import java.util.Arrays;

public abstract class SymbolSet {
    public static SymbolSet createInstance() {
        return new MatrixSymbolSet();
    }

    public static SymbolSet copyOf(SymbolSet other) {
        SymbolSet set = SymbolSet.createInstance();
        set.addAll(other);
        return set;
    }

    protected SymbolSet() {
    }

    public abstract int size();

    public abstract String getSymbol(char[] var1, int var2, int var3);

    public abstract boolean contains(int var1, String var2);

    public abstract boolean contains(int var1, char[] var2, int var3, int var4);

    public abstract void examine(SymbolReceiver var1);

    public SymbolSet unmodifiable() {
        return this;
    }

    public boolean add(int cipher, String symbol) {
        throw new UnsupportedOperationException("unmodifiable");
    }

    public boolean add(int cipher, char[] chars, int offset, int length) {
        throw new UnsupportedOperationException("unmodifiable");
    }

    public boolean remove(int cipher, String symbol) {
        throw new UnsupportedOperationException("unmodifiable");
    }

    public boolean remove(int cipher, char[] chars, int offset, int length) {
        throw new UnsupportedOperationException("unmodifiable");
    }

    public void clear() {
        throw new UnsupportedOperationException("unmodifiable");
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void addAll(SymbolSet other) {
        other.examine(this::add);
    }

    public void retainAll(SymbolSet other) {
        this.examine((cipher, symbol) -> {
            if (!other.contains(cipher, symbol)) {
                this.remove(cipher, symbol);
            }
        });
    }

    public void retainAll(QDFilter filter) {
        this.examine((cipher, symbol) -> {
            if (!filter.accept(null, null, cipher, symbol)) {
                this.remove(cipher, symbol);
            }
        });
    }

    public boolean containsAll(SymbolSet other) {
        boolean[] result = new boolean[]{true};
        other.examine((cipher, symbol) -> {
            if (!this.contains(cipher, symbol)) {
                result[0] = false;
            }
        });
        return result[0];
    }

    public int hashCode() {
        int[] hashCode = new int[]{0};
        this.examine((cipher, symbol) -> {
            hashCode[0] = cipher != 0 ? hashCode[0] + cipher : hashCode[0] + symbol.hashCode();
        });
        return hashCode[0];
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SymbolSet)) {
            return false;
        }
        SymbolSet other = (SymbolSet)obj;
        return this.size() == other.size() && this.containsAll(other);
    }

    protected static class ListSet
    extends SymbolSet {
        private final int[] ciphers;
        private final String[] symbols;
        private final int size;

        public ListSet(SymbolSet set) {
            int[] sizes = new int[2];
            set.examine((cipher, symbol) -> {
                int n = cipher != 0 ? 0 : 1;
                sizes[n] = sizes[n] + 1;
            });
            this.ciphers = new int[sizes[0]];
            this.symbols = new String[sizes[1]];
            this.size = sizes[0] + sizes[1];
            Arrays.fill(sizes, 0);
            set.examine((cipher, symbol) -> {
                if (cipher != 0) {
                    int n = sizes[0];
                    sizes[0] = n + 1;
                    this.ciphers[n] = cipher;
                } else {
                    int n = sizes[1];
                    sizes[1] = n + 1;
                    this.symbols[n] = symbol;
                }
            });
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public String getSymbol(char[] chars, int offset, int length) {
            for (String s : this.symbols) {
                if (!StringUtil.equals(s, chars, offset, length)) continue;
                return s;
            }
            return null;
        }

        @Override
        public boolean contains(int cipher, String symbol) {
            return cipher != 0 ? this.containsCipher(cipher) : this.containsSymbol(symbol);
        }

        @Override
        public boolean contains(int cipher, char[] chars, int offset, int length) {
            return cipher != 0 ? this.containsCipher(cipher) : this.getSymbol(chars, offset, length) != null;
        }

        @Override
        public void examine(SymbolReceiver receiver) {
            for (int cipher : this.ciphers) {
                receiver.receiveSymbol(cipher, null);
            }
            for (String symbol : this.symbols) {
                receiver.receiveSymbol(0, symbol);
            }
        }

        private boolean containsCipher(int cipher) {
            for (int c : this.ciphers) {
                if (c != cipher) continue;
                return true;
            }
            return false;
        }

        private boolean containsSymbol(String symbol) {
            for (String s : this.symbols) {
                if (!s.equals(symbol)) continue;
                return true;
            }
            return false;
        }
    }
}

