/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.util.StringCache;

public class ShortString {
    private static final int CODE_00 = 12336;
    private static final int CODE_99 = 14649;
    private static final StringCache CACHE = new StringCache(239, 4);

    public static long encode(String str) {
        return str == null ? 0L : ShortString.encode(str, 0, str.length());
    }

    public static long encode(String str, int offset, int length) {
        if (length > 8) {
            throw new IllegalArgumentException("string is too long");
        }
        long code = 0L;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(offset + i);
            if (c > '\u00ff') {
                throw new IllegalArgumentException("string contains illegal character");
            }
            if (c == '\u0000') continue;
            code = code << 8 | (long)c;
        }
        return code;
    }

    public static long encode(char[] data, int offset, int length) {
        if (length > 8) {
            throw new IllegalArgumentException("string is too long");
        }
        long code = 0L;
        for (int i = 0; i < length; ++i) {
            char c = data[offset + i];
            if (c > '\u00ff') {
                throw new IllegalArgumentException("string contains illegal character");
            }
            if (c == '\u0000') continue;
            code = code << 8 | (long)c;
        }
        return code;
    }

    public static long encode(byte[] data, int offset, int length) {
        if (length > 8) {
            throw new IllegalArgumentException("string is too long");
        }
        long code = 0L;
        for (int i = 0; i < length; ++i) {
            char c = (char)(data[offset + i] & 0xFF);
            if (c == '\u0000') continue;
            code = code << 8 | (long)c;
        }
        return code;
    }

    public static String decode(long code) {
        return CACHE.getShortString(code);
    }

    public static long encodeInt(int value) {
        if (value >= 0 && value <= 9) {
            return 48 + value;
        }
        if (value >= 10 && value <= 99) {
            return (48 + value / 10 << 8) + (48 + value % 10);
        }
        if (value >= -9999999 && value <= 99999999) {
            return ShortString.encode(Integer.toString(value));
        }
        throw new IllegalArgumentException("number is out of range");
    }

    public static int decodeInt(long code) {
        if (code >= 48L && code <= 57L) {
            return (int)code - 48;
        }
        if (code >= 12336L && code <= 14649L) {
            int lastChar = (int)code & 0xFF;
            if (lastChar >= 48 && lastChar <= 57) {
                return ((int)(code >> 8) - 48) * 10 + (lastChar - 48);
            }
            throw new NumberFormatException(ShortString.decode(code));
        }
        return Integer.parseInt(ShortString.decode(code));
    }

    private ShortString() {
    }
}

