/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.QDLog;
import com.devexperts.qd.qtp.AddressSyntaxException;
import com.devexperts.qd.util.InvalidFormatException;
import com.devexperts.util.ConfigUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class QDConfig {
    public static final char ESCAPE_CHAR = '\\';

    private QDConfig() {
    }

    public static String unescape(String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            if (c == '\\' && i < n - 1) {
                c = s.charAt(++i);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String escape(String s) {
        int n = s.length();
        StringBuilder sb = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<String> splitParenthesisSeparatedString(String s) {
        if (!s.startsWith("(")) {
            return Collections.singletonList(s);
        }
        ArrayList<String> result = new ArrayList<String>();
        int cnt = 0;
        int startIndex = -1;
        int n = s.length();
        block4: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '(': {
                    if (cnt++ != 0) continue block4;
                    startIndex = i + 1;
                    continue block4;
                }
                case ')': {
                    if (cnt == 0) {
                        throw new AddressSyntaxException("Extra closing parenthesis ')' in a list");
                    }
                    if (--cnt != 0) continue block4;
                    result.add(s.substring(startIndex, i));
                    continue block4;
                }
                default: {
                    if (cnt == 0 && c > ' ') {
                        throw new AddressSyntaxException("Unexpected character '" + c + "' outside parenthesis in a list");
                    }
                    if (c != '\\') continue block4;
                    ++i;
                }
            }
        }
        if (cnt > 0) {
            throw new AddressSyntaxException("Missing closing parenthesis ')' in a list");
        }
        return result;
    }

    public static String[] splitParenthesisedStringAt(String s, char atChar) {
        ArrayList<Character> stack = new ArrayList<Character>();
        int n = s.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '(': {
                    stack.add(Character.valueOf(')'));
                    continue block6;
                }
                case '[': {
                    stack.add(Character.valueOf(']'));
                    continue block6;
                }
                case ')': 
                case ']': {
                    if (stack.isEmpty()) {
                        throw new AddressSyntaxException("Extra closing parenthesis: " + c);
                    }
                    if (((Character)stack.remove(stack.size() - 1)).charValue() == c) continue block6;
                    throw new AddressSyntaxException("Wrong closing parenthesis: " + c);
                }
                case '\\': {
                    ++i;
                    continue block6;
                }
                default: {
                    if (!stack.isEmpty() || c != atChar) continue block6;
                    return new String[]{s.substring(0, i).trim(), s.substring(i + 1).trim()};
                }
            }
        }
        return new String[]{s};
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String parseProperties(String desc, Collection<String> kvList) throws InvalidFormatException {
        desc = desc.trim();
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Character> stack = new ArrayList<Character>();
        while (true) {
            int i;
            int prop_end;
            if ((desc.endsWith(")") || desc.endsWith("]")) && !QDConfig.isEscapedCharAt(desc, desc.length() - 1)) {
                prop_end = desc.length() - 1;
                i = desc.length();
            } else {
                Collections.reverse(result);
                kvList.addAll(result);
                return desc;
            }
            block7: while (--i >= 0) {
                char c = desc.charAt(i);
                if (c == '\\' || QDConfig.isEscapedCharAt(desc, i)) continue;
                switch (c) {
                    case ']': {
                        stack.add(Character.valueOf('['));
                        break;
                    }
                    case ')': {
                        stack.add(Character.valueOf('('));
                        break;
                    }
                    case ',': {
                        if (stack.size() != 1) break;
                        result.add(desc.substring(i + 1, prop_end).trim());
                        prop_end = i;
                        break;
                    }
                    case '(': 
                    case '[': {
                        assert (!stack.isEmpty());
                        char expect = ((Character)stack.remove(stack.size() - 1)).charValue();
                        if (c != expect) {
                            throw new InvalidFormatException("Unmatched '" + c + "' in a list of properties");
                        }
                        if (!stack.isEmpty()) break;
                        result.add(desc.substring(i + 1, prop_end).trim());
                        break block7;
                    }
                }
            }
            if (i < 0) {
                throw new InvalidFormatException("Extra '" + stack.get(0) + "' in a list of properties");
            }
            desc = desc.substring(0, i).trim();
        }
    }

    private static boolean isEscapedCharAt(String s, int i) {
        int escapeCount = 0;
        while (--i >= 0 && s.charAt(i) == '\\') {
            ++escapeCount;
        }
        return escapeCount & true;
    }

    public static List<String> getProperties(Object instance) {
        return QDConfig.getProperties(instance, instance.getClass());
    }

    public static void setProperties(Object instance, List<String> kvList) throws InvalidFormatException {
        QDConfig.setProperties(instance, instance.getClass(), kvList);
    }

    public static List<String> getProperties(Object instance, Class<?> intf) {
        ArrayList<String> kvList = new ArrayList<String>();
        for (Property prop : QDConfig.getProperties(intf)) {
            String v;
            Object objValue = QDConfig.getProperty(instance, prop);
            if (objValue == null || (v = objValue.toString()).isEmpty()) continue;
            kvList.add(prop.getName() + "=" + v);
        }
        return kvList;
    }

    public static void setProperties(Object instance, Class<?> intf, List<String> kvList) throws InvalidFormatException {
        List<Property> props = QDConfig.getProperties(intf);
        for (String kv : kvList) {
            int i = kv.indexOf(61);
            String key = i < 0 ? kv : kv.substring(0, i).trim();
            String value = i < 0 ? "" : kv.substring(i + 1).trim();
            QDConfig.findAndSetProperty(instance, props, key, value);
        }
    }

    public static void setDefaultProperties(Object instance, Class<?> intf, String prefix) {
        Properties sys;
        try {
            sys = System.getProperties();
        }
        catch (SecurityException e) {
            return;
        }
        List<Property> props = QDConfig.getProperties(intf);
        String prefixWithDot = prefix + '.';
        for (String key : sys.stringPropertyNames()) {
            try {
                if (!key.startsWith(prefixWithDot)) continue;
                QDConfig.findAndSetProperty(instance, props, key.substring(prefixWithDot.length()), sys.getProperty(key));
            }
            catch (InvalidFormatException e) {
                QDLog.log.warn("Failed to set system property " + key + " for " + instance + ": " + e.getMessage());
            }
        }
    }

    public static List<Property> getProperties(Class<?> intf) {
        ArrayList<Property> props = new ArrayList<Property>();
        for (Method m : intf.getMethods()) {
            if (!m.getName().startsWith("set") || m.getParameterTypes().length != 1 || m.getReturnType() != Void.TYPE || !Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers())) continue;
            props.add(new Property(intf, m.getName().substring(3), m.getParameterTypes()[0], m));
        }
        return props;
    }

    private static void findAndSetProperty(Object instance, List<Property> props, String key, String value) {
        for (Property prop : props) {
            if (!prop.getName().equalsIgnoreCase(key)) continue;
            QDConfig.setProperty(instance, prop, value);
            return;
        }
        throw new InvalidFormatException("Property is not found: " + key);
    }

    private static Object getProperty(Object instance, Property prop) {
        Method getterMethod = prop.getGetterMethod();
        if (getterMethod == null) {
            return null;
        }
        try {
            return getterMethod.invoke(instance, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new InvalidFormatException("Property '" + prop.getName() + "': " + e.getMessage(), e);
        }
    }

    private static void setProperty(Object instance, Property prop, String value) throws InvalidFormatException {
        try {
            prop.getSetterMethod().invoke(instance, ConfigUtil.convertStringToObject(prop.getPropertyType(), value));
        }
        catch (InvalidFormatException | IllegalAccessException | InvocationTargetException e) {
            throw new InvalidFormatException("Property '" + prop.getName() + "': " + e.getMessage(), e);
        }
    }

    public static class Property {
        private final Class<?> intf;
        private final String suffix;
        private final String name;
        private final Class<?> propertyType;
        private final Method setterMethod;

        Property(Class<?> intf, String suffix, Class<?> propertyType, Method setterMethod) {
            this.intf = intf;
            this.suffix = suffix;
            this.name = Character.toLowerCase(suffix.charAt(0)) + suffix.substring(1);
            this.propertyType = propertyType;
            this.setterMethod = setterMethod;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getName() {
            return this.name;
        }

        public Class<?> getPropertyType() {
            return this.propertyType;
        }

        public Method getGetterMethod() {
            try {
                return this.intf.getMethod("get" + this.suffix, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                try {
                    return this.intf.getMethod("is" + this.suffix, new Class[0]);
                }
                catch (NoSuchMethodException e1) {
                    return null;
                }
            }
        }

        public Method getSetterMethod() {
            return this.setterMethod;
        }
    }
}

