/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.DataIterator;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.SubscriptionIterator;
import com.devexperts.qd.SubscriptionVisitor;
import com.devexperts.qd.ng.RecordBuffer;

public class LegacyIteratorUtils {
    private LegacyIteratorUtils() {
    }

    public static boolean processData(DataIterator iterator, DataVisitor visitor) {
        if (iterator instanceof RecordBuffer) {
            return ((RecordBuffer)iterator).retrieveData(visitor);
        }
        while (visitor.hasCapacity()) {
            int i;
            DataRecord record = iterator.nextRecord();
            if (record == null) {
                return false;
            }
            visitor.visitRecord(record, iterator.getCipher(), iterator.getSymbol());
            int n = record.getIntFieldCount();
            for (i = 0; i < n; ++i) {
                visitor.visitIntField(record.getIntField(i), iterator.nextIntField());
            }
            n = record.getObjFieldCount();
            for (i = 0; i < n; ++i) {
                visitor.visitObjField(record.getObjField(i), iterator.nextObjField());
            }
        }
        return true;
    }

    public static boolean processSubscription(SubscriptionIterator iterator, SubscriptionVisitor visitor) {
        if (iterator instanceof RecordBuffer) {
            return ((RecordBuffer)iterator).retrieveSubscription(visitor);
        }
        while (visitor.hasCapacity()) {
            DataRecord record = iterator.nextRecord();
            if (record == null) {
                return false;
            }
            visitor.visitRecord(record, iterator.getCipher(), iterator.getSymbol(), iterator.getTime());
        }
        return true;
    }
}

