/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.DataListener;
import com.devexperts.qd.DataProvider;
import com.devexperts.qd.DataVisitor;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.SubscriptionIterator;
import com.devexperts.qd.SubscriptionListener;
import com.devexperts.qd.SubscriptionProvider;
import com.devexperts.qd.SubscriptionVisitor;
import com.devexperts.qd.ng.AbstractRecordProvider;
import com.devexperts.qd.ng.AbstractRecordSink;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordListener;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordProvider;
import com.devexperts.qd.ng.RecordSink;
import com.devexperts.qd.ng.RecordSource;

public class LegacyAdapter {
    private static volatile boolean legacyDataVisitorWarningShown;
    private static volatile boolean legacySubscriptionVisitorWarningShown;
    private static volatile boolean legacyDataProviderWarningShown;
    private static volatile boolean legacySubscriptionProviderWarningShown;
    private static volatile boolean legacyDataListenerWarningShown;
    private static volatile boolean legacySubscriptionListenerWarningShown;
    private static volatile boolean legacySubscriptionIteratorWarningShown;

    private LegacyAdapter() {
    }

    public static RecordSink of(DataVisitor visitor) {
        if (visitor instanceof RecordSink) {
            return (RecordSink)visitor;
        }
        return LegacyAdapter.wrapDataVisitor(visitor);
    }

    public static RecordSink of(SubscriptionVisitor visitor) {
        if (visitor instanceof RecordSink) {
            return (RecordSink)visitor;
        }
        return LegacyAdapter.wrapSubscriptionVisitor(visitor);
    }

    public static RecordProvider of(DataProvider provider) {
        if (provider instanceof RecordProvider) {
            return (RecordProvider)provider;
        }
        return LegacyAdapter.wrapDataProvider(provider);
    }

    public static RecordProvider of(SubscriptionProvider provider) {
        if (provider instanceof RecordProvider) {
            return (RecordProvider)provider;
        }
        return LegacyAdapter.wrapSubscriptionProvider(provider);
    }

    public static RecordListener of(DataListener listener) {
        if (listener == null || listener instanceof RecordListener) {
            return (RecordListener)((Object)listener);
        }
        return LegacyAdapter.wrapDataListener(listener);
    }

    public static RecordListener of(SubscriptionListener listener) {
        if (listener == null || listener instanceof RecordListener) {
            return (RecordListener)((Object)listener);
        }
        return LegacyAdapter.wrapSubscriptionListener(listener);
    }

    public static RecordSource of(SubscriptionIterator iterator) {
        if (iterator == null || iterator instanceof RecordSource) {
            return (RecordSource)iterator;
        }
        return LegacyAdapter.wrapSubscriptionIterator(iterator);
    }

    public static void release(SubscriptionIterator iterator, RecordSource source) {
        if (iterator == null || iterator instanceof RecordSource || !(source instanceof RecordBuffer)) {
            return;
        }
        ((RecordBuffer)source).release();
    }

    private static RecordSink wrapDataVisitor(final DataVisitor visitor) {
        if (!legacyDataVisitorWarningShown) {
            LegacyAdapter.legacyDataVisitorWarningSync(visitor);
        }
        return new AbstractRecordSink(){

            @Override
            public boolean hasCapacity() {
                return visitor.hasCapacity();
            }

            @Override
            public void append(RecordCursor cursor) {
                cursor.examineData(visitor);
            }

            public String toString() {
                return visitor.toString();
            }
        };
    }

    private static RecordSink wrapSubscriptionVisitor(final SubscriptionVisitor visitor) {
        if (!legacySubscriptionVisitorWarningShown) {
            LegacyAdapter.legacySubscriptionVisitorWarningSync(visitor);
        }
        return new AbstractRecordSink(){

            @Override
            public boolean hasCapacity() {
                return visitor.hasCapacity();
            }

            @Override
            public void append(RecordCursor cursor) {
                cursor.examineSubscription(visitor);
            }

            public String toString() {
                return visitor.toString();
            }
        };
    }

    private static RecordProvider wrapDataProvider(final DataProvider provider) {
        if (!legacyDataProviderWarningShown) {
            LegacyAdapter.legacyDataProviderWarningSync(provider);
        }
        return new AbstractRecordProvider(){

            @Override
            public RecordMode getMode() {
                return RecordMode.DATA;
            }

            @Override
            public boolean retrieve(RecordSink sink) {
                return provider.retrieveData(sink);
            }
        };
    }

    private static RecordProvider wrapSubscriptionProvider(final SubscriptionProvider provider) {
        if (!legacySubscriptionProviderWarningShown) {
            LegacyAdapter.legacySubscriptionProviderWarningSync(provider);
        }
        return new AbstractRecordProvider(){

            @Override
            public RecordMode getMode() {
                return RecordMode.HISTORY_SUBSCRIPTION;
            }

            @Override
            public boolean retrieve(RecordSink sink) {
                return provider.retrieveSubscription(sink);
            }
        };
    }

    private static RecordListener wrapDataListener(final DataListener listener) {
        if (!legacyDataListenerWarningShown) {
            LegacyAdapter.legacyDataListenerWarningSync(listener);
        }
        return new RecordListener(){

            @Override
            public void recordsAvailable(RecordProvider provider) {
                listener.dataAvailable(provider);
            }

            public String toString() {
                return listener.toString();
            }
        };
    }

    private static RecordListener wrapSubscriptionListener(final SubscriptionListener listener) {
        if (!legacySubscriptionListenerWarningShown) {
            LegacyAdapter.legacySubscriptionListenerWarningSync(listener);
        }
        return new RecordListener(){

            @Override
            public void recordsAvailable(RecordProvider provider) {
                listener.subscriptionAvailable(provider);
            }

            public String toString() {
                return listener.toString();
            }
        };
    }

    private static RecordSource wrapSubscriptionIterator(SubscriptionIterator iterator) {
        if (!legacySubscriptionIteratorWarningShown) {
            LegacyAdapter.legacySubscriptionIteratorWarningSync(iterator);
        }
        RecordBuffer sub = RecordBuffer.getInstance(RecordMode.HISTORY_SUBSCRIPTION);
        sub.processSubscription(iterator);
        return sub;
    }

    private static synchronized void legacyDataVisitorWarningSync(DataVisitor visitor) {
        if (legacyDataVisitorWarningShown) {
            return;
        }
        legacyDataVisitorWarningShown = true;
        QDLog.log.warn("WARNING: DEPRECATED use of custom DataVisitor implementation class " + visitor.getClass().getName() + " from " + LegacyAdapter.getSource() + ". Do not implement DataVisitor interface. Use AbstractRecordSink instead.");
    }

    private static synchronized void legacySubscriptionVisitorWarningSync(SubscriptionVisitor visitor) {
        if (legacySubscriptionVisitorWarningShown) {
            return;
        }
        legacySubscriptionVisitorWarningShown = true;
        QDLog.log.warn("WARNING: DEPRECATED use of custom SubscriptionVisitor implementation class " + visitor.getClass().getName() + " from " + LegacyAdapter.getSource() + ". Do not implement SubscriptionVisitor interface. Use AbstractRecordSink instead.");
    }

    private static synchronized void legacyDataProviderWarningSync(DataProvider provider) {
        if (legacyDataProviderWarningShown) {
            return;
        }
        legacyDataProviderWarningShown = true;
        QDLog.log.warn("WARNING: DEPRECATED use of custom DataProvider implementation class " + provider.getClass().getName() + " from " + LegacyAdapter.getSource() + ". Do not implement DataProvider interface. Use AbstractRecordProvider instead.");
    }

    private static synchronized void legacySubscriptionProviderWarningSync(SubscriptionProvider provider) {
        if (legacySubscriptionProviderWarningShown) {
            return;
        }
        legacySubscriptionProviderWarningShown = true;
        QDLog.log.warn("WARNING: DEPRECATED use of custom SubscriptionProvider implementation class " + provider.getClass().getName() + " from " + LegacyAdapter.getSource() + ". Do not implement SubscriptionProvider interface. Use AbstractRecordProvider instead.");
    }

    private static synchronized void legacyDataListenerWarningSync(DataListener listener) {
        if (legacyDataListenerWarningShown) {
            return;
        }
        legacyDataListenerWarningShown = true;
        QDLog.log.warn("WARNING: DEPRECATED use of legacy DataListener interface implementation " + listener.getClass().getName() + " from " + LegacyAdapter.getSource() + ". Do not implement DataListener interface. Implement RecordListener instead.");
    }

    private static synchronized void legacySubscriptionListenerWarningSync(SubscriptionListener listener) {
        if (legacySubscriptionListenerWarningShown) {
            return;
        }
        legacySubscriptionListenerWarningShown = true;
        QDLog.log.warn("WARNING: DEPRECATED use of legacy SubscriptionListener interface implementation " + listener.getClass().getName() + " from " + LegacyAdapter.getSource() + ". Do not implement SubscriptionListener interface. Implement RecordListener instead.");
    }

    private static synchronized void legacySubscriptionIteratorWarningSync(SubscriptionIterator iterator) {
        if (legacySubscriptionIteratorWarningShown) {
            return;
        }
        legacySubscriptionIteratorWarningShown = true;
        QDLog.log.warn("WARNING: DEPRECATED use of legacy SubscriptionIterator interface implementation " + iterator.getClass().getName() + " from " + LegacyAdapter.getSource() + ". Do not implement SubscriptionIterator interface. Use RecordBuffer instead.");
    }

    private static String getSource() {
        StackTraceElement[] trace;
        for (StackTraceElement ste : trace = new Exception().getStackTrace()) {
            if (ste.getClassName().startsWith("com.devexperts.qd.")) continue;
            return ste.getClassName() + "." + ste.getMethodName();
        }
        return "<unknown>";
    }
}

