/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.util.WideDecimal;
import java.util.Arrays;

public class Decimal
extends Number
implements Comparable {
    private static final long serialVersionUID = 1418802680507197887L;
    public static final int NaN = 0;
    public static final int POSITIVE_INFINITY = 16;
    public static final int NEGATIVE_INFINITY = -16;
    public static final int ZERO = 1;
    public static final int MAX_VALUE = 0x7FFFFFF1;
    public static final int MIN_VALUE = -2147483631;
    public static final String NAN_STRING = "NaN";
    public static final String POSITIVE_INFINITY_STRING = "Infinity";
    public static final String NEGATIVE_INFINITY_STRING = "-Infinity";
    private static final char[] ZERO_CHARS;
    private static final int STD_SHIFT = 4;
    private static final int EXTRA_SHIFT = 7;
    private static final int STD_MASK = 15;
    private static final int EXTRA_MASK = 127;
    private static final int M128_FLAG = 96;
    private static final int UNITY_POWER = 9;
    private static final int MAX_STD_POWER = 15;
    private static final int MAX_EXTRA_POWER = 17;
    private static final int MAX_STD_MANTISSA = 0x7FFFFFF;
    private static final int MAX_EXTRA_MANTISSA = 0xFFFFFF;
    private static final double MAX_M128_VALUE = 131071.9960859375;
    private static final double ULP_128 = 5.0E-8;
    private static final int INF_PRECISION = -19;
    private static final int MIN_PRECISION = -8;
    private static final int MAX_STD_PRECISION = 6;
    private static final int MAX_EXTRA_PRECISION = 8;
    private static final long[] POWERS;
    private static final double[] MULTIPLIERS;
    private static final double[] DIVISORS;
    private static final double[] MAX_VALUES;
    private static final int[] EXTRA_PRECISION;
    private static final int[] EXTRA_DIVISORS;
    private static final long MAX_INTERNAL_MANTISSA = 99999999999999L;
    private static final long P7_M128_CONVERTER = 78125L;
    private static final long[] MAX_M128_INTERNAL_MANTISSA;
    private static final int[] SHIFT;
    private static final int[] PRECISION;
    private static final long[] COMPARE_POWERS;
    protected final int decimal;

    public static boolean isNaN(int decimal) {
        return decimal == 0;
    }

    public static boolean isInfinite(int decimal) {
        return decimal == 16 || decimal == -16;
    }

    public static int sign(int decimal) {
        int mantissa = decimal >> SHIFT[decimal & 0x7F];
        return mantissa > 0 ? 1 : (mantissa < 0 ? -1 : 0);
    }

    public static int neg(int decimal) {
        int negator = 1 << SHIFT[decimal & 0x7F];
        return (decimal ^ -negator) + negator;
    }

    public static int abs(int decimal) {
        return decimal >= 0 ? decimal : Decimal.neg(decimal);
    }

    public static double toDouble(int decimal) {
        int divisor;
        int power = decimal & 0xF;
        if (power == 0 && (divisor = EXTRA_DIVISORS[decimal >> 4 & 7]) >= 0) {
            return (double)(decimal >> 7) / (double)divisor;
        }
        return Decimal.toDoubleInternal(decimal >> 4, power);
    }

    private static double toDoubleInternal(int mantissa, int power) {
        return power <= 9 ? (double)mantissa * MULTIPLIERS[power] : (double)mantissa / DIVISORS[power];
    }

    public static long getDecimalMantissa(int decimal) {
        int flag = decimal & 0x7F;
        if (flag == 96) {
            return (long)(decimal >> 7) * 78125L;
        }
        return decimal >> SHIFT[flag];
    }

    public static int getDecimalPrecision(int decimal) {
        return PRECISION[decimal & 0x7F];
    }

    public static int composeDecimal(long mantissa, int precision) {
        return mantissa >= 0L ? Decimal.composeNonNegativeDecimal(mantissa, precision) : Decimal.composeNegativeDecimal(mantissa, precision);
    }

    private static int composeNegativeDecimal(long mantissa, int precision) {
        return Decimal.neg(Decimal.composeNonNegativeDecimal(mantissa == Long.MIN_VALUE ? Long.MAX_VALUE : -mantissa, precision));
    }

    private static int composeNonNegativeDecimal(long mantissa, int precision) {
        if (precision < -8) {
            return Decimal.composeLargeDecimal(mantissa, precision);
        }
        if (mantissa == 0L) {
            return 1;
        }
        while ((mantissa & 1L) == 0L && mantissa % 10L == 0L && precision > -8) {
            mantissa /= 10L;
            --precision;
        }
        if (mantissa <= 0x7FFFFFFL && precision <= 6) {
            return (int)mantissa << 4 | precision + 9;
        }
        if (mantissa <= 0xFFFFFFL && precision <= 8) {
            return (int)mantissa << 7 | precision + -5 << 4;
        }
        return Decimal.composeRoundDecimal(mantissa, precision);
    }

    private static int composeLargeDecimal(long mantissa, int precision) {
        if (precision <= -19) {
            return mantissa == 0L ? 0 : 16;
        }
        if (mantissa > 0xCCCCCCL) {
            return 16;
        }
        return (mantissa *= POWERS[-8 - precision]) > 0x7FFFFFFL ? 16 : (int)mantissa << 4 | 1;
    }

    private static int composeRoundDecimal(long mantissa, int precision) {
        long m128;
        if (precision > 9) {
            if (precision > 27) {
                return 1;
            }
            mantissa /= POWERS[precision - 9];
            precision = 9;
            if (mantissa < 5L) {
                return 1;
            }
        }
        while (mantissa > 13107199218750L) {
            mantissa /= 10L;
            --precision;
        }
        if (precision < -8) {
            return 16;
        }
        int targetPrecision = Math.min(precision, 8);
        long targetScale = POWERS[precision - targetPrecision];
        while (mantissa >= (long)(targetPrecision <= 6 ? 0x7FFFFFF : 0xFFFFFF) * targetScale + (targetScale >> 1)) {
            --targetPrecision;
            targetScale *= 10L;
        }
        if (targetPrecision < -8) {
            return 16;
        }
        long targetMantissa = (mantissa + (targetScale >> 1)) / targetScale;
        if (targetMantissa == 0L) {
            return 1;
        }
        if (precision > 3 && targetPrecision < 7 && (m128 = (mantissa * 128L + (POWERS[precision] >> 1)) / POWERS[precision]) <= 0xFFFFFFL) {
            long error = (targetMantissa * targetScale - mantissa) * 128L;
            long e128 = m128 * POWERS[precision] - mantissa * 128L;
            if (Math.abs(e128) < Math.abs(error)) {
                return (int)m128 << 7 | 0x60;
            }
        }
        return Decimal.canonicalizeRegularDecimal((int)targetMantissa, targetPrecision + 9);
    }

    public static int compose(double value) {
        return value >= 0.0 ? Decimal.composeNonNegativeInternal(value) : (value < 0.0 ? Decimal.neg(Decimal.composeNonNegativeInternal(-value)) : 0);
    }

    private static int composeNonNegativeInternal(double value) {
        int m128;
        int power = 17;
        while (value > MAX_VALUES[power]) {
            --power;
        }
        int mantissa = (int)(value * DIVISORS[power] + 0.5);
        if (mantissa == 0) {
            return power == 0 ? 16 : 1;
        }
        double error = Decimal.toDoubleInternal(mantissa, power) - value;
        if (error != 0.0 && value < 131071.9960859375 && Math.abs((double)(m128 = (int)(value * 128.0 + 0.5)) / 128.0 - value) < Math.abs(error) - 5.0E-8) {
            return m128 << 7 | 0x60;
        }
        return Decimal.canonicalizeRegularDecimal(mantissa, power);
    }

    private static int canonicalizeRegularDecimal(int mantissa, int power) {
        if (mantissa % 10000 == 0 && power > 4) {
            mantissa /= 10000;
            power -= 4;
        }
        if (mantissa % 100 == 0 && power > 2) {
            mantissa /= 100;
            power -= 2;
        }
        if (mantissa % 10 == 0 && power > 1 && (mantissa /= 10) % 10 == 0 && --power > 1) {
            mantissa /= 10;
            --power;
        }
        if (power > 15) {
            return mantissa << 7 | power - 15 + 1 << 4;
        }
        return mantissa << 4 | power;
    }

    public static int parseDecimal(String s) throws NumberFormatException {
        int n = (s = s.trim()).length();
        if (n == 0) {
            throw new NumberFormatException("Empty string");
        }
        int sign = 1;
        int i = 0;
        char c = s.charAt(0);
        switch (c) {
            case '-': {
                sign = -1;
            }
            case '+': {
                if (++i >= n) {
                    throw new NumberFormatException("No digits in '" + s + "'");
                }
                c = s.charAt(i);
            }
        }
        switch (c) {
            case 'I': 
            case 'N': {
                if (NAN_STRING.equals(s)) {
                    return 0;
                }
                if (POSITIVE_INFINITY_STRING.equals(s)) {
                    return 16;
                }
                if (!NEGATIVE_INFINITY_STRING.equals(s)) break;
                return -16;
            }
        }
        long mantissa = 0L;
        int precision = 0;
        boolean dotseen = false;
        while (true) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    long newmantissa = 10L * mantissa + (long)c - 48L;
                    if (newmantissa > 99999999999999L) {
                        --precision;
                    } else {
                        mantissa = newmantissa;
                    }
                    if (!dotseen) break;
                    ++precision;
                    break;
                }
                case '.': {
                    if (dotseen) {
                        throw new NumberFormatException("Second dot in '" + s + "'");
                    }
                    dotseen = true;
                    break;
                }
                default: {
                    throw new NumberFormatException("Illegal character in '" + s + "'");
                }
            }
            if (++i >= n) break;
            c = s.charAt(i);
        }
        int decimal = Decimal.composeNonNegativeDecimal(mantissa, precision);
        return sign > 0 ? decimal : Decimal.neg(decimal);
    }

    public static int parseDecimal(char[] chars, int offset, int count) throws NumberFormatException {
        int last;
        int i = offset;
        for (last = offset + count; i < last && chars[last - 1] <= ' '; --last) {
        }
        while (i < last && chars[i] <= ' ') {
            ++i;
        }
        if (i >= last) {
            throw new NumberFormatException("Empty string");
        }
        int sign = 1;
        char c = chars[i];
        switch (c) {
            case '-': {
                sign = -1;
            }
            case '+': {
                if (++i >= last) {
                    throw new NumberFormatException("No digits in " + Arrays.toString(chars) + " in [" + offset + ", " + (offset + count - 1) + "]");
                }
                c = chars[i];
            }
        }
        switch (c) {
            case 'I': 
            case 'N': {
                if (Decimal.equalsString(NAN_STRING, chars, i, last - i)) {
                    return 0;
                }
                if (!Decimal.equalsString(POSITIVE_INFINITY_STRING, chars, i, last - i)) break;
                return sign > 0 ? 16 : -16;
            }
        }
        long mantissa = 0L;
        int precision = 0;
        boolean dotseen = false;
        while (true) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    long newmantissa = 10L * mantissa + (long)c - 48L;
                    if (newmantissa > 99999999999999L) {
                        --precision;
                    } else {
                        mantissa = newmantissa;
                    }
                    if (!dotseen) break;
                    ++precision;
                    break;
                }
                case '.': {
                    if (dotseen) {
                        throw new NumberFormatException("Second dot in " + Arrays.toString(chars) + " in [" + offset + ", " + (offset + count - 1) + "]");
                    }
                    dotseen = true;
                    break;
                }
                default: {
                    throw new NumberFormatException("Illegal character in " + Arrays.toString(chars) + " in [" + offset + ", " + (offset + count - 1) + "]");
                }
            }
            if (++i >= last) break;
            c = chars[i];
        }
        int decimal = Decimal.composeNonNegativeDecimal(mantissa, precision);
        return sign > 0 ? decimal : Decimal.neg(decimal);
    }

    private static boolean equalsString(String s, char[] chars, int offset, int count) {
        int n = s.length();
        if (n != count) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (s.charAt(i) == chars[offset + i]) continue;
            return false;
        }
        return true;
    }

    public static String toString(int decimal) {
        long mantissa = Decimal.getDecimalMantissa(decimal);
        int precision = Decimal.getDecimalPrecision(decimal);
        if (precision <= -19) {
            return mantissa == 0L ? NAN_STRING : (mantissa > 0L ? POSITIVE_INFINITY_STRING : NEGATIVE_INFINITY_STRING);
        }
        if (mantissa == 0L) {
            return "0";
        }
        while (precision > 0 && mantissa % 10L == 0L) {
            mantissa /= 10L;
            --precision;
        }
        if (precision <= 0) {
            return Long.toString(mantissa * POWERS[-precision]);
        }
        StringBuilder sb = new StringBuilder(15);
        sb.append(mantissa);
        int first_digit = (int)(mantissa >>> 63);
        int dot_position = sb.length() - precision;
        if (dot_position <= first_digit) {
            sb.insert(first_digit, ZERO_CHARS, 0, first_digit - dot_position + 2);
        } else {
            sb.insert(dot_position, '.');
        }
        return sb.toString();
    }

    public static StringBuilder appendTo(StringBuilder sb, int decimal) {
        long mantissa = Decimal.getDecimalMantissa(decimal);
        int precision = Decimal.getDecimalPrecision(decimal);
        if (precision <= -19) {
            return sb.append(mantissa == 0L ? NAN_STRING : (mantissa > 0L ? POSITIVE_INFINITY_STRING : NEGATIVE_INFINITY_STRING));
        }
        if (mantissa == 0L) {
            return sb.append("0");
        }
        while (precision > 0 && mantissa % 10L == 0L) {
            mantissa /= 10L;
            --precision;
        }
        if (precision <= 0) {
            return sb.append(mantissa * POWERS[-precision]);
        }
        int first_digit = sb.length() + (int)(mantissa >>> 63);
        sb.append(mantissa);
        int dot_position = sb.length() - precision;
        if (dot_position <= first_digit) {
            sb.insert(first_digit, ZERO_CHARS, 0, first_digit - dot_position + 2);
        } else {
            sb.insert(dot_position, '.');
        }
        return sb;
    }

    public static int compare(int d1, int d2) {
        double v2;
        if (d1 == d2) {
            return 0;
        }
        int p1 = d1 & 0xF;
        int p2 = d2 & 0xF;
        if (p1 > 0 && p2 > 0) {
            long delta;
            if (p1 == p2) {
                return d1 > d2 ? 1 : -1;
            }
            int m1 = d1 >> 4;
            int m2 = d2 >> 4;
            long l = delta = p1 > p2 ? (long)m1 - (long)m2 * COMPARE_POWERS[p1 - p2] : (long)m1 * COMPARE_POWERS[p2 - p1] - (long)m2;
            return delta > 0L ? 1 : (delta < 0L ? -1 : 0);
        }
        if (Decimal.isNaN(d1)) {
            return 1;
        }
        if (Decimal.isNaN(d2)) {
            return -1;
        }
        double v1 = Decimal.toDouble(d1);
        if (v1 > (v2 = Decimal.toDouble(d2))) {
            return 1;
        }
        if (v1 < v2) {
            return -1;
        }
        return 0;
    }

    public static int subtract(int d1, int d2) {
        int p1 = d1 & 0xF;
        int p2 = d2 & 0xF;
        if (p1 > 0 && p2 > 0) {
            long m;
            int p;
            if (d1 == d2) {
                return 1;
            }
            int m1 = d1 >> 4;
            if (m1 == 0) {
                return Decimal.neg(d2);
            }
            int m2 = d2 >> 4;
            if (m2 == 0) {
                return d1;
            }
            if (p1 > p2) {
                p = p1;
                m = p1 - p2 <= 10 ? (long)m1 - (long)m2 * POWERS[p1 - p2] : Long.MAX_VALUE;
            } else if (p1 < p2) {
                p = p2;
                m = p2 - p1 <= 10 ? (long)m1 * POWERS[p2 - p1] - (long)m2 : Long.MAX_VALUE;
            } else {
                p = p1;
                m = m1 - m2;
            }
            if (m == 0L) {
                return 1;
            }
            if (m >= -134217727L && m <= 0x7FFFFFFL) {
                return Decimal.canonicalizeRegularDecimal((int)m, p);
            }
            if (m != Long.MAX_VALUE) {
                return Decimal.composeDecimal(m, p - 9);
            }
        }
        if (Decimal.isNaN(d1) || Decimal.isNaN(d2)) {
            return 0;
        }
        return Decimal.compose(Decimal.toDouble(d1) - Decimal.toDouble(d2));
    }

    public static int add(int d1, int d2) {
        int p1 = d1 & 0xF;
        int p2 = d2 & 0xF;
        if (p1 > 0 && p2 > 0) {
            long m;
            int p;
            int m1 = d1 >> 4;
            if (m1 == 0) {
                return d2;
            }
            int m2 = d2 >> 4;
            if (m2 == 0) {
                return d1;
            }
            if (p1 > p2) {
                p = p1;
                m = p1 - p2 <= 10 ? (long)m1 + (long)m2 * POWERS[p1 - p2] : Long.MAX_VALUE;
            } else if (p1 < p2) {
                p = p2;
                m = p2 - p1 <= 10 ? (long)m1 * POWERS[p2 - p1] + (long)m2 : Long.MAX_VALUE;
            } else {
                p = p1;
                m = m1 + m2;
            }
            if (m == 0L) {
                return 1;
            }
            if (m >= -134217727L && m <= 0x7FFFFFFL) {
                return Decimal.canonicalizeRegularDecimal((int)m, p);
            }
            if (m != Long.MAX_VALUE) {
                return Decimal.composeDecimal(m, p - 9);
            }
        }
        if (Decimal.isNaN(d1) || Decimal.isNaN(d2)) {
            return 0;
        }
        return Decimal.compose(Decimal.toDouble(d1) + Decimal.toDouble(d2));
    }

    public static int average(int d1, int d2) {
        int p1 = d1 & 0xF;
        int p2 = d2 & 0xF;
        if (p1 > 0 && p2 > 0) {
            long m;
            int p;
            int m1 = d1 >> 4;
            int m2 = d2 >> 4;
            if (p1 > p2) {
                p = p1;
                m = p1 - p2 <= 10 ? (long)m1 + (long)m2 * POWERS[p1 - p2] : Long.MAX_VALUE;
            } else if (p1 < p2) {
                p = p2;
                m = p2 - p1 <= 10 ? (long)m1 * POWERS[p2 - p1] + (long)m2 : Long.MAX_VALUE;
            } else {
                p = p1;
                m = m1 + m2;
            }
            if (m == 0L) {
                return 1;
            }
            if (m != Long.MAX_VALUE) {
                if ((m & 1L) != 0L) {
                    m *= 5L;
                    ++p;
                } else {
                    m >>= 1;
                }
                if (m >= -134217727L && m <= 0x7FFFFFFL && p <= 15) {
                    return Decimal.canonicalizeRegularDecimal((int)m, p);
                }
                return Decimal.composeDecimal(m, p - 9);
            }
        }
        if (Decimal.isNaN(d1) || Decimal.isNaN(d2)) {
            return 0;
        }
        return Decimal.compose((Decimal.toDouble(d1) + Decimal.toDouble(d2)) * 0.5);
    }

    public static int wideToTiny(long wide) {
        return Decimal.composeDecimal(WideDecimal.getSignificand(wide), WideDecimal.getScale(wide));
    }

    public static long tinyToWide(int tiny) {
        int scale = Decimal.getDecimalPrecision(tiny);
        if (scale <= -19) {
            scale = -128;
        }
        return WideDecimal.composeWide(Decimal.getDecimalMantissa(tiny), scale);
    }

    public Decimal(int decimal) {
        this.decimal = decimal;
    }

    public Decimal(String s) throws NumberFormatException {
        this.decimal = Decimal.parseDecimal(s);
    }

    @Override
    public byte byteValue() {
        return (byte)Decimal.toDouble(this.decimal);
    }

    @Override
    public short shortValue() {
        return (short)Decimal.toDouble(this.decimal);
    }

    @Override
    public int intValue() {
        return (int)Decimal.toDouble(this.decimal);
    }

    @Override
    public long longValue() {
        return (long)Decimal.toDouble(this.decimal);
    }

    @Override
    public float floatValue() {
        return (float)Decimal.toDouble(this.decimal);
    }

    @Override
    public double doubleValue() {
        return Decimal.toDouble(this.decimal);
    }

    public String toString() {
        return Decimal.toString(this.decimal);
    }

    public int hashCode() {
        return this.decimal;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Decimal && this.decimal == ((Decimal)obj).decimal;
    }

    public int compareTo(Object obj) {
        return obj == this ? 0 : Decimal.compare(this.decimal, ((Decimal)obj).decimal);
    }

    static {
        int i;
        ZERO_CHARS = "0.000000000000000000".toCharArray();
        POWERS = new long[19];
        MULTIPLIERS = new double[18];
        DIVISORS = new double[18];
        MAX_VALUES = new double[18];
        EXTRA_PRECISION = new int[]{-19, -19, 7, 8, -19, -19, 7, -19};
        EXTRA_DIVISORS = new int[]{-1, -1, 10000000, 100000000, 0, 0, 128, -1};
        MAX_M128_INTERNAL_MANTISSA = new long[17];
        SHIFT = new int[128];
        PRECISION = new int[128];
        Decimal.POWERS[0] = 1L;
        for (i = 1; i < POWERS.length; ++i) {
            Decimal.POWERS[i] = POWERS[i - 1] * 10L;
        }
        Decimal.MULTIPLIERS[0] = Double.POSITIVE_INFINITY;
        Decimal.DIVISORS[0] = 0.0;
        for (i = 1; i <= 9; ++i) {
            Decimal.MULTIPLIERS[i] = POWERS[9 - i];
            Decimal.DIVISORS[i] = 1.0 / (double)POWERS[9 - i];
        }
        for (i = 10; i <= 17; ++i) {
            Decimal.MULTIPLIERS[i] = 1.0 / (double)POWERS[i - 9];
            Decimal.DIVISORS[i] = POWERS[i - 9];
        }
        for (i = 0; i <= 17; ++i) {
            Decimal.MAX_VALUES[i] = ((double)(i <= 15 ? 0x7FFFFFF : 0xFFFFFF) + 0.499) * MULTIPLIERS[i];
        }
        for (i = 0; i < SHIFT.length; ++i) {
            int power = i & 0xF;
            Decimal.SHIFT[i] = power != 0 || EXTRA_DIVISORS[i >> 4] < 0 ? 4 : 7;
            Decimal.PRECISION[i] = power != 0 ? power - 9 : EXTRA_PRECISION[i >> 4];
        }
        long cur = 1310719921875L;
        if (cur > 99999999999999L) {
            throw new AssertionError((Object)"MAX_INTERNAL_MANTISSA is too small");
        }
        Arrays.fill(MAX_M128_INTERNAL_MANTISSA, -1L);
        for (int i2 = 16; i2 >= 0 && cur > 0L; cur /= 10L, --i2) {
            Decimal.MAX_M128_INTERNAL_MANTISSA[i2] = cur;
        }
        COMPARE_POWERS = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 1000000000L, 1000000000L, 1000000000L, 1000000000L, 1000000000L, 1000000000L};
    }
}

