/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.DataIterator;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.SubscriptionFilter;

public class DataIterators {
    private DataIterators() {
    }

    public static void skipRecord(DataRecord record, DataIterator it) {
        int i = record.getIntFieldCount();
        while (--i >= 0) {
            it.nextIntField();
        }
        i = record.getObjFieldCount();
        while (--i >= 0) {
            it.nextObjField();
        }
    }

    public static DataIterator filter(DataIterator it, SubscriptionFilter filter) {
        if (filter == null) {
            return it;
        }
        return new FilteringDataIterator(it, filter);
    }

    private static class FilteringDataIterator
    implements DataIterator {
        private final DataIterator it;
        private final SubscriptionFilter filter;

        public FilteringDataIterator(DataIterator it, SubscriptionFilter filter) {
            this.it = it;
            this.filter = filter;
        }

        @Override
        public int getCipher() {
            return this.it.getCipher();
        }

        @Override
        public String getSymbol() {
            return this.it.getSymbol();
        }

        @Override
        public DataRecord nextRecord() {
            DataRecord record = this.it.nextRecord();
            while (record != null && !this.filter.acceptRecord(record, this.it.getCipher(), this.it.getSymbol())) {
                DataIterators.skipRecord(record, this.it);
                record = this.it.nextRecord();
            }
            return record;
        }

        @Override
        public int nextIntField() {
            return this.it.nextIntField();
        }

        @Override
        public Object nextObjField() {
            return this.it.nextObjField();
        }
    }
}

