/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.ng.AbstractRecordProvider;
import com.devexperts.qd.ng.RecordListener;
import com.devexperts.qd.ng.RecordMode;
import com.devexperts.qd.ng.RecordProvider;
import com.devexperts.qd.ng.RecordSink;
import java.util.concurrent.atomic.AtomicBoolean;

public final class CompositeRecordProvider
extends AbstractRecordProvider {
    private final RecordMode mode;
    private final Handler[] handlers;
    private volatile RecordListener listener;
    private final AtomicBoolean notified = new AtomicBoolean();

    public CompositeRecordProvider(RecordProvider ... providers) {
        this.mode = providers[0].getMode();
        this.handlers = new Handler[providers.length];
        for (int i = 0; i < providers.length; ++i) {
            this.handlers[i] = new Handler(providers[i]);
        }
    }

    @Override
    public RecordMode getMode() {
        return this.mode;
    }

    @Override
    public boolean retrieve(RecordSink sink) {
        this.notified.set(false);
        for (Handler handler : this.handlers) {
            if (!handler.retrieve(sink)) continue;
            this.notified.set(true);
            return true;
        }
        return false;
    }

    @Override
    public void setRecordListener(RecordListener listener) {
        RecordListener old = this.listener;
        if (old == listener) {
            return;
        }
        this.listener = listener;
        this.notified.set(false);
        if (old != null) {
            this.clearListeners();
        }
        if (listener != null) {
            this.setListeners();
        }
    }

    private void setListeners() {
        for (Handler handler : this.handlers) {
            handler.provider.setRecordListener(handler);
        }
    }

    private void clearListeners() {
        for (Handler handler : this.handlers) {
            handler.provider.setRecordListener(null);
        }
    }

    private void notifyListenerIfNeeded() {
        RecordListener listener;
        if (this.notified.compareAndSet(false, true) && (listener = this.listener) != null) {
            listener.recordsAvailable(this);
        }
    }

    private class Handler
    implements RecordListener {
        final RecordProvider provider;
        volatile boolean available;

        Handler(RecordProvider provider) {
            this.provider = provider;
        }

        @Override
        public void recordsAvailable(RecordProvider provider) {
            this.available = true;
            CompositeRecordProvider.this.notifyListenerIfNeeded();
        }

        boolean retrieve(RecordSink sink) {
            if (this.available) {
                this.available = false;
                if (this.provider.retrieve(sink)) {
                    this.available = true;
                    return true;
                }
            }
            return false;
        }
    }
}

