/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.util.ByteArrayBuffer;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UTFDataFormatException;

@Deprecated
public class ByteArrayDataOutput
extends ByteArrayBuffer
implements DataOutput {
    public byte[] toByteArray() {
        byte[] data = new byte[this.position];
        if (this.position > 0) {
            System.arraycopy(this.buffer, 0, data, 0, this.position);
        }
        return data;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.position >= this.limit) {
            this.expandLimit(this.position + 1);
        }
        this.buffer[this.position++] = (byte)b;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position + len > this.limit) {
            this.expandLimit(this.position + len);
        }
        System.arraycopy(b, off, this.buffer, this.position, len);
        this.position += len;
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        if (this.position >= this.limit) {
            this.expandLimit(this.position + 1);
        }
        this.buffer[this.position++] = v ? (byte)1 : 0;
    }

    @Override
    public void writeByte(int v) throws IOException {
        if (this.position >= this.limit) {
            this.expandLimit(this.position + 1);
        }
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public void writeShort(int v) throws IOException {
        if (this.position + 2 > this.limit) {
            this.expandLimit(this.position + 2);
        }
        this.buffer[this.position++] = (byte)(v >>> 8);
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public void writeChar(int v) throws IOException {
        if (this.position + 2 > this.limit) {
            this.expandLimit(this.position + 2);
        }
        this.buffer[this.position++] = (byte)(v >>> 8);
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public void writeInt(int v) throws IOException {
        if (this.position + 4 > this.limit) {
            this.expandLimit(this.position + 4);
        }
        this.buffer[this.position++] = (byte)(v >>> 24);
        this.buffer[this.position++] = (byte)(v >>> 16);
        this.buffer[this.position++] = (byte)(v >>> 8);
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public void writeLong(long v) throws IOException {
        if (this.position + 8 > this.limit) {
            this.expandLimit(this.position + 8);
        }
        this.buffer[this.position++] = (byte)(v >>> 56);
        this.buffer[this.position++] = (byte)(v >>> 48);
        this.buffer[this.position++] = (byte)(v >>> 40);
        this.buffer[this.position++] = (byte)(v >>> 32);
        this.buffer[this.position++] = (byte)(v >>> 24);
        this.buffer[this.position++] = (byte)(v >>> 16);
        this.buffer[this.position++] = (byte)(v >>> 8);
        this.buffer[this.position++] = (byte)v;
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String str) throws IOException {
        int strlen = str.length();
        if (this.position + strlen > this.limit) {
            this.expandLimit(this.position + strlen);
        }
        for (int i = 0; i < strlen; ++i) {
            this.buffer[this.position++] = (byte)str.charAt(i);
        }
    }

    @Override
    public void writeChars(String str) throws IOException {
        int strlen = str.length();
        if (this.position + (strlen << 1) > this.limit) {
            this.expandLimit(this.position + (strlen << 1));
        }
        for (int i = 0; i < strlen; ++i) {
            char c = str.charAt(i);
            this.buffer[this.position++] = (byte)(c >>> 8);
            this.buffer[this.position++] = (byte)c;
        }
    }

    @Override
    public void writeUTF(String str) throws IOException {
        char c;
        int strlen = str.length();
        int utflen = 0;
        int i = strlen;
        while (--i >= 0) {
            c = str.charAt(i);
            if (c <= '\u007f' && c > '\u0000') {
                ++utflen;
                continue;
            }
            if (c <= '\u07ff') {
                utflen += 2;
                continue;
            }
            utflen += 3;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException();
        }
        if (this.position + utflen + 2 > this.limit) {
            this.expandLimit(this.position + utflen + 2);
        }
        this.buffer[this.position++] = (byte)(utflen >>> 8);
        this.buffer[this.position++] = (byte)utflen;
        for (i = 0; i < strlen; ++i) {
            c = str.charAt(i);
            if (c <= '\u007f' && c > '\u0000') {
                this.buffer[this.position++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                this.buffer[this.position++] = (byte)(0xC0 | c >> 6);
                this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            this.buffer[this.position++] = (byte)(0xE0 | c >> 12);
            this.buffer[this.position++] = (byte)(0x80 | c >> 6 & 0x3F);
            this.buffer[this.position++] = (byte)(0x80 | c & 0x3F);
        }
    }
}

