/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import com.devexperts.qd.util.ByteArrayBuffer;
import com.devexperts.util.ArrayUtil;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.UTFDataFormatException;

@Deprecated
public class ByteArrayDataInput
extends ByteArrayBuffer
implements DataInput {
    private static EndOfBufferException eob_instance;

    protected int readAvailableBytes(int n) throws IOException {
        return 0;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        if ((off | len | off + len | b.length - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.position + len > this.limit) {
            this.expandLimit(this.position + len);
        }
        System.arraycopy(this.buffer, this.position, b, off, len);
        this.position += len;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int total;
        if (n <= 0) {
            return 0;
        }
        if (n <= this.limit - this.position) {
            this.position += n;
            return n;
        }
        int cur = 0;
        for (total = this.limit - this.position; total < n && (cur = this.readAvailableBytes(n - total)) > 0; total += cur) {
        }
        this.position += total;
        return total;
    }

    @Override
    public boolean readBoolean() throws IOException {
        if (this.position >= this.limit) {
            this.expandLimit(this.position + 1);
        }
        return this.buffer[this.position++] != 0;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.position >= this.limit) {
            this.expandLimit(this.position + 1);
        }
        return this.buffer[this.position++];
    }

    @Override
    public int readUnsignedByte() throws IOException {
        if (this.position >= this.limit) {
            this.expandLimit(this.position + 1);
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        if (this.position + 2 > this.limit) {
            this.expandLimit(this.position + 2);
        }
        return (short)((this.buffer[this.position++] << 8) + (this.buffer[this.position++] & 0xFF));
    }

    @Override
    public int readUnsignedShort() throws IOException {
        if (this.position + 2 > this.limit) {
            this.expandLimit(this.position + 2);
        }
        return ((this.buffer[this.position++] & 0xFF) << 8) + (this.buffer[this.position++] & 0xFF);
    }

    @Override
    public char readChar() throws IOException {
        if (this.position + 2 > this.limit) {
            this.expandLimit(this.position + 2);
        }
        return (char)((this.buffer[this.position++] << 8) + (this.buffer[this.position++] & 0xFF));
    }

    @Override
    public int readInt() throws IOException {
        if (this.position + 4 > this.limit) {
            this.expandLimit(this.position + 4);
        }
        return (this.buffer[this.position++] << 24) + ((this.buffer[this.position++] & 0xFF) << 16) + ((this.buffer[this.position++] & 0xFF) << 8) + (this.buffer[this.position++] & 0xFF);
    }

    @Override
    public long readLong() throws IOException {
        if (this.position + 8 > this.limit) {
            this.expandLimit(this.position + 8);
        }
        return (((long)this.buffer[this.position++] & 0xFFL) << 56) + (((long)this.buffer[this.position++] & 0xFFL) << 48) + (((long)this.buffer[this.position++] & 0xFFL) << 40) + (((long)this.buffer[this.position++] & 0xFFL) << 32) + (((long)this.buffer[this.position++] & 0xFFL) << 24) + (((long)this.buffer[this.position++] & 0xFFL) << 16) + (((long)this.buffer[this.position++] & 0xFFL) << 8) + ((long)this.buffer[this.position++] & 0xFFL);
    }

    @Override
    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() throws IOException {
        int c;
        if (this.position >= this.limit && this.readAvailableBytes(1) <= 0) {
            return null;
        }
        char[] chars = new char[128];
        int count = 0;
        while ((this.position < this.limit || this.readAvailableBytes(1) > 0) && (c = this.buffer[this.position++] & 0xFF) != 10) {
            if (c == 13) {
                if (this.position >= this.limit && this.readAvailableBytes(1) <= 0 || this.buffer[this.position] != 10) break;
                ++this.position;
                break;
            }
            if (count >= chars.length) {
                chars = ArrayUtil.grow(chars, 0);
            }
            chars[count++] = (char)c;
        }
        return new String(chars, 0, count);
    }

    @Override
    public String readUTF() throws IOException {
        int utflen = this.readUnsignedShort();
        int end_position = this.position + utflen;
        if (end_position < this.limit) {
            this.expandLimit(end_position);
        }
        char[] chars = new char[utflen];
        int count = 0;
        while (this.position < end_position) {
            int c;
            if ((c = this.buffer[this.position++]) < 0) {
                if ((c & 0xE0) == 192) {
                    c &= 0x1F;
                } else if ((c & 0xF0) == 224) {
                    if (this.position >= end_position || (this.buffer[this.position] & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    c = ((c & 0xF) << 6) + (this.buffer[this.position++] & 0x3F);
                } else {
                    throw new UTFDataFormatException();
                }
                if (this.position >= end_position || (this.buffer[this.position] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                c = (c << 6) + (this.buffer[this.position++] & 0x3F);
            }
            chars[count++] = (char)c;
        }
        return new String(chars, 0, count);
    }

    @Override
    public void expandLimit(int required_limit) throws IOException {
        if (eob_instance == null) {
            eob_instance = new EndOfBufferException();
        }
        throw eob_instance;
    }

    public static class EndOfBufferException
    extends EOFException {
        public EndOfBufferException() {
            super("End of buffer");
        }
    }
}

