/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.util;

import java.io.IOException;
import java.io.Serializable;

public class ByteArrayBuffer
implements Serializable {
    protected byte[] buffer;
    protected int position;
    protected int limit;

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void setBuffer(byte[] new_buffer) {
        this.buffer = new_buffer;
        this.position = 0;
        this.limit = this.buffer == null ? 0 : this.buffer.length;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int new_position) {
        if (new_position < 0 || new_position > this.limit) {
            throw new IllegalArgumentException();
        }
        this.position = new_position;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int new_limit) {
        int capacity;
        int n = capacity = this.buffer == null ? 0 : this.buffer.length;
        if (new_limit < 0 || new_limit > capacity) {
            throw new IllegalArgumentException();
        }
        this.limit = new_limit;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
    }

    public void ensureCapacity(int required_capacity) {
        int capacity;
        int n = capacity = this.buffer == null ? 0 : this.buffer.length;
        if (required_capacity <= capacity) {
            return;
        }
        int new_capacity = Math.max(Math.max(1024, capacity << 1), required_capacity);
        byte[] new_buffer = new byte[new_capacity];
        if (this.buffer != null && capacity > 0) {
            System.arraycopy(this.buffer, 0, new_buffer, 0, capacity);
        }
        this.buffer = new_buffer;
    }

    public void clear() {
        this.position = 0;
        this.limit = this.buffer == null ? 0 : this.buffer.length;
    }

    public void copy(int source_position, int dest_position, int length) {
        int capacity;
        int n = capacity = this.buffer == null ? 0 : this.buffer.length;
        if ((source_position | dest_position | length | source_position + length | dest_position + length | capacity - (source_position + length) | capacity - (dest_position + length)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.buffer != null && source_position != dest_position && length > 0) {
            System.arraycopy(this.buffer, source_position, this.buffer, dest_position, length);
        }
    }

    public void expandLimit(int required_limit) throws IOException {
        if (required_limit <= this.limit) {
            return;
        }
        this.ensureCapacity(required_limit);
        this.limit = this.buffer == null ? 0 : this.buffer.length;
    }
}

