/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.stats;

import com.devexperts.qd.DataScheme;
import com.devexperts.util.ArrayUtil;
import com.devexperts.util.AtomicArrays;
import com.devexperts.util.JMXNameBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class QDStats {
    public static final QDStats VOID = new VoidQDStats(SType.VOID);
    protected static final int KIND_ADDED = 0;
    protected static final int KIND_CHANGED = 1;
    protected static final int KIND_FILTERED = 2;
    protected static final int KIND_REMOVED = 3;
    protected static final int KIND_SIZE = Integer.MAX_VALUE;
    protected static final int MEM_EXTRA = 0;
    protected static final int MEM_STRIDE = 4;
    protected static final int KIND_IO_READ_RTTS = 0;
    protected static final int KIND_IO_WRITE_RTTS = 1;
    protected static final int KIND_IO_SUB_READ_RECORDS = 2;
    protected static final int KIND_IO_SUB_WRITE_RECORDS = 3;
    protected static final int KIND_IO_DATA_READ_RECORDS = 4;
    protected static final int KIND_IO_DATA_WRITE_RECORDS = 5;
    protected static final int KIND_IO_DATA_READ_LAGS = 6;
    protected static final int KIND_IO_DATA_WRITE_LAGS = 7;
    protected static final int KIND_IO_READ_BYTES = 8;
    protected static final int KIND_IO_WRITE_BYTES = 9;
    protected static final int IO_EXTRA = 8;
    protected static final int IO_STRIDE = 2;
    public static final int FLAG_MEM = 1;
    public static final int FLAG_IO = 2;
    public static final int FLAG_RID = 4;
    public static final int FLAG_COLLECTION_OF_ANYTHING = 8;
    public static final int FLAG_COLLECTION_OF_SELF = 16;
    public static final int FLAG_COUNT = 32;
    protected static final QDStats[] EMPTY_CHILDREN = new QDStats[0];
    private QDStats parent;
    private StatsLock lock;
    private SType type;
    private int rid_count;
    private DataScheme scheme;
    private boolean closed;
    private int rid_stride;
    private long[] stats;
    private String key_properties;
    private boolean sum_mode;
    private volatile QDStats[] children = EMPTY_CHILDREN;
    private int last_child_index;
    private int parent_child_index = -1;
    private int uncle_child_index = -1;

    public static QDStats createNamedVoid(String key_properties) {
        return key_properties == null ? VOID : VOID.create(SType.VOID, key_properties);
    }

    protected QDStats getParent() {
        return this.parent;
    }

    protected Object getLock() {
        return this.lock;
    }

    public SType getType() {
        return this.type;
    }

    public int getRidCount() {
        return this.rid_count;
    }

    public DataScheme getScheme() {
        return this.scheme;
    }

    protected QDStats[] getChildren() {
        return this.children;
    }

    public String getKeyProperties() {
        return this.key_properties;
    }

    public String getFullKeyProperties() {
        ArrayList<QDStats> list = new ArrayList<QDStats>();
        for (QDStats stats = this; stats != null; stats = stats.getParent()) {
            list.add(stats);
        }
        JMXNameBuilder nb = new JMXNameBuilder();
        int i = list.size();
        while (--i >= 0) {
            nb.appendKeyProperties(((QDStats)list.get((int)i)).key_properties);
        }
        return nb.toString();
    }

    protected boolean isSumMode() {
        return this.sum_mode;
    }

    protected boolean hasSum(QDStats parent, QDStats child) {
        return parent.type.isCollectionOf(child.type);
    }

    private void initStats(QDStats parent, StatsLock lock, SType type, int rid_count) {
        if (this.lock != null) {
            throw new IllegalStateException("Already initialized");
        }
        if (lock == null) {
            throw new NullPointerException("lock is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        if (rid_count < 0) {
            throw new IllegalArgumentException("rid_count is out of range");
        }
        if (parent != null && lock != parent.lock) {
            throw new IllegalArgumentException("lock does not match parent.lock");
        }
        if (parent != null && rid_count != 0 && rid_count != parent.rid_count) {
            throw new IllegalArgumentException("non-zero rid_count does not match parent.rid_count");
        }
        this.parent = parent;
        this.lock = lock;
        this.type = type;
        this.rid_count = rid_count;
        this.rid_stride = type.isRidType() && rid_count > 0 ? type.getStride() : 0;
        this.stats = type == SType.VOID && parent != null ? parent.stats : new long[type.getExtra() + type.getStride() + rid_count * this.rid_stride];
    }

    protected void initStats(QDStats parent, StatsLock lock, SType type, DataScheme scheme) {
        this.initStats(parent, lock, type, scheme == null ? 0 : scheme.getRecordCount());
        this.scheme = scheme;
    }

    protected void closeStats() {
        if (this.type.isMemType() && this.type.isRidType()) {
            for (int i = 0; i <= this.rid_count; ++i) {
                this.stats[i * this.rid_stride + 3] = this.stats[i * this.rid_stride + 0];
            }
        }
    }

    protected void addClosedStats(QDStats child) {
        int i;
        if ((this.type.flag & 3) != (child.type.flag & 3)) {
            return;
        }
        long[] childStats = child.stats;
        int typeExtra = this.type.getExtra();
        int typeStride = this.type.getStride();
        for (i = 0; i < typeExtra + typeStride; ++i) {
            int n = i;
            this.stats[n] = this.stats[n] + childStats[i];
        }
        if (child.rid_stride > 0) {
            for (i = 0; i < child.rid_count; ++i) {
                for (int j = 0; j < child.rid_stride; ++j) {
                    int n = typeExtra + (i + 1) * this.rid_stride + j;
                    this.stats[n] = this.stats[n] + childStats[typeExtra + (i + 1) * child.rid_stride + j];
                }
            }
        }
    }

    protected void addChild(QDStats child) {
        if (this.children == EMPTY_CHILDREN) {
            this.children = new QDStats[2];
        }
        this.last_child_index = ArrayUtil.findFreeIndex(this.children, this.last_child_index, 0);
        if (this.last_child_index >= this.children.length) {
            this.children = ArrayUtil.grow(this.children, 0);
        }
        if (child.parent_child_index < 0) {
            child.parent_child_index = this.last_child_index;
            this.children[child.parent_child_index] = child;
        } else if (child.uncle_child_index < 0) {
            child.uncle_child_index = this.last_child_index;
            this.children[child.uncle_child_index] = child;
        } else {
            throw new IllegalStateException("too many parents");
        }
    }

    protected boolean removeChild(QDStats child) {
        if (child.parent_child_index >= 0 && child.parent_child_index < this.children.length && this.children[child.parent_child_index] == child) {
            this.children[child.parent_child_index] = null;
            return true;
        }
        if (child.uncle_child_index >= 0 && child.uncle_child_index < this.children.length && this.children[child.uncle_child_index] == child) {
            this.children[child.uncle_child_index] = null;
            return true;
        }
        return false;
    }

    protected void closeChildren() {
        if (this.children == EMPTY_CHILDREN) {
            return;
        }
        for (QDStats child : this.children) {
            if (child == null) continue;
            this.closeInternal(child);
        }
        this.children = EMPTY_CHILDREN;
    }

    protected QDStats newInstance(SType type, boolean unmanaged) {
        return new QDStats();
    }

    protected QDStats createInternal(SType type, String key_properties, boolean sum_mode, int rid_count, DataScheme scheme) {
        if (this.closed) {
            return VOID;
        }
        QDStats child = this.newInstance(type, key_properties == null && !sum_mode);
        child.sum_mode = sum_mode;
        this.initChild(child, type, key_properties, rid_count, scheme);
        this.addChild(child);
        if (this.parent != null && this.hasSum(this.parent, this)) {
            QDStats pc = this.parent.get(type);
            if (pc == null) {
                pc = this.parent.createInternal(type, null, true, this.parent.rid_count, this.parent.scheme);
            }
            pc.addChild(child);
        }
        return child;
    }

    protected void initChild(QDStats child, SType type, String key_properties, int rid_count, DataScheme scheme) {
        JMXNameBuilder.validateKeyProperties(key_properties);
        child.key_properties = key_properties;
        if (scheme != null) {
            child.initStats(this, this.lock, type, scheme);
        } else {
            child.initStats(this, this.lock, type, rid_count);
        }
    }

    protected void closeInternal(QDStats child) {
        QDStats pc;
        if (child.parent != this || !this.removeChild(child)) {
            return;
        }
        child.closeImpl();
        child.closeChildren();
        child.closeStats();
        child.parent = null;
        if (this.parent != null && this.hasSum(this.parent, this) && (pc = this.parent.get(child.type)) != null && pc.removeChild(child)) {
            pc.addClosedStats(child);
            return;
        }
        this.addClosedStats(child);
    }

    public final void updateIOReadBytes(long bytes) {
        this.stats[8] = this.stats[8] + bytes;
    }

    public final void updateIOReadRecordBytes(int rid, long bytes) {
        int n = 8 + (rid + 1) * this.rid_stride;
        this.stats[n] = this.stats[n] + bytes;
        this.stats[8] = this.stats[8] - bytes;
    }

    public final void updateIOReadSubRecord() {
        this.stats[2] = this.stats[2] + 1L;
    }

    public final void updateIOReadDataRecord() {
        this.stats[4] = this.stats[4] + 1L;
    }

    public final void updateIOReadRtts(int rtt) {
        this.stats[0] = this.stats[0] + (long)rtt;
    }

    public final void updateIOReadDataLags(long sumLag) {
        this.stats[6] = this.stats[6] + sumLag;
    }

    public final void updateIOWriteBytes(long bytes) {
        this.stats[9] = this.stats[9] + bytes;
    }

    public final void updateIOWriteRecordBytes(int rid, long bytes) {
        int n = 9 + (rid + 1) * this.rid_stride;
        this.stats[n] = this.stats[n] + bytes;
        this.stats[9] = this.stats[9] - bytes;
    }

    public final void updateIOWriteSubRecord() {
        this.stats[3] = this.stats[3] + 1L;
    }

    public final void updateIOWriteDataRecord() {
        this.stats[5] = this.stats[5] + 1L;
    }

    public final void updateIOWriteRtts(int rtt) {
        this.stats[1] = this.stats[1] + (long)rtt;
    }

    public final void updateIOWriteDataLags(long sumLag) {
        this.stats[7] = this.stats[7] + sumLag;
    }

    public final void updateAdded(int rid) {
        int n = 0 + (rid + 1) * this.rid_stride;
        this.stats[n] = this.stats[n] + 1L;
    }

    public final void updateChanged(int rid) {
        int n = 1 + (rid + 1) * this.rid_stride;
        this.stats[n] = this.stats[n] + 1L;
    }

    public final void updateFiltered(int rid) {
        int n = 2 + (rid + 1) * this.rid_stride;
        this.stats[n] = this.stats[n] + 1L;
    }

    public final void updateRemoved(int rid) {
        int n = 3 + (rid + 1) * this.rid_stride;
        this.stats[n] = this.stats[n] + 1L;
    }

    public final void updateRemoved(int rid, int count) {
        int n = 3 + (rid + 1) * this.rid_stride;
        this.stats[n] = this.stats[n] + (long)count;
    }

    public long getValue(SValue value, boolean localOnly) {
        if (value.getKind() == Integer.MAX_VALUE) {
            long removed = this.getValueImpl(SValue.RID_REMOVED, localOnly);
            return this.getValueImpl(SValue.RID_ADDED, localOnly) - removed;
        }
        return this.getValueImpl(value, localOnly);
    }

    private long getValueImpl(SValue value, boolean localOnly) {
        QDStats[] children;
        long v = AtomicArrays.INSTANCE.getVolatileLong(this.stats, value.getKind());
        if (value.isRid()) {
            int i = this.rid_count;
            while (--i >= 0) {
                v += AtomicArrays.INSTANCE.getVolatileLong(this.stats, value.getKind() + (i + 1) * this.rid_stride);
            }
        }
        if (localOnly) {
            return v;
        }
        for (QDStats child : children = this.children) {
            if (child == null) continue;
            v += child.getValueImpl(value, this.hasSum(this, child) && !this.sum_mode);
        }
        return v;
    }

    public void addValues(SValue value, boolean localOnly, long[] dest) {
        QDStats[] children;
        int i;
        if (!value.isRid()) {
            throw new IllegalArgumentException("this method is only for rid values");
        }
        if (value.getKind() == Integer.MAX_VALUE) {
            i = this.rid_count;
            while (--i >= 0) {
                long removed = AtomicArrays.INSTANCE.getVolatileLong(this.stats, 3 + (i + 1) * this.rid_stride);
                int n = i;
                dest[n] = dest[n] + (AtomicArrays.INSTANCE.getVolatileLong(this.stats, 0 + (i + 1) * this.rid_stride) - removed);
            }
        } else {
            i = this.rid_count;
            while (--i >= 0) {
                int n = i;
                dest[n] = dest[n] + AtomicArrays.INSTANCE.getVolatileLong(this.stats, value.getKind() + (i + 1) * this.rid_stride);
            }
        }
        if (localOnly) {
            return;
        }
        for (QDStats child : children = this.children) {
            if (child == null) continue;
            child.addValues(value, this.hasSum(this, child) && !this.sum_mode, dest);
        }
    }

    public long getValue(SValue value) {
        return this.getValue(value, false);
    }

    public QDStats() {
    }

    public QDStats(String key_properties) {
        JMXNameBuilder.validateKeyProperties(key_properties);
        this.key_properties = key_properties;
    }

    public QDStats(SType type) {
        this.initRoot(type, null);
    }

    public QDStats(SType type, DataScheme scheme) {
        this.initRoot(type, scheme);
    }

    public void initRoot(SType type, int rid_count) {
        this.initStats(null, new StatsLock(), type, rid_count);
    }

    public void initRoot(SType type, DataScheme scheme) {
        this.initStats(null, new StatsLock(), type, scheme);
    }

    public QDStats get(SType type) {
        QDStats[] children;
        for (QDStats child : children = this.children) {
            if (child == null || child.type != type) continue;
            return child;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDStats getOrCreate(SType type) {
        StatsLock statsLock = this.lock;
        synchronized (statsLock) {
            QDStats child = this.get(type);
            if (child == null) {
                child = this.create(type);
            }
            return child;
        }
    }

    public QDStats getOrVoid(SType type) {
        QDStats child = this.get(type);
        if (child == null) {
            child = VOID;
        }
        return child;
    }

    public final QDStats create(SType type) {
        return this.create(type, null);
    }

    public final QDStats create(SType type, String key_properties) {
        return this.create(type, key_properties, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDStats create(SType type, String key_properties, boolean useRid) {
        StatsLock statsLock = this.lock;
        synchronized (statsLock) {
            return this.createInternal(type, key_properties, false, useRid ? this.rid_count : 0, useRid ? this.scheme : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        StatsLock statsLock = this.lock;
        synchronized (statsLock) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.parent != null) {
                this.parent.closeInternal(this);
            } else {
                this.closeImpl();
                this.closeChildren();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{type=" + this.type + (this.sum_mode ? ",sum" : "") + (this.closed ? ",closed" : "") + "}[" + this.getFullKeyProperties() + "]";
    }

    protected void closeImpl() {
    }

    public void addMBean(String type, Object mbean) {
    }

    public static String quoteKeyPropertyValue(String value) {
        return JMXNameBuilder.quoteKeyPropertyValue(value);
    }

    private static class VoidQDStats
    extends QDStats {
        VoidQDStats() {
        }

        VoidQDStats(SType type) {
            super(type);
        }

        @Override
        public long getValue(SValue value, boolean localOnly) {
            return 0L;
        }

        @Override
        public void addValues(SValue value, boolean localOnly, long[] dest) {
        }

        @Override
        public QDStats get(SType type) {
            return this;
        }

        @Override
        public QDStats create(SType type, String key_properties, boolean useRid) {
            if (key_properties == null) {
                return VOID;
            }
            if (key_properties.equals(this.getKeyProperties())) {
                return this;
            }
            VoidQDStats result = new VoidQDStats();
            this.initChild(result, SType.VOID, key_properties, 0, null);
            return result;
        }

        @Override
        public void close() {
        }
    }

    protected static final class StatsLock {
        protected StatsLock() {
        }
    }

    public static class SType {
        public static final SType VOID = new SType("Void", 0, new SType[0]);
        public static final SType ANY = new SType("Any", 8, new SType[0]);
        public static final SType UNIQUE_SUB = new SType("UniqueSub", 5, new SType[0]);
        public static final SType STORAGE_DATA = new SType("StorageData", 5, new SType[0]);
        public static final SType AGENT = new SType("Agent", 0, new SType[0]);
        public static final SType AGENT_DATA = new SType("AgentData", 5, new SType[0]);
        public static final SType AGENT_SUB = new SType("AgentSub", 5, new SType[0]);
        public static final SType DISTRIBUTOR = new SType("Distributor", 0, new SType[0]);
        public static final SType DISTRIBUTOR_ASUB = new SType("DistributorASub", 5, new SType[0]);
        public static final SType DISTRIBUTOR_RSUB = new SType("DistributorRSub", 5, new SType[0]);
        public static final SType TICKER = new SType("Ticker", 16, AGENT, DISTRIBUTOR);
        public static final SType STREAM = new SType("Stream", 16, AGENT, DISTRIBUTOR);
        public static final SType HISTORY = new SType("History", 16, AGENT, DISTRIBUTOR);
        public static final SType HTTP_CONNECTOR = new SType("HttpConnector", 6, new SType[0]);
        public static final SType QD_SERVLET = new SType("QDServlet", 6, new SType[0]);
        public static final SType CLIENT_SOCKET_CONNECTOR = new SType("ClientSocketConnector", 6, new SType[0]);
        public static final SType SERVER_SOCKET_CONNECTOR = new SType("ServerSocketConnector", 6, new SType[0]);
        public static final SType CONNECTION = new SType("Connection", 6, new SType[0]);
        public static final SType CONNECTIONS = new SType("Connections", 6, CONNECTION);
        public static final SType CLIENT_SOCKET = CLIENT_SOCKET_CONNECTOR;
        protected final String name;
        protected final int flag;
        protected final List<SType> collection_of;

        public SType(String name, int flag, SType ... collection_of) {
            this.name = name;
            this.flag = flag;
            this.collection_of = collection_of.length == 0 ? Collections.emptyList() : Arrays.asList(collection_of);
        }

        public String getName() {
            return this.name;
        }

        public int getFlag() {
            return this.flag;
        }

        public boolean isCollectionOf(SType type) {
            return (this.flag & 8) != 0 || this.collection_of.contains(type) || (this.flag & 0x10) != 0 && type == this;
        }

        public boolean isMemType() {
            return (this.flag & 1) != 0;
        }

        public boolean isIOType() {
            return (this.flag & 2) != 0;
        }

        public boolean isRidType() {
            return (this.flag & 4) != 0;
        }

        public int getExtra() {
            if (this.isIOType()) {
                return 8;
            }
            if (this.isMemType()) {
                return 0;
            }
            return Math.max(8, 0);
        }

        public int getStride() {
            if (this.isIOType()) {
                return 2;
            }
            if (this.isMemType()) {
                return 4;
            }
            return Math.max(2, 4);
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class SValue {
        private static int value_count;
        private static SValue[] values;
        public static final SValue IO_READ_RTTS;
        public static final SValue IO_WRITE_RTTS;
        public static final SValue IO_SUB_READ_RECORDS;
        public static final SValue IO_SUB_WRITE_RECORDS;
        public static final SValue IO_DATA_READ_RECORDS;
        public static final SValue IO_DATA_WRITE_RECORDS;
        public static final SValue IO_DATA_READ_LAGS;
        public static final SValue IO_DATA_WRITE_LAGS;
        public static final SValue IO_READ_BYTES;
        public static final SValue IO_WRITE_BYTES;
        public static final SValue RID_ADDED;
        public static final SValue RID_CHANGED;
        public static final SValue RID_FILTERED;
        public static final SValue RID_REMOVED;
        public static final SValue RID_SIZE;
        private final String name;
        private final int flag;
        private final int kind;

        public static int getValueCount() {
            return value_count;
        }

        public static SValue getValue(int index) {
            return values[index];
        }

        private SValue(String name, int flag, int kind) {
            this.name = name;
            this.flag = flag;
            this.kind = kind;
            if (value_count >= values.length) {
                values = ArrayUtil.grow(values, 0);
            }
            SValue.values[SValue.value_count++] = this;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRid() {
            return this.isMem() ? this.kind >= 0 : this.kind >= 8;
        }

        public boolean isMem() {
            return this.flag == 1;
        }

        public boolean supportsFlag(int flag) {
            return (this.flag & flag) != 0;
        }

        public String toString() {
            return this.name;
        }

        int getKind() {
            return this.kind;
        }

        public static SValue valueOf(String name) {
            for (int i = 0; i < value_count; ++i) {
                if (!name.equals(SValue.values[i].name)) continue;
                return values[i];
            }
            throw new IllegalArgumentException("SType name not found: " + name);
        }

        static {
            values = new SValue[11];
            IO_READ_RTTS = new SValue("IOReadRtts", 2, 0);
            IO_WRITE_RTTS = new SValue("IOWriteRtts", 2, 1);
            IO_SUB_READ_RECORDS = new SValue("IOSubReadRecords", 2, 2);
            IO_SUB_WRITE_RECORDS = new SValue("IOSubWriteRecords", 2, 3);
            IO_DATA_READ_RECORDS = new SValue("IODataReadRecords", 2, 4);
            IO_DATA_WRITE_RECORDS = new SValue("IODataWriteRecords", 2, 5);
            IO_DATA_READ_LAGS = new SValue("IODataReadLags", 2, 6);
            IO_DATA_WRITE_LAGS = new SValue("IODataWriteLags", 2, 7);
            IO_READ_BYTES = new SValue("IOReadBytes", 2, 8);
            IO_WRITE_BYTES = new SValue("IOWriteBytes", 2, 9);
            RID_ADDED = new SValue("RecordAdded", 1, 0);
            RID_CHANGED = new SValue("RecordChanged", 1, 1);
            RID_FILTERED = new SValue("RecordFiltered", 1, 2);
            RID_REMOVED = new SValue("RecordRemoved", 1, 3);
            RID_SIZE = new SValue("RecordSize", 1, Integer.MAX_VALUE);
        }
    }
}

