/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.stats;

import com.devexperts.util.JMXNameBuilder;

class JMXStatsNameBuilder
extends JMXNameBuilder {
    private String type;
    private StringBuilder id = new StringBuilder();
    private boolean firstId = true;

    JMXStatsNameBuilder(String domain) {
        super(domain);
    }

    public void insertId(int i) {
        if (this.firstId) {
            this.firstId = false;
        } else {
            this.id.insert(0, '.');
        }
        if (i > 0) {
            this.id.insert(0, i);
        }
        if (i >= 10) {
            int max = 100;
            char letter = 'A';
            while (i >= max) {
                max *= 10;
                letter = (char)(letter + '\u0001');
            }
            this.id.insert(0, letter);
        }
    }

    public void insertSumModeFlag() {
        this.id.insert(0, '#');
    }

    public void doneId() {
        if (this.type != null) {
            int len = this.id.length();
            if (len > 0 && this.id.charAt(len - 1) != '#') {
                if (this.id.charAt(len - 1) == '.') {
                    this.id.setCharAt(len - 1, '-');
                } else {
                    this.id.append('+');
                }
            }
            if (len == 0) {
                this.id.append('!');
            }
            this.id.append(this.type);
        }
        this.append("id", this.id.toString());
    }

    public void appendType(String type) {
        if (this.type == null) {
            this.type = type;
        }
    }

    @Override
    public void append(String key, String rawValue) {
        if (key.equals("type")) {
            this.appendType(rawValue);
        } else {
            super.append(key, rawValue);
        }
    }
}

