/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.qd.spi;

import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SpecificSubscriptionFilter;
import com.devexperts.qd.SubscriptionFilter;
import com.devexperts.qd.SubscriptionFilterFactory;
import com.devexperts.qd.kit.CompositeFilters;
import com.devexperts.qd.kit.FilterSyntaxException;
import com.devexperts.qd.spi.DataSchemeService;
import com.devexperts.qd.spi.QDFilterContext;
import com.devexperts.services.Service;
import com.devexperts.services.SupersedesService;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Service(combineMethod="combineFactories")
@SupersedesService(value=SubscriptionFilterFactory.class, adapterMethod="fromFilterFactory")
public abstract class QDFilterFactory
implements SubscriptionFilterFactory,
DataSchemeService {
    private volatile DataScheme scheme;

    protected QDFilterFactory() {
    }

    protected QDFilterFactory(DataScheme scheme) {
        this.scheme = scheme;
    }

    public final DataScheme getScheme() {
        return this.scheme;
    }

    @Override
    public void setScheme(DataScheme scheme) {
        if (scheme == null) {
            throw new NullPointerException();
        }
        if (this.scheme == scheme) {
            return;
        }
        this.setSchemeSync(scheme);
    }

    private synchronized void setSchemeSync(DataScheme scheme) {
        if (this.scheme != null && this.scheme != scheme) {
            throw new IllegalStateException("Different scheme is already set");
        }
        this.scheme = scheme;
    }

    public abstract QDFilter createFilter(String var1);

    public QDFilter createFilter(String spec, QDFilterContext context) {
        return this.createFilter(spec);
    }

    @Override
    public final SubscriptionFilter createFilter(String spec, SubscriptionFilter chainedFilter) {
        QDFilter filter = this.createFilter(spec);
        if (filter == null) {
            throw new FilterSyntaxException("Unrecognized filter spec: " + spec);
        }
        return CompositeFilters.makeAnd((SubscriptionFilter)filter, chainedFilter);
    }

    public Map<String, String> describeFilters() {
        return QDFilterFactory.describeImpl(this);
    }

    public static QDFilterFactory fromFilterFactory(SubscriptionFilterFactory filterFactory) {
        return filterFactory instanceof QDFilterFactory ? (QDFilterFactory)filterFactory : new Adapter(filterFactory);
    }

    public static QDFilterFactory combineFactories(List<QDFilterFactory> factories) {
        return new Combined(factories);
    }

    private static Map<String, String> describeImpl(SubscriptionFilterFactory filterFactory) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Field f : filterFactory.getClass().getDeclaredFields()) {
            SpecificSubscriptionFilter filterAnnotation;
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !f.getType().equals(String.class) || (filterAnnotation = f.getAnnotation(SpecificSubscriptionFilter.class)) == null) continue;
            try {
                result.put((String)f.get(null), filterAnnotation.value());
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return result;
    }

    private static class Adapter
    extends QDFilterFactory {
        private final SubscriptionFilterFactory filterFactory;

        Adapter(SubscriptionFilterFactory filterFactory) {
            this.filterFactory = filterFactory;
        }

        @Override
        public QDFilter createFilter(String spec) {
            SubscriptionFilter filter = this.filterFactory.createFilter(spec, null);
            return filter == null ? null : QDFilter.fromFilter(filter, this.getScheme());
        }

        @Override
        public Map<String, String> describeFilters() {
            return QDFilterFactory.describeImpl(this.filterFactory);
        }
    }

    private static class Combined
    extends QDFilterFactory {
        private final List<QDFilterFactory> factories;

        Combined(List<QDFilterFactory> factories) {
            this.factories = factories;
        }

        @Override
        public void setScheme(DataScheme scheme) {
            super.setScheme(scheme);
            for (QDFilterFactory factory : this.factories) {
                factory.setScheme(scheme);
            }
        }

        @Override
        public QDFilter createFilter(String spec) {
            for (QDFilterFactory factory : this.factories) {
                QDFilter filter = factory.createFilter(spec);
                if (filter == null) continue;
                return filter;
            }
            return null;
        }

        @Override
        public QDFilter createFilter(String spec, QDFilterContext context) {
            for (QDFilterFactory factory : this.factories) {
                QDFilter filter = factory.createFilter(spec, context);
                if (filter == null) continue;
                return filter;
            }
            return null;
        }

        @Override
        public Map<String, String> describeFilters() {
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (QDFilterFactory factory : this.factories) {
                for (Map.Entry<String, String> entry : factory.describeFilters().entrySet()) {
                    if (result.containsKey(entry.getKey())) continue;
                    result.put(entry.getKey(), entry.getValue());
                }
            }
            return result;
        }
    }
}

